<?php

include "db.class.php";
include "html.class.php";
$html = new html();
$db = new db();

$latest_sensor_res = $db->exec_query('sensors_data', ['*'], '', '', '', '', 1, "ORDER BY record_id DESC LIMIT 1");
$sensor_data = $latest_sensor_res->fetch_assoc();
?>
<style>
    body {
        margin: 0px;
        color: black;
        background-color: white;
        display: flex;
        flex-direction: column;
        align-items: stretch;
        font-family: Arial, Helvetica, sans-serif;
        touch-action: manipulation;

    }

    .header_div {
        position: relative;
        width: 100%;
        height: fit-content;
        background-color: darkgray;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: space-around;
        padding: 10px;
        flex-wrap: wrap;
        align-content: center;
    }

    h2 {
        color: black;
        font-size: 4vw;
    }

    .graphs {
        width: 100%;
        background-color: white;
        color: black;
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 10px;
    }

    canvas {
        width: 100%;
        height: 25px;
        /* half the original height */
        margin: 10px 0;
    }

    .blocks {
        display: flex;
        flex-direction: column;
        align-content: space-around;
        flex-wrap: nowrap;
        align-items: center;
        width: 40%;
    }

    .live_data {
        width: 100%;
        display: none;
        /* height: 80%; */
        margin-bottom: 29vw;
        position: relative;
    }

    .graph_data {
        width: 100%;
        display: none;
        /* height: 80%; */
        margin-bottom: 29vw;
        position: relative;
    }

    .footer {
        width: 100%;
        height: fit-content;
        background-color: darkgray;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: space-around;
        padding: 10px;
        flex-wrap: wrap;
        align-content: center;
        position: fixed;
        bottom: 0;
    }

    .button {
        background-color: #4CAF50;
        border: none;
        color: white;
        padding: 10vw 10vw;
        text-align: center;
        text-decoration: none;
        display: flex;
        font-size: 3vw;
        margin: 0.2vw 0.2vw;
        height: 5vw;
        cursor: pointer;
        align-content: center;
        justify-content: center;
        align-items: center;
        border-radius: 2vw;
        transition: all 0.2s ease-in-out;
    }

    .button:active {
        background-color: #3e8e41;
        box-shadow: 0px 2px 4px rgba(0, 0, 0, 0.2);
        transform: translateY(2px);
    }

    .graph_dates_bar {
        display: flex;
        flex-direction: row;
        background: grey;
        width: 100%;
        padding: 3vw;
        justify-content: space-evenly;
        align-items: center;

    }

    .inputs {
        padding: 2vw;
        font-size: 3vw;
    }
</style>
<html>

<head>
</head>

<body>
    <div class="live_data" id="live_data">
        <div class='header_div'>
            <div class="item" style="width: 80%;">
                <h1>Onsite Data</h1>
            </div>
            <div class="mobile_friendly">
                <div class="item">
                    <h2>Water</h2>
                    <?php echo $html->generateCircularProgressBar(0, 1000, ($sensor_data['pulses'] * 2.2 / 1000), "L", 2); ?>
                </div>
                <div class="item">
                    <h2>Temp</h2>
                    <?php echo $html->generateCircularProgressBar(0, 50, $sensor_data['temp'], "C", 2); ?>
                </div>
                <div class="item">
                    <h2>Humid</h2>
                    <?php echo $html->generateCircularProgressBar(0, 100, $sensor_data['humidity'], "%"); ?>
                </div>
                <div class="item">
                    <h2>Soil Moist.</h2>
                    <?php echo $html->generateCircularProgressBar(0, 1000, $sensor_data['moisture_1'], ""); ?>
                </div>
                <!-- <div class="item">
                    <h2>UV</h2>
                    <?php //echo $html->generateCircularProgressBar(0, 11, $sensor_data['weather_uv'], ""); ?>
                </div> -->
                <!-- <div class="item">
                    <h2>Pressure</h2>
                    <?php //echo $html->generateCircularProgressBar(950, 1040, $sensor_data['weather_pressure'], ""); ?>
                </div> -->
            </div>
        </div>
        <div class='header_div'>
            <div class="item" style="width: 80%;">
                <h1>Weather Data</h1>
            </div>
            <div class="mobile_friendly">
                <div class="item">
                    <h2>WEATHER</h2>
                    <span style='color:blue; font-size: 4vw;'><?php echo $sensor_data['weather_type']; ?></span>
                </div>
                <div class="item">
                    <h2>Rain: <?php echo $sensor_data['chanceofrain']; ?></h2>
                </div>
                <div class="item">
                    <h2>Temp</h2>
                    <?php echo $html->generateCircularProgressBar(0, 50, $sensor_data['weather_temp'], "C", 2); ?>
                </div>
                <div class="item">
                    <h2>Feels Like</h2>
                    <?php echo $html->generateCircularProgressBar(0, 50, $sensor_data['weather_feels_like'], "C"); ?>
                </div>
                <div class="item">
                    <h2>Preasure</h2>
                    <?php echo $html->generateCircularProgressBar(900, 1100, $sensor_data['weather_pressure'], ""); ?>
                </div>
                <div class="item">
                    <h2>Humidity</h2>
                    <?php echo $html->generateCircularProgressBar(0, 100, $sensor_data['weather_humidity'], ""); ?>
                </div>
                <div class="item">
                    <h2>UV</h2>
                    <?php echo $html->generateCircularProgressBar(0, 11, $sensor_data['weather_uv'], ""); ?>
                </div>
            </div>
        </div>
        <style>
            .mobile_friendly {
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                flex-direction: row;
            }

            .item {
                width: calc(50% - 0.5vw);
                background-color: white;
                margin: 0.5vw;
                padding: 1vw;
                display: flex;
                width: 40%;
                flex-direction: column;
                border: 3px solid #61ab64;
                align-items: center;
                color: black;
                justify-content: center;
                /* background-color: white; */
                border-radius: 2vw;
            }

            .item h1 {
                font-size: 6vw;
            }

            .item h2 {
                font-size: 4vw;
            }

            .item span {
                font-size: 1.5vw;
            }

            .item canvas {
                width: 100%;
                height: 100%;
            }

            .item .progress {
                width: 100%;
                height: 100%;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: center;
            }

            .item .progress span {
                font-size: 1.5vw;
            }
        </style>
    </div>
    <div class="graph_data" id="graph_data">
        <div class="graph_dates_bar">
            <input type="datetime-local" class="inputs" id="from_date" />
            <input type="datetime-local" class="inputs" id="to_date" />
            <input type="submit" class="inputs" value="SEARCH" onclick="searchGraphs()" />

            <script>
                function unloadCanvases() {
                    const canvasIds = ['literesChart', 'tempChart', 'humidityChart', 'pressureChart', 'uvChart'];
                    canvasIds.forEach(id => {
                        const oldCanvas = document.getElementById(id);
                        oldCanvas.parentNode.removeChild(oldCanvas);
                        const newCanvas = document.createElement('canvas');
                        newCanvas.id = id;
                        document.querySelector('.graphs').appendChild(newCanvas);
                    });
                }

                function searchGraphs() {
                    var fromDate = document.getElementById('from_date').value;
                    var toDate = document.getElementById('to_date').value;

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "graph_ajax.php", true);
                    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                    xhr.send("from_date=" + fromDate + "&to_date=" + toDate);
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4 && xhr.status == 200) {
                            console.log(xhr.responseText);

                            unloadCanvases();
                            var response = JSON.parse(xhr.responseText);
                            var temp = response.temp;
                            var temp_weather = response.temp_weather;
                            var humidity = response.humidity;
                            var humidity_weather = response.humidity_weather;
                            var literes = response.literes;
                            var pressure = response.pressure;
                            var pressure_2 = response.pressure_2;
                            var uv = response.uv;
                            var uv_2 = response.uv_2;
                            index = 0;
                            var literes_date = [];
                            var literes_data = [];
                            while (index < literes.length) {
                                literes_date.push(literes[index][0]);
                                literes_data.push(literes[index][1]);
                                index++;
                            }
                            const literesCtx = document.getElementById('literesChart').getContext('2d');
                            new Chart(literesCtx, {
                                type: 'line',
                                data: {
                                    labels: literes_date,
                                    datasets: [{
                                        label: 'Literes',
                                        data: literes_data,
                                        backgroundColor: ['rgba(255, 99, 132, 0.2)'],
                                        borderColor: ['rgba(255, 99, 132, 1)'],
                                        borderWidth: 1
                                    }]
                                },
                                options: {
                                    scales: {
                                        y: { beginAtZero: true }
                                    }
                                }
                            });
                            index = 0;
                            var temp_date = [];
                            var temp_data = [];
                            while (index < temp.length) {
                                temp_date.push(temp[index][0]);
                                temp_data.push(temp[index][1]);
                                index++;
                            }
                            const tempCtx = document.getElementById('tempChart').getContext('2d');
                            new Chart(tempCtx, {
                                type: 'line',
                                data: {
                                    labels: temp_date,
                                    datasets: [{
                                        label: 'Temp',
                                        data: temp_data,
                                        backgroundColor: ['rgba(54, 162, 235, 0.2)'],
                                        borderColor: ['rgba(54, 162, 235, 1)'],
                                        borderWidth: 1
                                    }]
                                },
                                options: {
                                    scales: {
                                        y: { beginAtZero: true }
                                    }
                                }
                            });

                            index = 0;
                            var humidity_date = [];
                            var humidity_data = [];
                            while (index < humidity.length) {
                                humidity_date.push(humidity[index][0]);
                                humidity_data.push(humidity[index][1]);
                                index++;
                            }
                            const humidityCtx = document.getElementById('humidityChart').getContext('2d');
                            new Chart(humidityCtx, {
                                type: 'line',
                                data: {
                                    labels: humidity_date,
                                    datasets: [{
                                        label: 'Humidity',
                                        data: humidity_data,
                                        backgroundColor: ['rgba(255, 206, 86, 0.2)'],
                                        borderColor: ['rgba(255, 206, 86, 1)'],
                                        borderWidth: 1
                                    }]
                                },
                                options: {
                                    scales: {
                                        y: { beginAtZero: true }
                                    }
                                }
                            });

                            index = 0;
                            var pressure_date = [];
                            var pressure_data = [];
                            while (index < pressure.length) {
                                pressure_date.push(pressure[index][0]);
                                pressure_data.push(pressure[index][1]);
                                index++;
                            }
                            const pressureCtx = document.getElementById('pressureChart').getContext('2d');
                            new Chart(pressureCtx, {
                                type: 'line',
                                data: {
                                    labels: pressure_date,
                                    datasets: [{
                                        label: 'Pressure',
                                        data: pressure_data,
                                        backgroundColor: ['rgba(75, 192, 192, 0.2)'],
                                        borderColor: ['rgba(75, 192, 192, 1)'],
                                        borderWidth: 1
                                    }]
                                },
                                options: {
                                    scales: {
                                        y: { beginAtZero: true }
                                    }
                                }
                            });

                            index = 0;
                            var uv_date = [];
                            var uv_data = [];
                            while (index < uv.length) {
                                uv_date.push(uv[index][0]);
                                uv_data.push(uv[index][1]);
                                index++;
                            }
                            const uvCtx = document.getElementById('uvChart').getContext('2d');
                            new Chart(uvCtx, {
                                type: 'line',
                                data: {
                                    labels: uv_date,
                                    datasets: [{
                                        label: 'UV',
                                        data: uv_data,
                                        backgroundColor: ['rgba(153, 102, 255, 0.2)'],
                                        borderColor: ['rgba(153, 102, 255, 1)'],
                                        borderWidth: 1
                                    }]
                                },
                                options: {
                                    scales: {
                                        y: { beginAtZero: true }
                                    }
                                }
                            });
                        }
                    }
                }
            </script>
        </div>
        <div class='graphs'>
            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
            <canvas id="literesChart"></canvas>
            <canvas id="tempChart"></canvas>
            <canvas id="humidityChart"></canvas>
            <canvas id="pressureChart"></canvas>
            <canvas id="uvChart"></canvas>
            <script>

            </script>
        </div>
    </div>
    <div class="action" id="action">
        <div class='header_div'>
            <div class="item" style="width: 80%;">
                <h1>Create Action</h1>
            </div>
            <div class="mobile_friendly">
                <div class="item" style="width: 100%;">
                    <input type="number" id="liters" placeholder="Liters"
                        style="width: 100%; height: 15vw; font-size: 3vw; padding: 1vw; margin: 1vw 0; border-radius: 2vw; border: 1px solid black;">

                    <input type="submit" id="liters_submit" onclick="liters_submit()" value="Submit"
                        style="width: 100%; height: 15vw; font-size: 3vw; background-color: #4CAF50; color: white; padding: 1vw; margin: 1vw 0; border: none; border-radius: 2vw; cursor: pointer; transition: all 0.2s ease-in-out;">

                    <!-- js and ajax -->

                </div>
            </div>
        </div>

    </div>
    <div class="footer">
        <div class="button" onclick="open_live()">
            LIVE
        </div>
        <div class="button" onclick="open_graph()">
            GRAPH
        </div>
        <div class="button" onclick="open_action()">
            ACTION
        </div>

    </div>
</body>

</html>

<script>
    function liters_submit() {
        var liters = document.getElementById("liters").value;

        var xhr = new XMLHttpRequest();
        xhr.open("POST", "liters.php", true);
        xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhr.send("liters=" + liters);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                document.getElementById("liters").value = '';
                console.log(xhr.responseText);
            }
        }
    }

    function open_live() {
        document.getElementById("live_data").style.display = "block";
        document.getElementById("graph_data").style.display = "none";
        document.getElementById("action").style.display = "none";
    }

    function open_graph() {
        document.getElementById("live_data").style.display = "none";
        document.getElementById("graph_data").style.display = "block";
        document.getElementById("action").style.display = "none";
    }

    function open_action() {
        document.getElementById("action").style.display = "block";
        document.getElementById("live_data").style.display = "none";
        document.getElementById("graph_data").style.display = "none";
    }

</script>