<?php

include "../../classes/autoload.php";

$html = new html("JOB CARDS");
$app_feature = new app_features();

$db = new db();
$job_Card_res = $db->query("job_cards", "SELECT * FROM job_cards WHERE record_id = '{$_GET['record_id']}'");
$job_Card = $job_Card_res->fetch_assoc();

$job_card_no = substr($job_Card['job_card_no'], 0, 2) . "-" . substr($job_Card['job_card_no'], 2);

$app = new inner_app();
$app->quick_bar("/app/job_cards");
$app->app_start();
$app_functions = new app_features();
$iframe_popup = new iframe_popup();
?>

<script>
    function get_subcategories(input, i) {
        var category_id = input.value;
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                document.getElementById('file_subcategory_' + i).innerHTML = this.responseText;
            }
        };
        xhttp.open("POST", "file_subcategories.ajax.php", true);
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhttp.send("file_category_id=" + category_id);

    }
</script>

<form id="job_card_form" method="POST" action="update_job_card.php" enctype="multipart/form-data">
    <div class="column width_80 background_1 border_radius">
        <h1>EDIT JOB CARD</h1>
        <div class="row width_90 border_2 padding">
            <div class="column width_50 ">
                <label>Job Card No</label>
                <input type="text" class="width_80" id='job_card_no' readonly required name='job_card_no'
                    value="<?php echo $job_card_no; ?>" />
                <input type="text" class="width_80" id='record_id' readonly hidden required name='record_id'
                    value="<?php echo $job_Card['record_id']; ?>" />
                <label>Date Opened</label>
                <input type="date" class="width_80" id='date_opened' required name='date_opened'
                    value="<?php echo $job_Card['date_opened']; ?>" />
                <label>Date Required</label>
                <input type="date" class="width_80" id='date_required' required name="date_required"
                    value="<?php echo $job_Card['date_required']; ?>" />
                <label>Rep / Originator</label>
                <select class="width_80" id='rep_originator' required name='rep_originator'>
                    <option value="">SELECT A USER</option>
                    <?php $app_feature->get_users_list(); ?>
                </select>
                <script>
                    document.getElementById('rep_originator').value = "<?php echo $job_Card['rep_originator']; ?>";
                </script>
            </div>
            <div class="column width_50 ">
                <label>Costing Amount</label>
                <input type="text" step="0.01" class="width_80" id='costing_amount' name='costing_amount'
                    value="R <?php echo number_format((float) $job_Card['costing'], 2); ?>"
                    onkeyup="number_formater(this)" />
                <label>Quote No</label>
                <input type="text" class="width_80" id='quote_number' name='quote_number'
                    value="<?php echo $job_Card['quote_number']; ?>" />
                <label>Quote Amount</label>
                <input type="text" step="0.01" class="width_80" id='quote_amount' name="quote_amount"
                    value="R <?php echo number_format((float) $job_Card['quote_amount'], 2); ?>"
                    onkeyup="number_formater(this)" />
                <label>Invoice No</label>
                <input type="text" class="width_80" id='invoice_number' name='invoice_number'
                    value="<?php echo $job_Card['invoice_number']; ?>" />
                <label>Invoice Amount</label>
                <input type="text" step="0.01" class="width_80" id='invoice_amount' name='invoice_amount'
                    value="R <?php echo number_format((float) $job_Card['invoice_amount'], 2); ?>"
                    onkeyup="number_formater(this)" />
            </div>

            <script>
                function number_formater(input) {
                    // Remove everything except digits and decimal
                    let value = input.value.replace(/[^0-9.]/g, '');

                    // Split into whole and decimal
                    let parts = value.split('.');
                    let whole = parts[0];
                    let decimal = parts.length > 1 ? '.' + parts[1].substring(0, 2) : ''; // limit 2 decimals

                    // Add thousand separators to whole number
                    whole = whole.replace(/\B(?=(\d{3})+(?!\d))/g, ",");

                    // Ensure R in front
                    input.value = "R " + whole + decimal;
                }
            </script>

        </div>
        <div class="column width_90 border_2 padding" id="client_div" style="height: 100px; overflow: hidden;">
            <i class="fa-solid fa-plus" style="font-size:2em; color:black;" onclick="open_close('client_div',this)"></i>
            <h1>CLIENT DETAILS</h1>

            <div class="row width_100 padding   " style="border-bottom: 1px solid #f78c42;">
                <div class="column width_100">
                    <label>Company name</label>
                    <input type="text" class="width_80" id='company_name' name='company_name'
                        value="<?php echo $job_Card['company_name']; ?>" />
                </div>
                <div class="column width_100">
                    <label>Account Number</label>
                    <input type="text" class="width_80" id='account_no' name='account_no'
                        value="<?php echo $job_Card['account_no']; ?>" />
                </div>
                <div class="column width_100">
                    <label>Vat Number</label>
                    <input type="text" class="width_80" id='vat_no' name='vat_no'
                        value="<?php echo $job_Card['vat_no']; ?>" />
                </div>
                <div class="column width_100">
                    <label>Order Number</label>
                    <input type="text" class="width_80" id='customer_order_no' name='customer_order_no'
                        value="<?php echo $job_Card['customer_order_no']; ?>" />
                </div>
            </div>
            <div class="column width_90">
                <div class="row padding" style="    column-gap: 2em;">
                    <h1>CONTACT DETAILS</h2>
                        <script>
                            index_ing = 9999;
                            function add_contact_details() {
                                event.preventDefault();
                                var contact_details = document.getElementById('contact_details');
                                var new_contact_details = document.createElement('div');
                                new_contact_details.className = 'row width_100';
                                new_contact_details.id = 'record_id_' + index_ing;
                                new_contact_details.innerHTML = `
                                    <div class="column width_100">
                                        <label>Person</label>
                                        <input type="text" class="width_80" id='contact_person[]' name='contact_person[]' />
                                    </div>
                                    <div class="column width_100">
                                        <label>Cell No</label>
                                        <input type="text" class="width_80" id='phone[]' name='cell_no[]' />
                                    </div>
                                    <div class="column width_100">
                                        <label>Email</label>
                                        <input type="email" class="width_80" id='email[]' name='email[]' />
                                    </div>
                                        <div class="column width_100">
                                        <label>Job Description</label>
                                        <input type="text" class="width_80" id='description[]' name='description[]' />
                                    </div>
                                    <div class=\"column width_100\">
                                    <label>ACTIONS</label>
                                        <button onclick=\"delete_contact_details(`+ index_ing + `)\">DELETE</button>
                                    </div>
                                `;
                                contact_details.appendChild(new_contact_details);
                                index_ing++;
                            }

                            function delete_contact_details(record_id) {
                                event.preventDefault();
                                document.getElementById('record_id_' + record_id).remove();
                            }
                        </script>
                </div>
                <div class="width_100" id="contact_details">
                    <?php $job_card_contact_details_res = $db->query("job_card_contact_persons", "SELECT * FROM `job_card_contact_persons` WHERE job_card_id = {$_GET['record_id']} ORDER BY record_id ASC");

                    while ($job_card_contact_details = $job_card_contact_details_res->fetch_assoc()) {
                        echo "<div class='row width_100' id='record_id_{$job_card_contact_details['record_id']}'>
                                        <div class=\"column width_100\">
                                            <label>Person</label>
                                            <input type=\"text\" class=\"width_80\" id='contact_person[]' name='contact_person[]' value=\"{$job_card_contact_details['name']}\"/>
                                        </div>
                                        <div class=\"column width_100\">
                                            <label>Cell No</label>
                                            <input type=\"text\" class=\"width_80\" id='phone[]' name='cell_no[]' value=\"{$job_card_contact_details['contact_number']}\"/>
                                        </div>
                                        <div class=\"column width_100\">
                                            <label>Email</label>
                                            <input type=\"email\" class=\"width_80\" id='email[]' name='email[]' value=\"{$job_card_contact_details['email']}\"/>
                                        </div>
                                            <div class=\"column width_100\">
                                            <label>Job Description</label>
                                            <input type=\"text\" class=\"width_80\" id='description[]' name='description[]' value=\"{$job_card_contact_details['description']}\"/>
                                        </div>
                                        <div class=\"column width_100\">
                                    <label>ACTIONS</label>
                                          <button onclick=\"delete_contact_details({$job_card_contact_details['record_id']})\">DELETE</button>
                                        </div>
                                    </div>
                                ";
                    }
                    ?>
                </div>
                <br>
                <button onclick="add_contact_details()" class="width_100">ADD</button>
            </div>
        </div>
        <div class="column width_90 padding border_2" id="operation_div" style="height: 100px; overflow: hidden;">
            <div class="column width_100 background_1 border_radius">
                <i class="fa-solid fa-plus" style="font-size:2em; color:black;"
                    onclick="open_close('operation_div',this)"></i>
                <h1>OPERATION DETAILS</h1>
                <div class="row width_80">
                    <div class="column width_100">
                        <label>Installation</label>
                        <select class="width_80" id='installation' name='installation'>
                            <option value="1">Yes</option>
                            <option value="0">No</option>
                        </select>
                        <script>
                            document.getElementById('installation').value = "<?php echo $job_Card['installation']; ?>";
                        </script>
                    </div>
                    <div class="column width_100">
                        <label>COJ / J.C.</label>
                        <input type="text" class="width_80" id='coj_jobcard_no' name='coj_jobcard_no'
                            value="<?php echo $job_Card['coj_jobcard_no']; ?>" />
                    </div>
                    <div class="column width_100">
                        <label>Project Manager</label>
                        <select id="project_manager" name="project_manager" class="width_80">
                            <option value="">SELECT A USER</option>
                            <?php $app_feature->get_users_list(); ?>
                        </select>

                        <script>
                            document.getElementById('project_manager').value = "<?php echo $job_Card['project_manager']; ?>";
                        </script>
                    </div>
                </div>
            </div>
        </div>
        <?php $job_card_sections_res = $db->query("job_card_sections", "SELECT * FROM `job_card_sections` WHERE job_card_id = {$_GET['record_id']} ORDER BY record_id ASC"); ?>
        <div class="column width_90 padding border_2" id="sections_div" style="height: 100px; overflow: hidden;">
            <div class="row padding" style=" column-gap: 2em;">
                <!-- open close -->
                <div class="column width_100">
                    <i class="fa-solid fa-plus" style="font-size:2em; color:black;"
                        onclick="open_close('sections_div',this)"></i>
                    <h1>JOB CARD SECTIONS</h1>
                    <label>Project Name</label>
                    <textarea type="text" class="width_100" style="width: 50vw;font-size: 1.5em;" rows="3"
                        id='project_name' name='project_name'><?php echo $job_Card['project_name']; ?></textarea>
                    <label>Sub Job Card Qty's</label>
                    <input id="number_of_sections" type="number" step="1" min="0" name="number_of_sections"
                        onchange="add_numbers()" value="<?php echo $job_card_sections_res->num_rows; ?>">
                    <br>
                </div>
                <script>
                    function get_next_letter() {
                        var inputs = document.getElementsByName('section[]');
                        var letters = 'abcdefghijklmnopqrstuvwxyz';

                        function strToNum(str) {
                            let num = 0;
                            for (let i = 0; i < str.length; i++) {
                                num = num * 26 + (letters.indexOf(str[i]) + 1);
                            }
                            return num;
                        }

                        function numToStr(num) {
                            let str = '';
                            while (num > 0) {
                                num--;
                                str = letters[num % 26] + str;
                                num = Math.floor(num / 26);
                            }
                            return str.toUpperCase();
                        }

                        let maxNum = 0;
                        for (let i = 0; i < inputs.length; i++) {
                            let val = inputs[i].value.toLowerCase().trim();
                            if (val) {
                                let num = strToNum(val);
                                if (num > maxNum) {
                                    maxNum = num;
                                }
                            }
                        }
                        if (maxNum === 0) {
                            return 'A';
                        }
                        return numToStr(maxNum + 1);
                    }


                    function add_numbers() {
                        var num = parseInt(document.getElementById('number_of_sections').value) || 0;
                        var section_details = document.getElementById('section_details');

                        // 1. Remove sections without description
                        var sections = section_details.querySelectorAll('.row.width_100');
                        sections.forEach(sec => {
                            let desc = sec.querySelector("input[name='section_description[]']").value.trim();
                            if (desc === "") {
                                section_details.removeChild(sec);
                            }
                        });

                        // 2. Count remaining sections
                        sections = section_details.querySelectorAll('.row.width_100');
                        var count = sections.length;

                        // 3. Add sections if fewer than desired
                        while (count < num) {
                            add_section_details();
                            count++;
                        }

                        // 4. Remove extra sections if more than desired
                        while (count > num) {
                            section_details.removeChild(section_details.lastElementChild);
                            count--;
                        }
                    }

                    section_index = 10000;
                    function add_section_details() {
                        event.preventDefault();
                        var section_details = document.getElementById('section_details');
                        var new_section_details = document.createElement('div');
                        new_section_details.className = 'row width_100';
                        new_section_details.id = 'section_id_' + section_index;
                        new_section_details.innerHTML = `
                                    <div class="column width_100">
                                        <label>SUB SECTION</label>

                                        <input type="text" class="width_80" id='section[]' name='section[]'
                                            value='` + get_next_letter() + `' />
                                    </div>
                                    <div class="column width_100">
                                        <label>DESCRIPTION</label>
                                        <input type="text" class="width_80" id='section_description[]' name='section_description[]' />
                                    </div>
                                           <div class=\"column width_100\">
                                        <button onclick=\"delete_section(`+ section_index + `)\">DELETE</button>
                                    </div>
                                `;
                        section_index++;
                        section_details.appendChild(new_section_details);
                    }
                    function delete_section(record_id) {
                        event.preventDefault();
                        document.getElementById('section_id_' + record_id).remove();
                    }
                </script>
            </div>
            <div class="width_100" id="section_details">
                <?php

                while ($job_card_sections = $job_card_sections_res->fetch_assoc()) {
                    echo "<div class='row width_100' id='section_id_{$job_card_sections['record_id']}'>
                                    <div class='column width_100'>
                                        <label>SECTION</label>
                                        <input type='text' class='width_80' id='section[]' name='section[]' value='" . strtoupper($job_card_sections['section_name']) . "'>
                                    </div>
                                    <div class='column width_100'>
                                        <label>DESCRIPTION</label>
                                        <input type='text' class='width_80' id='section_description[]' name='section_description[]' value='{$job_card_sections['section_description']}'>
                                    </div>
                                           <div class=\"column width_100\">
                                        <button onclick=\"delete_section(`{$job_card_sections['record_id']}`)\">DELETE</button>
                                    </div>
                                </div>";

                }
                ?>

            </div>
            <br>
            <button onclick="add_section_details()" class="width_90">ADD</button>

        </div>

        <div class="column width_90 padding border_2" id="attachments_div" style="height: 100px; overflow: hidden;">
            <div class="column width_100 background_1 border_radius">
                <i class="fa-solid fa-plus" style="font-size:2em; color:black;"
                    onclick="open_close('attachments_div',this)"></i>
                <h1>JOB CARD ATTACHMENTS</h1>
                <div class="column width_80 background_1 border_radius">
                    <div class="width_100" id="attachment_details">
                        <?php
                        $file_categories_res = $db->query("file_categories", "SELECT * FROM `file_categories` ORDER BY record_id ASC");
                        while ($file_categories = $file_categories_res->fetch_assoc()) {
                            $job_card_attachments_res = $db->query("job_card_attachments", "SELECT * FROM `job_card_attachments` WHERE job_card_id = {$_GET['record_id']} AND file_category_id = {$file_categories['record_id']} ORDER BY record_id ASC");
                            if ($job_card_attachments_res->num_rows > 0) {

                                echo "<div class='row width_100 margin_bottom' > 
                                    <div class='column width_100'>
                                       <h2>{$file_categories['name']}</h2>
                                    </div>
                              </div>";
                                $job_card_attachments_res = $db->query("job_card_attachments", "SELECT * FROM `job_card_attachments` WHERE job_card_id = {$_GET['record_id']} AND file_category_id = {$file_categories['record_id']} ORDER BY record_id ASC");
                                while ($job_card_attachments = $job_card_attachments_res->fetch_assoc()) {
                                    $comments_res = $db->query("attachment_notes", "SELECT * FROM `attachment_notes` WHERE job_card_attachment_id = {$job_card_attachments['record_id']} ORDER BY record_id ASC");
                                    $comments_amount = $comments_res->num_rows;
                                    echo "
                                <div class='row width_100 margin_bottom' id='attachment_{$job_card_attachments['record_id']}'>
                                    <div class='column width_100'>
                                        <input type='text' class='width_80'  value='{$job_card_attachments['description']}'>
                                    </div>
                                    <div class='column width_100'>
                                        <select class='width_80' id='file_category_{$job_card_attachments['record_id']}' onchange=\"get_subcategories(this,{$job_card_attachments['record_id']})\" />
                                            " . $function->get_file_categories() . "
                                        </select>
                                        <script>
                                            document.getElementById('file_category_{$job_card_attachments['record_id']}').value = '{$job_card_attachments['file_category_id']}';
                                            get_subcategories(document.getElementById('file_category[]'),{$job_card_attachments['record_id']});
                                        </script>
                                    </div>
                                    <div class='column width_100'>
                                    <select class='width_80' id='file_subcategory_{$job_card_attachments['record_id']}'  />
                                        " . $function->get_file_subcategories($job_card_attachments['file_sub_category_id']) . "
                                    </select>
                                    <script>
                                            document.getElementById('file_subcategory_{$job_card_attachments['record_id']}').value = '{$job_card_attachments['file_sub_category_id']}';
                                    </script>   
                                    </div>
                                      <div class='column width_100'>
                                       <button class='width_100' onclick=\"event.preventDefault();window.location.href = 'attachments/{$job_card_attachments['file_name']}';\">OPEN FILE</button>
                                    </div>
                                    <div class='column width_100'>
                                       <button onclick='event.preventDefault();delete_attachment_details({$job_card_attachments['record_id']},\"{$job_card_attachments['file_name']}\")'>DELETE</button>
                                    </div>
                                    <div class='row width_20'>
                                         $comments_amount&nbsp<i class='fa-solid fa-comment' style='font-size:2em;' onclick=\"open_iframe('job_card_attachment_notes.php?record_id={$job_card_attachments['record_id']}')\"></i>
                                    </div>
                                </div>";
                                }
                            }
                        }

                        ?>

                    </div>
                    <br>
                    <button onclick="add_attachments_details()" class="width_90">ADD</button>
                </div>

                <script>
                    function add_attachments_details() {
                        event.preventDefault();
                        index = 99999;
                        var attachment_details = document.getElementById('attachment_details');
                        var new_attachment_details = document.createElement('div');
                        new_attachment_details.className = 'row width_100';
                        new_attachment_details.innerHTML = `
                  
                    <div class="column width_100">
                        <label>DESCRIPTION</label>
                        <input type="text" class="width_80" id='attachment_description[]' name='attachment_description[]' />
                    </div>
                        <div class="column width_100">
                        <label>CATEGORY</label>
                        <select class="width_80" onchange="get_subcategories(this,`+ index + `)" name='file_category[]' />
                        <?php
                        echo $function->get_file_categories();
                        ?>
                        </select>
                    </div>
                    </div>
                        <div class="column width_100">
                        <label>SUBCATEGORY</label>
                        <select  class="width_80" id='file_subcategory_`+ index + `' name='file_subcategory[]' />
                        </select>

                    </div>
                    </div>
                        <div class="column width_100">
                        <label>FILE</label>
                        <input type="file" class="width_80" id='attachment_file[]' name='attachment_file[]' />
                    </div>
                    `;
                        attachment_details.appendChild(new_attachment_details);
                        index++;
                    }

                    function delete_attachment_details(record_id, attachment) {
                        event.preventDefault();
                        document.getElementById('attachment_details').removeChild(document.getElementById('attachment_' + record_id));
                        var xhttp = new XMLHttpRequest();
                        xhttp.onreadystatechange = function () {
                            if (this.readyState == 4 && this.status == 200) {
                                // console.log(this.responseText);
                            }
                        };
                        xhttp.open("POST", "delete_attachment.php", true);
                        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                        xhttp.send("record_id=" + record_id + "&attachment_file=" + attachment);

                    }

                    function open_file(record_id) {
                        window.location.href = 'job_card.pdf.php?record_id=' + record_id;
                    }
                </script>
            </div>
        </div>
        <div class="column width_90 padding border_2" id="additional_div" style="height: 100px; overflow: hidden;">
            <div class="column width_100 background_1 border_radius">
                <i class="fa-solid fa-plus" style="font-size:2em; color:black;"
                    onclick="open_close('additional_div',this)"></i>
                <h1>ADDITIONAL DETAILS</h1>
                <div class="row width_100">
                    <div class="column width_100 row_gap_2">
                        <!-- start of ADDITIONAL DETAILS DIV -->

                        <div class="row width_100">
                            <label class="width_30">TYPE ENCLOSURE</label>
                            <select class="width_20" id='type_enclosure' name='type_enclosure'
                                onchange="check_other_enclosuer()">
                                <option value="">N/A</option>
                                <option value="KIOSK">KIOSK</option>
                                <option value="WALL">WALL</option>
                                <option value="FLOOR">FLOOR</option>
                                <option value="POLE">POLE</option>
                                <option value="OTHER">OTHER</option>
                            </select>
                            <input type="text" id="other_enclosure" class="width_40"
                                style="display: none;margin-left: 1em; margin-right: 1em;" name="other_enclosure"
                                placeholder="Please Specify" value="<?php echo $job_Card['type_enclosure']; ?>">
                            <script>
                                function check_other_enclosuer() {
                                    if (document.getElementById('type_enclosure').value == 'OTHER') {
                                        document.getElementById('other_enclosure').style.display = 'block';
                                    } else {
                                        document.getElementById('other_enclosure').style.display = 'none';
                                    }
                                }
                                if ("<?php echo $job_Card['type_enclosure']; ?>" != 'KIOS' && "<?php echo $job_Card['type_enclosure']; ?>" != 'WALL' && "<?php echo $job_Card['type_enclosure']; ?>" != 'FLOOR' && "<?php echo $job_Card['type_enclosure']; ?>" != 'POLE') {
                                    document.getElementById('type_enclosure').value = "OTHER";
                                    check_other_enclosuer();
                                } else {
                                    document.getElementById('type_enclosure').value = "<?php echo $job_Card['type_enclosure']; ?>";
                                }
                            </script>
                        </div>

                        <div class="row width_100">
                            <label class="width_30">STEEL TYPE</label>
                            <select class="width_20" id='steel_type' name='steel_type'>
                                <option value="">N/A</option>
                                <option value="MILD">MILD</option>
                                <option value="3CR12">3CR12</option>
                                <option value="304">304</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('steel_type').value = "<?php echo $job_Card['steel_type']; ?>";
                        </script>

                        <div class="row width_100">
                            <label class="width_30">STEEL THICKNESS</label>
                            <input type="text" class="width_50" id='steel_thickness' name='steel_thickness'
                                value="<?php echo $job_Card['steel_thickness']; ?>" />
                        </div>


                        <div class="row width_100">
                            <label class="width_30">IP RATING</label>
                            <input type="text" class="width_50" id='ip_rating' name='ip_rating'
                                value="<?php echo $job_Card['ip_rating']; ?>" />
                        </div>


                        <div class="row width_100">
                            <label class="width_30">TYPE OF ENCLOSURE</label>
                            <select class="width_20" id='type_of_enclosure' name='type_of_enclosure'>
                                <option value="">N/A</option>
                                <option value="S.A.B.S">S.A.B.S</option>
                                <option value="NON S.A.B.S">NON S.A.B.S</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('type_of_enclosure').value = "<?php echo $job_Card['type_of_enclosure']; ?>";
                        </script>

                        <div class="row width_100">
                            <label class="width_30">MAKE OF ENCOLURE</label>
                            <select class="width_20" id='make_of_enclosure' name='make_of_enclosure'>
                                <option value="">N/A</option>
                                <option value="CUSTOM">CUSTOM</option>
                                <option value="INNERDOORS">INNERDOORS</option>
                                <option value="STANDARD">STANDARD</option>
                                <option value="FACIAS">FACIAS</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('make_of_enclosure').value = "<?php echo $job_Card['make_of_enclosure']; ?>";
                        </script>


                        <div class="row width_100">
                            <label class="width_30">CABLE ENTRY</label>
                            <select class="width_20" id='cable_entry' name='cable_entry'>
                                <option value="">N/A</option>
                                <option value="TOP">TOP</option>
                                <option value="BOTTOM">BOTTOM</option>
                                <option value="BOTH">BOTH</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('cable_entry').value = "<?php echo $job_Card['cable_entry']; ?>";
                        </script>



                        <div class="row width_100">
                            <label class="width_30">PANEL BASE SIZE</label>
                            <select class="width_20" id='panel_base_size' name='panel_base_size'
                                onchange="check_panel_base_size_other()">
                                <option value="">N/A</option>
                                <option value="76MM">76MM</option>
                                <option value="100MM">100MM</option>
                                <option value="OTHER">OTHER</option>
                            </select>
                            <input type="text" id="other_panel_base_size" class="width_40"
                                style="display: none;margin-left: 1em; margin-right: 1em;" name="other_panel_base_size"
                                placeholder="Please Specify" value="<?php echo $job_Card['panel_base_size']; ?>">
                            <script>
                                function check_panel_base_size_other() {
                                    if (document.getElementById('panel_base_size').value == 'OTHER') {
                                        document.getElementById('other_panel_base_size').style.display = 'block';
                                    } else {
                                        document.getElementById('other_panel_base_size').style.display = 'none';
                                    }
                                }

                                if ("<?php echo $job_Card['panel_base_size']; ?>" != '76MM' && "<?php echo $job_Card['panel_base_size']; ?>" != '100MM') {
                                    document.getElementById('panel_base_size').value = "OTHER";
                                    check_panel_base_size_other();
                                } else {
                                    document.getElementById('panel_base_size').value = "<?php echo $job_Card['panel_base_size']; ?>";
                                }
                            </script>
                        </div>


                        <div class="row width_100">
                            <label class="width_30">LOOSE GLAND PLATES</label>
                            <select class="width_20" id='loose_gland_plates' name='loose_gland_plates'>
                                <option value="">N/A</option>
                                <option value="TOP">TOP</option>
                                <option value="BOTTOM">BOTTOM</option>
                                <option value="BOTH">BOTH</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('loose_gland_plates').value = "<?php echo $job_Card['loose_gland_plates']; ?>";
                        </script>


                        <div class="row width_100">
                            <label class="width_30">LOCK TYPES</label>
                            <select class="width_20" id='lock_types' name='lock_types'
                                onchange="check_lock_types_other()">
                                <option value="">N/A</option>
                                <option value="SQUARE">SQUARE</option>
                                <option value="KIOSK">KIOSK</option>
                                <option value="OTHER">OTHER</option>
                            </select>
                            <input type="text" id="other_lock_types" class="width_40"
                                style="display: none;margin-left: 1em; margin-right: 1em;" name="other_lock_types"
                                placeholder="Please Specify" value="<?php echo $job_Card['lock_types']; ?>">
                            <script>
                                function check_lock_types_other() {
                                    if (document.getElementById('lock_types').value == 'OTHER') {
                                        document.getElementById('other_lock_types').style.display = 'block';
                                    } else {
                                        document.getElementById('other_lock_types').style.display = 'none';
                                    }
                                }

                                if ("<?php echo $job_Card['lock_types']; ?>" != 'SQUARE' && "<?php echo $job_Card['lock_types']; ?>" != 'KIOSK') {
                                    document.getElementById('lock_types').value = "<?php echo $job_Card['lock_types']; ?>";
                                    check_lock_types_other();
                                } else {
                                    document.getElementById('lock_types').value = "<?php echo $job_Card['lock_types']; ?>";
                                }
                            </script>
                        </div>



                        <div class="row width_100">
                            <label class="width_30">COLOUR</label>
                            <select class="width_20" id='colour' name='colour' onchange="check_colour_other()">
                                <option value="">N/A</option>
                                <option value="ORANGE">ORANGE</option>
                                <option value="CH/GREY">CH/GREY</option>
                                <option value="RAL732">RAL732</option>
                                <option value="AVOGREEN">AVOGREEN</option>
                                <option value="BS/GREY">BS/GREY</option>
                                <option value="OTHER">OTHER</option>
                            </select>
                            <input type="text" id="other_colour" class="width_40"
                                style="display: none;margin-left: 1em; margin-right: 1em;" name="other_colour"
                                placeholder="Please Specify" value="<?php echo $job_Card['colour']; ?>">
                            <script>
                                function check_colour_other() {
                                    if (document.getElementById('colour').value == 'OTHER') {
                                        document.getElementById('other_colour').style.display = 'block';
                                    } else {
                                        document.getElementById('other_colour').style.display = 'none';
                                    }
                                }

                                if ("<?php echo $job_Card['colour']; ?>" != 'ORANGE' && "<?php echo $job_Card['colour']; ?>" != 'CH/GREY' && "<?php echo $job_Card['colour']; ?>" != 'RAL732' && "<?php echo $job_Card['colour']; ?>" != 'AVOGREEN' && "<?php echo $job_Card['colour']; ?>" != 'BS/GREY') {
                                    document.getElementById('colour').value = "OTHER";
                                    check_colour_other();
                                } else {
                                    document.getElementById('colour').value = "<?php echo $job_Card['colour']; ?>";
                                }
                            </script>
                        </div>


                        <div class="row width_100">
                            <label class="width_30">MAIN VOLTAGE</label>
                            <select class="width_20" id='main_voltage' name='main_voltage'>
                                <option value="">N/A</option>
                                <option value="220V">220V</option>
                                <option value="380V">380V</option>
                                <option value="525V">525V</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('main_voltage').value = "<?php echo $job_Card['main_voltage']; ?>";
                        </script>

                        <div class="row width_100">
                            <label class="width_30">CONTROLS FORM</label>
                            <select class="width_20" id='controls_form' name='controls_form'>
                                <option value="">N/A</option>
                                <option value="COMMON">COMMON</option>
                                <option value="MAINS">MAINS</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('controls_form').value = "<?php echo $job_Card['controls_form']; ?>";
                        </script>


                        <div class="row width_100">
                            <label class="width_30">CONTROL VOLTAGE</label>
                            <select class="width_20" id='control_voltage' name='control_voltage'
                                onchange="check_control_voltage_other()">
                                <option value="">N/A</option>
                                <option value="24VAC/DC">24VAC/DC</option>
                                <option value="110V">110V</option>
                                <option value="220V">220V</option>
                                <option value="380V">380V</option>
                                <option value="525V">525V</option>
                                <option value="OTHER">OTHER</option>
                            </select>
                            <input type="text" id="other_control_voltage" class="width_40"
                                style="display: none;margin-left: 1em; margin-right: 1em;" name="other_control_voltage"
                                placeholder="Please Specify" value="<?php echo $job_Card['control_voltage']; ?>">
                            <script>
                                function check_control_voltage_other() {
                                    if (document.getElementById('control_voltage').value == 'OTHER') {
                                        document.getElementById('other_control_voltage').style.display = 'block';
                                    } else {
                                        document.getElementById('other_control_voltage').style.display = 'none';
                                    }
                                }

                                if ("<?php echo $job_Card['control_voltage']; ?>" != '24VAC/DC' && "<?php echo $job_Card['control_voltage']; ?>" != '110V' && "<?php echo $job_Card['control_voltage']; ?>" != '220V' && "<?php echo $job_Card['control_voltage']; ?>" != '380V' && "<?php echo $job_Card['control_voltage']; ?>" != '525V') {
                                    document.getElementById('control_voltage').value = "OTHER";
                                    check_control_voltage_other();
                                } else {
                                    document.getElementById('control_voltage').value = "<?php echo $job_Card['control_voltage']; ?>";
                                }
                            </script>
                        </div>

                        <div class="row width_100">
                            <label class="width_30">INCOMER</label>
                            <select class="width_20" id='incomer' name='incomer'>
                                <option value="">N/A</option>
                                <option value="ISOLATOR">ISOLATOR</option>
                                <option value="BREAKER">BREAKER</option>
                            </select>
                        </div>

                        <script>
                            document.getElementById('incomer').value = "<?php echo $job_Card['incomer']; ?>";
                        </script>

                        <div class="row width_100">
                            <label class="width_30">STARTER TYPE</label>
                            <select class="width_20" id='starter_type' name='starter_type'
                                onchange="check_starter_type_other()">
                                <option value="">N/A</option>
                                <option value="DOL">DOL</option>
                                <option value="S/DELTA">S/DELTA</option>
                                <option value="SOFTSTART">SOFTSTART</option>
                                <option value="VSD">VSD</option>
                                <option value="OTHER">OTHER</option>
                            </select>
                            <input type="text" id="other_starter_type" class="width_40"
                                style="display: none;margin-left: 1em; margin-right: 1em;" name="other_starter_type"
                                placeholder="Please Specify" value="<?php echo $job_Card['starter_type']; ?>">
                            <script>
                                function check_starter_type_other() {
                                    if (document.getElementById('starter_type').value == 'OTHER') {
                                        document.getElementById('other_starter_type').style.display = 'block';
                                    } else {
                                        document.getElementById('other_starter_type').style.display = 'none';
                                    }
                                }
                            </script>

                            <script>
                                if ("<?php echo $job_Card['starter_type']; ?>" != "N/A" && "<?php echo $job_Card['starter_type']; ?>" != "OTHER" && "<?php echo $job_Card['starter_type']; ?>" != 'DOL' && "<?php echo $job_Card['starter_type']; ?>" != 'S/DELTA' && "<?php echo $job_Card['starter_type']; ?>" != 'SOFTSTART' && "<?php echo $job_Card['starter_type']; ?>" != 'VSD') {
                                    document.getElementById('starter_type').value = "OTHER";
                                    check_starter_type_other();
                                } else {
                                    document.getElementById('starter_type').value = "<?php echo $job_Card['starter_type']; ?>";
                                }
                            </script>
                        </div>

                        <div class="row width_100">
                            <label class="width_30">AMMETERS</label>
                            <input type="text" class="width_50" id='ammeters' name='ammeters'
                                value="<?php echo $job_Card['ammeters']; ?>" />
                        </div>


                        <div class="row width_100">
                            <label class="width_30">VOLTMETER</label>
                            <input type="text" class="width_50" id='voltmeter' name='voltmeter'
                                value="<?php echo $job_Card['voltmeter']; ?>" />
                        </div>

                        <div class="row width_100">
                            <label class="width_30">MOTOR KW RATING</label>
                            <input type="text" class="width_50" id='motor_kw_rating' name='motor_kw_rating'
                                value="<?php echo $job_Card['motor_kw_rating']; ?>" />
                        </div>

                        <div class="row width_100">
                            <label class="width_30">MOTOR TYPE</label>
                            <select class="width_20" id='motor_type' name='motor_type'>
                                <option value="">N/A</option>
                                <option value="CONV">CONV</option>
                                <option value="PUMP">PUMP</option>
                                <option value="SUBMERS">SUBMERS</option>
                                <option value="CRUSH">CRUSH</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('motor_type').value = "<?php echo $job_Card['motor_type']; ?>";
                        </script>

                        <div class="row width_100">
                            <label class="width_30">GEARBOX</label>
                            <select class="width_20" id='gearbox' name='gearbox'>
                                <option value="">N/A</option>
                                <option value="YES">YES</option>
                                <option value="NO">NO</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('gearbox').value = "<?php echo $job_Card['gearbox']; ?>";
                        </script>

                        <div class="row width_100">
                            <label class="width_30">EARTH LEAK</label>
                            <select class="width_20" id='earth_leak' name='earth_leak'>
                                <option value="">N/A</option>
                                <option value="YES">YES</option>
                                <option value="NO">NO</option>
                            </select>
                        </div>
                        <script>
                            document.getElementById('earth_leak').value = "<?php echo $job_Card['earth_leak']; ?>";
                        </script>

                        <div class="row width_100">
                            <label class="width_30">Ma RATING</label>
                            <input type="text" class="width_50" id='ma_rating' name='ma_rating'
                                value="<?php echo $job_Card['ma_rating']; ?>" />
                        </div>


                        <!-- END OF ADDITIONAL DETAILS DIV -->

                    </div>
                </div>
                <br>
            </div>
        </div>
        <br><br>
        <div class="column width_80 padding border_2">
            <h1>NOTES</h1>
            <textarea name="notes" readonly id="notes" class="width_100"
                rows="10"><?php echo $job_Card['notes']; ?></textarea>
        </div>
        <button class="width_90" style="    position: absolute;
    top: 3vh;
    left: 92vw;
    height: 10vh;
    width: 5vw;" onclick="save()">SAVE</button>
        <script>
            function save() {

                var overlay = document.createElement('div');
                overlay.className = 'overlay';
                overlay.innerHTML = `
                            <div class="lds-roller">
                                <div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div>
                            </div>
                            <style>
                                .lds-roller {
                                    display: inline-block;
                                    position: relative;
                                    width: 80px;
                                    height: 80px;
                                }
                                .lds-roller div {
                                    animation: lds-roller 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;
                                    transform-origin: 40px 40px;
                                }
                                .lds-roller div:after {
                                    content: " ";
                                    display: block;
                                    position: absolute;
                                    width: 7px;
                                    height: 7px;
                                    border-radius: 50%;
                                    background: #fff;
                                    margin: -4px 0 0 -4px;
                                }
                                .lds-roller div:nth-child(1) {
                                    animation-delay: -0.036s;
                                }
                                .lds-roller div:nth-child(1):after {
                                    top: 63px;
                                    left: 63px;
                                }
                                .lds-roller div:nth-child(2) {
                                    animation-delay: -0.072s;
                                }
                                .lds-roller div:nth-child(2):after {
                                    top: 68px;
                                    left: 56px;
                                }
                                .lds-roller div:nth-child(3) {
                                    animation-delay: -0.108s;
                                }
                                .lds-roller div:nth-child(3):after {
                                    top: 71px;
                                    left: 48px;
                                }
                                .lds-roller div:nth-child(4) {
                                    animation-delay: -0.144s;
                                }
                                .lds-roller div:nth-child(4):after {
                                    top: 72px;
                                    left: 40px;
                                }
                                .lds-roller div:nth-child(5) {
                                    animation-delay: -0.18s;
                                }
                                .lds-roller div:nth-child(5):after {
                                    top: 71px;
                                    left: 32px;
                                }
                                .lds-roller div:nth-child(6) {
                                    animation-delay: -0.216s;
                                }
                                .lds-roller div:nth-child(6):after {
                                    top: 68px;
                                    left: 24px;
                                }
                                .lds-roller div:nth-child(7) {
                                    animation-delay: -0.252s;
                                }
                                .lds-roller div:nth-child(7):after {
                                    top: 63px;
                                    left: 17px;
                                }
                                .lds-roller div:nth-child(8) {
                                    animation-delay: -0.288s;
                                }
                                .lds-roller div:nth-child(8):after {
                                    top: 56px;
                                    left: 12px;
                                }
                                @keyframes lds-roller {
                                    0% {
                                        transform: rotate(0deg);
                                    }
                                    100% {
                                        transform: rotate(360deg);
                                    }
                                }
                            </style>
                        `;
                document.body.appendChild(overlay);
                overlay.style.display = 'flex';
                overlay.style.alignItems = 'center';
                overlay.style.justifyContent = 'center';


            }


            function open_file(record_id) {
                window.location.href = 'job_card.pdf.php?record_id=' + record_id;
            }
        </script>
        <br>

    </div>

    <script>
        function open_close(id, icon) {
            div = document.getElementById(id);
            if (id == "sections_div") {
                if (div.style.height == "100px") {
                    div.style.height = "auto";
                    div.style.overflow = "auto";
                    div.style.justifyContent = "center";
                    icon.classList.remove("fa-plus");
                    icon.classList.add("fa-minus");

                } else {
                    div.style.height = "100px";
                    div.style.overflow = "hidden";
                    div.style.justifyContent = null;
                    icon.classList.remove("fa-minus");
                    icon.classList.add("fa-plus");
                }

            }
            if (id == "client_div") {
                if (div.style.height == "100px") {
                    div.style.height = "auto";
                    div.style.overflow = "auto";
                    div.style.justifyContent = "center";
                    icon.classList.remove("fa-plus");
                    icon.classList.add("fa-minus");

                } else {
                    div.style.height = "100px";
                    div.style.overflow = "hidden";
                    div.style.justifyContent = null;
                    icon.classList.remove("fa-minus");
                    icon.classList.add("fa-plus");
                }
            }
            if (id == "attachments_div") {
                if (div.style.height == "100px") {
                    div.style.height = "auto";
                    div.style.overflow = "auto";
                    div.style.justifyContent = "center";
                    icon.classList.remove("fa-plus");
                    icon.classList.add("fa-minus");

                } else {
                    div.style.height = "100px";
                    div.style.overflow = "hidden";
                    div.style.justifyContent = null;
                    icon.classList.remove("fa-minus");
                    icon.classList.add("fa-plus");
                }

            }
            if (id == "additional_div") {
                if (div.style.height == "100px") {
                    div.style.height = "auto";
                    div.style.overflow = "auto";
                    div.style.justifyContent = "center";
                    icon.classList.remove("fa-plus");
                    icon.classList.add("fa-minus");

                } else {
                    div.style.height = "100px";
                    div.style.overflow = "hidden";
                    div.style.justifyContent = null;
                    icon.classList.remove("fa-minus");
                    icon.classList.add("fa-plus");
                }

            }
            if (id == "operation_div") {
                if (div.style.height == "100px") {
                    div.style.height = "auto";
                    div.style.overflow = "auto";
                    div.style.justifyContent = "center";
                    icon.classList.remove("fa-plus");
                    icon.classList.add("fa-minus");

                } else {
                    div.style.height = "100px";
                    div.style.overflow = "hidden";
                    div.style.justifyContent = null;
                    icon.classList.remove("fa-minus");
                    icon.classList.add("fa-plus");
                }

            }
        }
    </script>

</form>