<?php
include '../../classes/fpdf.php';
include "../../classes/autoload.php";

$db = new db();
$app = new app_features();
$jobcard_res = $db->query("job_cards", "SELECT * FROM job_cards WHERE record_id = '{$_GET['record_id']}'");
$jobcard = $jobcard_res->fetch_assoc();


function remove_html_tags($text)
{
    $description = strip_tags($text);
    $description = str_replace("\n", "\r\n", $description);
    $description = preg_replace('/\s\s+/', ' ', $description);
    $description = preg_replace('/\n\n+/', "\n", $description);
    return $description;
}

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('P');


$pdf->Image('../../assets/logo.png', 130, 8, 65);

$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(200, 15, "ELECTRO SYSTEMS - JOB CARD", 0, 1);
$pdf->SetFont('Arial', '', 6);

$table_array = [25, 70, 25, 65];
$pdf->Cell($table_array[0], 7, "Date Job Card Opened:", "LTB", 0);
$pdf->Cell($table_array[1], 7, $jobcard['date_opened'], "RTB", 0);
$pdf->Cell($table_array[2], 7, "Job Card No:", "LTB", 0);
$job_card_no = substr($jobcard['job_card_no'], 0, 2) . "-" . substr($jobcard['job_card_no'], 2);
$pdf->Cell($table_array[3], 7, $job_card_no, "RTB", 1);

$pdf->Cell($table_array[0], 7, "Date Required:", "LTB", 0);
$pdf->Cell($table_array[1], 7, $jobcard['date_required'], "RTB", 0);
$pdf->Cell($table_array[2], 7, "Rep/Originator:", "LTB", 0);
$pdf->Cell($table_array[3], 7, $app->get_username($jobcard['rep_originator']), "RTB", 1);

$pdf->Cell($table_array[0], 7, "Company Name:", "LTB", 0);
$pdf->Cell($table_array[1], 7, $jobcard['company_name'], "RTB", 0);
$pdf->Cell($table_array[2], 7, "Customer order No:", "LTB", 0);
$pdf->Cell($table_array[3], 7, $jobcard['customer_order_no'], "RTB", 1);

$pdf->Cell($table_array[0], 7, "Vat Reg No", "LTB", 0);
$pdf->Cell($table_array[1], 7, $jobcard['vat_no'], "RTB", 0);
$pdf->Cell($table_array[2], 7, "Account No:", "LTB", 0);
$pdf->Cell($table_array[3], 7, $jobcard['account_no'], "RTB", 1);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(185, 5, "CONTACT DETAILS", 1, 1, "C");
$pdf->SetFont('Arial', '', 6);

// get contact persons
$contact_res = $db->query("job_card_contact_persons", "SELECT * FROM job_card_contact_persons WHERE job_card_id = '{$_GET['record_id']}'");
while ($contact = $contact_res->fetch_assoc()) {
    $pdf->Cell($table_array[0], 5, "Name:", "LT", 0);
    $pdf->Cell($table_array[1], 5, $contact['name'], "T", 0);
    $pdf->Cell($table_array[2], 5, "Job Description:", "LT", 0);
    $pdf->Cell($table_array[3], 5, $contact['description'], "TR", 1);
    $pdf->Cell($table_array[0], 5, "Contact Number:", "LB", 0);
    $pdf->Cell($table_array[1], 5, $contact['contact_number'], "B", 0);
    $pdf->Cell($table_array[2], 5, "email:", "LB", 0);
    $pdf->Cell($table_array[3], 5, $contact['email'], "RB", 1);
}


$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(185, 5, "JOB DESCRIPTION", 1, 1, "C");
$pdf->SetFont('Arial', '', 6);
$pdf->Cell(15, 5, "Project Name:", "LT", 0);
$pdf->Cell(170, 5, $jobcard['project_name'], "RT", 1);
$index = 1;
$contact_res = $db->query("job_card_sections", "SELECT * FROM job_card_sections WHERE job_card_id = '{$_GET['record_id']}'");
$total_row = $contact_res->num_rows;
$counint_index = 1;
while ($contact = $contact_res->fetch_assoc()) {


    if ($index == 2) {
        $pdf->Cell(15, 5, "Sub-Division:", "LTB", 0);
        $pdf->Cell(5, 5, strtoupper($contact['section_name']), "TB", 0, "L");
        $pdf->Cell(72.5, 5, ' - ' . $contact['section_description'], "TRB", 1, "L");
        $index = 1;
    } else {
        $pdf->Cell(15, 5, "Sub-Division:", "LTB", 0);
        $pdf->Cell(5, 5, strtoupper($contact['section_name']), "TB", 0, "L");
        if ($counint_index == $total_row) {
            $pdf->Cell(72.5, 5, ' - ' . $contact['section_description'], "TRB", 1, "L");
        } else {
            $pdf->Cell(72.5, 5, ' - ' . $contact['section_description'], "TRB", 0, "L");

        }
        $index++;
    }
    $counint_index++;

}
$pdf->Cell(25, 5, "INSTALLATION:", "LTB", 0);
if ($jobcard['installation'] == 1) {
    $pdf->Cell(15, 5, "YES", "TB", 0, "L");

} else {
    $pdf->Cell(15, 5, "NO", "TB", 0, "L");

}
$pdf->Cell(62.5, 5, "", "TRB", 0, "L");
$pdf->Cell(25, 5, "Extra COJ/Job Card No:", "LTB", 0);
$pdf->Cell(57.5, 5, $jobcard['coj_jobcard_no'], "TBR", 1, "L");

$pdf->Cell(100, 5, "Handed To Orignator/Project manager", "TBL", 0);
$pdf->Cell(85, 5, "Date:", "TBR", 1);

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(185, 5, "ALL INFORMATION RECEIVED( TO BE SIGNED OFF BEFORE JOB STARTS)", 1, 1, "C");
$pdf->SetFont('Arial', '', 6);

$pdf->Cell(31, 5, "Job Card Technical Sheet:", "TLB", 0, "L");
$pdf->Cell(31, 5, "Sign:", 1, 0, "L");
$pdf->Cell(31, 5, "Date:", 1, 0, "L");
$pdf->Cell(31, 5, "Client Specs & Photos:", "TLB", 0, "L");
$pdf->Cell(31, 5, "Sign:", 1, 0, "L");
$pdf->Cell(30, 5, "Date:", 1, 1, "L");

$pdf->Cell(31, 5, "Cost / Quote:", "TLB", 0, "L");
$pdf->Cell(31, 5, "Sign:", 1, 0, "L");
$pdf->Cell(31, 5, "Date:", 1, 0, "L");
$pdf->Cell(31, 5, "Technical Meeting:", "TLB", 0, "L");
$pdf->Cell(31, 5, "Sign:", 1, 0, "L");
$pdf->Cell(30, 5, "Date:", 1, 1, "L");

$pdf->Cell(31, 5, "Cost Check & Approved:", "TLB", 0, "L");
$pdf->Cell(31, 5, "Sign:", 1, 0, "L");
$pdf->Cell(31, 5, "Date:", 1, 0, "L");
$pdf->Cell(31, 5, "Variences & Changes:", "TLB", 0, "L");
$pdf->Cell(31, 5, "Sign:", 1, 0, "L");
$pdf->Cell(30, 5, "Date:", 1, 1, "L");

$pdf->Cell(31, 5, "Design Check & Approved", "TLB", 0, "L");
$pdf->Cell(31, 5, "Sign:", 1, 0, "L");
$pdf->Cell(31, 5, "Date:", 1, 0, "L");
$pdf->Cell(31, 5, "", "TLB", 0, "L");
$pdf->Cell(31, 5, "Sign:", 1, 0, "L");
$pdf->Cell(30, 5, "Date:", 1, 1, "L");


$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(185, 5, "Final Completion Details", 1, 1, "C");
$pdf->SetFont('Arial', '', 6);
$pdf->Cell(185, 5, "Drawing No:", 1, 1, "L");
$pdf->Cell(185 / 2, 5, "Built/Wired By:", "BL", 0, "L");
$pdf->Cell(185 / 2, 5, "Checked By:", "BR", 1, "L");
$pdf->Cell(185, 5, "", 1, 1, "L");
$pdf->Cell(185, 5, "Date Completed:", 1, 1, "L");
$pdf->Cell(185, 5, "Signed Off Workshop Manager:", 1, 1, "L");
$pdf->Cell(185, 5, "Signed Off Technical Manager:", 1, 1, "L");


$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(185, 5, "Material Cost (See BOM):", 1, 1, "C");
$pdf->SetFont('Arial', '', 6);


$pdf->Cell(185 / 6, 5, "Labour Electrician:", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "Name:", "B", 0, "L");
$pdf->Cell(185 / 6, 5, "Hours Worked:", "B", 0, "L");
$pdf->Cell(185 / 6, 5, "Overtime Hours:", "B", 0, "L");
$pdf->Cell(185 / 6, 5, "Days:", "B", 0, "L");
$pdf->Cell(185 / 6, 5, "R ", 1, 1, "L");

$pdf->Cell(185 / 6, 5, "Labour Semi-Skilled:", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "Name:", "B", 0, "L");
$pdf->Cell(185 / 6, 5, "Hours Worked:", "B", 0, "L");
$pdf->Cell(185 / 6, 5, "Overtime Hours:", "B", 0, "L");
$pdf->Cell(185 / 6, 5, "Days:", "B", 0, "L");
$pdf->Cell(185 / 6, 5, "R ", 1, 1, "L");

$pdf->Cell(185 / 6, 5, "Travel:", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "Km:", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "R ", 1, 1, "L");

$pdf->Cell(185 / 6, 5, "Toll:", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "Km:", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "R ", 1, 1, "L");

$pdf->Cell(185 / 6, 5, "Total Cost:", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "R ", 1, 1, "L");

$pdf->Cell(185 / 6, 5, "", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "Subtotal:", "BT", 0, "R");
$pdf->Cell(185 / 6, 5, "R ", 1, 1, "L");

$pdf->Cell(185 / 6, 5, "", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "Vat:", "BT", 0, "R");
$pdf->Cell(185 / 6, 5, "R ", 1, 1, "L");

$pdf->Cell(185 / 6, 5, "", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "Total:", "BT", 0, "R");
$pdf->Cell(185 / 6, 5, "R ", 1, 1, "L");

$pdf->Cell(185 / 6, 5, "", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "Invoice Amount:", "TLR", 0, "R");
$pdf->Cell(185 / 6, 5, "R " . number_format((float)$jobcard['invoice_amount'], 2), "TLR", 1, "L");

$pdf->Cell(185 / 6, 5, "Invoice No:", "BLT", 0, "L");
$pdf->Cell(185 / 6, 5, $jobcard['invoice_number'], "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "", "BT", 0, "L");
$pdf->Cell(185 / 6, 5, "Invoice Date:", "LRB", 0, "R");
$pdf->Cell(185 / 6, 5, "", "LRB", 1, "L");

$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(185, 5, "NOTES:", 1, 1, "C");
$pdf->SetFont('Arial', '', 6);

$pdf->MultiCell(185, 5, $jobcard['notes'], 1, "L");



$pdf->AddPage('P');


$pdf->Image('../../assets/logo.png', 130, 8, 65);

$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(200, 15, "ELECTRO SYSTEMS - JOB CARD", 0, 1);
$pdf->SetFont('Arial', '', 6);
$pdf->Cell(185, 5, "DESC:", 1, 1, "L");
$pdf->Cell(185, 5, "Job Card No: " . $jobcard['job_card_no'], 1, 1, "L");

// first part
$pdf->Cell(185 / 7, 5, "TYPE ENCLOSURE", "LTR", 0, "L");
if ($jobcard['type_enclosure'] == "KIOSK") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "KIOSK", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);

} else {
    $pdf->Cell(185 / 7, 5, "KIOSK", "LBRT", 0, "L");
}

if ($jobcard['type_enclosure'] == "WALL") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "WALL", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "WALL", "LBRT", 0, "L");
}
if ($jobcard['type_enclosure'] == "FLOOR") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "FLOOR", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "FLOOR", "LBRT", 0, "L");
}
if ($jobcard['type_enclosure'] == "FLOOR") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "POLE", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "POLE", "LBRT", 0, "L");

}
if ($jobcard['type_enclosure'] != "KIOSK" && $jobcard['type_enclosure'] != "WALL" && $jobcard['type_enclosure'] != "FLOOR" && $jobcard['type_enclosure'] != "POLE") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['type_enclosure'], "LBRT", 1, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");
}
// end of first part

// STEEL TYPE
$pdf->Cell(185 / 7, 5, "STEEL TYPE", "LR", 0, "L");
if ($jobcard['steel_type'] == "MILD") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "MILD", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "MILD", "LBRT", 0, "L");
}
if ($jobcard['steel_type'] == "3CR12") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "3CR12", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "3CR12", "LBRT", 0, "L");
}
if ($jobcard['steel_type'] == "304") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "304", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "304", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard["steel_thickness"] != "") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "THICKNESS", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['steel_thickness'], "LBRT", 1, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "THICKNESS", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");
}

// IP RATING
$pdf->Cell(185 / 7, 5, "IP RATING", "LR", 0, "L");
if ($jobcard["ip_rating"] != "") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, $jobcard['ip_rating'], "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "IP RATING", "LR", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");

// TYPE OF ENCLOSURE
$pdf->Cell(185 / 7, 5, "TYPE OF ENCLOSURE", "LR", 0, "L");
if ($jobcard['type_of_enclosure'] == "S.A.B.S") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "S.A.B.S", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "S.A.B.S", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard["type_of_enclosure"] == "NON S.A.B.S") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "NON S.A.B.S", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "NON S.A.B.S", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");


// MAKE OF ENCOLURE
$pdf->Cell(185 / 7, 5, "MAKE OF ENCOLURE", "LR", 0, "L");
if ($jobcard["make_of_enclosure"] == "CUSTOM") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "CUSTOM", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "CUSTOM", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard["make_of_enclosure"] == "INNERDOORS") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "INNERDOORS", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "INNERDOORS", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");
$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
if ($jobcard['make_of_enclosure'] == 'STANDARD') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "STANDARD", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "STANDARD", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['make_of_enclosure'] == 'FACIAS') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "FACIAS", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "FACIAS", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");



$pdf->Cell(185 / 7, 5, "", "L", 0, "L");
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(185 / 7, 5, "NB: FACIAS AND INNER DOORS TAKE 160MM OF PANEL WIDTH", "", 0, "L");
$pdf->SetFont('Arial', '', 6);
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");



// CABLE ENTRY
$pdf->Cell(185 / 7, 5, "CABLE ENTRY", "LR", 0, "L");
if ($jobcard['cable_entry'] == 'TOP') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "TOP", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "TOP", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['cable_entry'] == 'BOTTOM') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "BOTTOM", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "BOTTOM", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['cable_entry'] == 'BOTH') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "BOTH", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "BOTH", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");


// PANEL BASE SIZE
$pdf->Cell(185 / 7, 5, "PANEL BASE SIZE", "LR", 0, "L");
if ($jobcard['panel_base_size'] == '76MM') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "76MM", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "76MM", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['panel_base_size'] == '100MM') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "100MM", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "100MM", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['panel_base_size'] != '76MM' && $jobcard['panel_base_size'] != '100MM') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['panel_base_size'], "LBRT", 1, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");
}


// LOOSE GLAND PLATES
$pdf->Cell(185 / 7, 5, "LOOSE GLAND PLATES", "LR", 0, "L");
if ($jobcard['loose_gland_plates'] == 'TOP') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "TOP", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "TOP", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['loose_gland_plates'] == 'BOTTOM') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "BOTTOM", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "BOTTOM", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['loose_gland_plates'] == 'BOTH') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "BOTH", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "BOTH", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");



// LOCK TYPES
$pdf->Cell(185 / 7, 5, "LOCK TYPES", "LR", 0, "L");
if ($jobcard['lock_types'] == 'SQUARE') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "SQUARE", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "SQUARE", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['lock_types'] == 'KIOSK') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "KIOSK", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "KIOSK", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['lock_types'] != 'SQUARE' && $jobcard['lock_types'] != 'KIOSK') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['lock_types'], "LBRT", 1, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");
}


// COLOUR
$pdf->Cell(185 / 7, 5, "COLOUR", "LR", 0, "L");
if ($jobcard['colour'] == 'ORANGE') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "ORANGE", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "ORANGE", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");

if ($jobcard['colour'] == 'CH/GREY') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "CH/GREY", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "CH/GREY", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['colour'] == 'RAL732') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "RAL732", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "RAL732", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");
$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
if ($jobcard['colour'] == 'AVOGREEN') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "AVOGREEN", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "AVOGREEN", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['colour'] == 'BS/GREY') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "BS/GREY", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "BS/GREY", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['colour'] != 'ORANGE' && $jobcard['colour'] != 'CH/GREY' && $jobcard['colour'] != 'RAL732' && $jobcard['colour'] != 'AVOGREEN' && $jobcard['colour'] != 'BS/GREY') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['colour'], "LBRT", 1, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");
}

// MAIN VOLTAGE
$pdf->Cell(185 / 7, 5, "MAIN VOLTAGE", "LR", 0, "L");
if ($jobcard['main_voltage'] == '220V') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "220V", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "220V", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['main_voltage'] == '380V') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "380V", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "380V", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['main_voltage'] == '525V') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "525V", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "525V", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");


// CONTROLS FORM
$pdf->Cell(185 / 7, 5, "CONTROLS FORM", "LR", 0, "L");
if ($jobcard['controls_form'] == 'COMMON') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "COMMON", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "COMMON", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard["controls_form"] == "MAINS") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "MAINS", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "MAINS", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");


// CONTROL VOLTAGE
$pdf->Cell(185 / 7, 5, "CONTROL VOLTAGE", "LR", 0, "L");
if ($jobcard["control_voltage"] == "24VAC/DC") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "24VAC/DC", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "24VAC/DC", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['control_voltage'] == '110V') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "110V", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "110V", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['control_voltage'] == '220V') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "220V", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "220V", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
if ($jobcard["control_voltage"] == "380V") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "380V", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "380V", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['control_voltage'] == '525V') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "525V", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "525V", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['control_voltage'] != '24VAC/DC' && $jobcard['control_voltage'] != '110V' && $jobcard['control_voltage'] != '220V' && $jobcard['control_voltage'] != '380V' && $jobcard['control_voltage'] != '525V') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, $jobcard['control_voltage'], "LBRT", 1, "L");
    $pdf->SetFillColor(255, 255, 255);
} else {

    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");
}

// INCOMER
$pdf->Cell(185 / 7, 5, "INCOMER", "LR", 0, "L");
if ($jobcard['incomer'] == 'ISOLATOR') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "ISOLATOR", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "ISOLATOR", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard["incomer"] == "BREAKER") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "BREAKER", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "BREAKER", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");

// STARTER TYPPE
$pdf->Cell(185 / 7, 5, "STARTER TYPE", "LR", 0, "L");
if ($jobcard['starter_type'] == 'DOL') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "DOL", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "DOL", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['starter_type'] == 'S/DELTA') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "S/DELTA", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "S/DELTA", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['starter_type'] == 'SOFTSTART') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "SOFTSTART", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "SOFTSTART", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
if ($jobcard["starter_type"] == "VSD") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "VSD", "LBRT", 0, "L");
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "VSD", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['starter_type'] != 'VSD' && $jobcard['starter_type'] != 'DOL' && $jobcard['starter_type'] != 'S/DELTA' && $jobcard['starter_type'] != 'SOFTSTART') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['starter_type'], "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "OTHER", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");

// AMMETERS
$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
if ($jobcard['ammeters'] != '') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "AMMETERS", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['ammeters'], "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "AMMETERS", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
}

// VOLTMETER
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
if ($jobcard['voltmeter'] != '') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "VOLTMETER", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['voltmeter'], "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "VOLTMETER", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");


// MOTOR KW RATING
$pdf->Cell(185 / 7, 5, "MOTOR KW RATING", "LR", 0, "L");
if ($jobcard['motor_kw_rating'] != '') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, $jobcard['motor_kw_rating'], "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "IF TENDER CHECK DOCUMENT FOR LIST", "BT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "B", 0, "L");
$pdf->Cell(185 / 7, 5, "", "B", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");


// MOTOR TYPE
$pdf->Cell(185 / 7, 5, "MOTOR TYPE", "LR", 0, "L");
if ($jobcard['motor_type'] == 'CONV') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "CONV", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "CONV", "LBRT", 0, "L");

}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['motor_type'] == 'PUMP') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "PUMP", "", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "PUMP", "", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['motor_type'] == 'SUBMERS') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "SUBMERS", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "SUBMERS", "LBRT", 0, "L");
}
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
if ($jobcard['motor_type'] == 'CRUSH') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "CRUSH", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "CRUSH", "LBRT", 0, "L");
}


$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
if ($jobcard['gearbox'] == 'YES') {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "GEARBOX", "TB", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['gearbox'], "B", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "GEARBOX", "TB", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "B", 0, "L");
}

$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");

$pdf->Cell(185 / 7, 5, "PROTECTION", "LR", 0, "L");
$pdf->Cell(185 / 7, 5, "O/L", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "S/S", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "VSD", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
$pdf->Cell(185 / 7, 5, "PRESS LO", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "PRESS HI", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
$pdf->Cell(185 / 7, 5, "LEVEL LO", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "LEVEL HI", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
$pdf->Cell(185 / 7, 5, "FLOW", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "MECH", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "ELECT", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
$pdf->Cell(185 / 7, 5, "TYPEBALL", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "PROBES", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LR", 0, "L");
if ($jobcard['earth_leak'] == "YES") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "EARTH LEAK", "TB", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, "", "TB", 0, "L");
    $pdf->Cell(185 / 7, 5, "YES", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, "NO", "LBRT", 0, "L");
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "EARTH LEAK", "TB", 0, "L",1);
    $pdf->Cell(185 / 7, 5, "", "TB", 0, "L");
    $pdf->Cell(185 / 7, 5, "YES", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "NO", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
}

if ($jobcard['ma_rating'] != "") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "Ma RATING", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, $jobcard['ma_rating'], "LBRT", 1, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->Cell(185 / 7, 5, "Ma RATING", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 1, "L");
}


$pdf->Cell(185 / 7, 5, "INSTALLATION", "LR", 0, "L");
if ($jobcard['installation'] == "YES") {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "YES", "LBRT", 0, "L", 1);
    $pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "NO", "LBRT", 0, "L");
    $pdf->SetFillColor(255, 255, 255);
} else {
    $pdf->SetFillColor(185, 185, 185);
    $pdf->Cell(185 / 7, 5, "YES", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
    $pdf->Cell(185 / 7, 5, "NO", "LBRT", 0, "L", 1);
    $pdf->SetFillColor(255, 255, 255);
}

$pdf->Cell(185 / 7, 5, "", "LBRT", 0, "L");
$pdf->Cell(185 / 7, 5, "", "", 0, "L");
$pdf->Cell(185 / 7, 5, "", "R", 1, "L");

$pdf->Cell(185 / 7, 5, "", "LB", 0, "L");
$pdf->Cell(185 / 7, 5, "", "B", 0, "L");
$pdf->Cell(185 / 7, 5, "", "B", 0, "L");
$pdf->Cell(185 / 7, 5, "", "B", 0, "L");
$pdf->Cell(185 / 7, 5, "", "B", 0, "L");
$pdf->Cell(185 / 7, 5, "", "B", 0, "L");
$pdf->Cell(185 / 7, 5, "", "BR", 1, "L");

$pdf->SetFont('Arial', 'B', 10);

$pdf->Cell(185, 15, "ORIGINATOR SIGNATURE:__________________________________", "", 1, "L");
$pdf->Cell(185, 15, "PROJECTS SIGNATURE:__________________________________", "", 1, "L");


$pdf->Output("I");
