<?php

include "../../classes/autoload.php";

$html = new html("");
$app = new inner_app();
$app->quick_bar("/app/job_cards");
$app->app_start();
$app_functions = new app_features();

$job_card_no = $app_functions->get_next_job_card_no();
$job_card_no = substr($job_card_no, 0, 2) . "-" . substr($job_card_no, 2);
?>

<script>
    function get_subcategories(input, i) {
        var category_id = input.value;
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                document.getElementById('file_subcategory_' + i).innerHTML = this.responseText;
            }
        };
        xhttp.open("POST", "file_subcategories.ajax.php", true);
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhttp.send("file_category_id=" + category_id);

    }
</script>

<form id="job_card_form" method="POST" action="save_job_card.php" enctype="multipart/form-data">
    <div class="column width_80 background_1 border_radius">
        <h1>NEW JOB CARD</h1>
        <div class="row width_90 border_2 padding">
            <div class="column width_50 ">
                <label>Job Card No</label>
                <input type="text" class="width_80" id='job_card_no' required name='job_card_no' readonly
                    value="<?php echo $job_card_no; ?>" />
                <label>Date Opened</label>
                <input type="date" class="width_80" id='date_opened' required name='date_opened' />
                <label>Date Required</label>
                <input type="date" class="width_80" id='date_required' required name="date_required" />
                <label>Rep / Originator</label>
                <select class="width_80" id='rep_originator' required name='rep_originator'>
                    <option value="">SELECT A USER</option>
                    <?php $app_functions->get_users_list(); ?>
                </select>
            </div>
            <div class="column width_50 ">
                <label>Costing Amount</label>
                <input type="text" step="0.01" class="width_80" id='costing_amount' onkeyup="number_formater(this)"
                    name='costing_amount' />
                <label>Quote No</label>
                <input type="text" class="width_80" id='quote_number' name='quote_number' />
                <label>Quote Amount</label>
                <input type="text" step="0.01" class="width_80" id='quote_amount' onkeyup="number_formater(this)"
                    name="quote_amount" />
                <label>Invoice No</label>
                <input type="text" class="width_80" id='invoice_number' name='invoice_number' />
                <label>Invoice Amount</label>
                <input type="text" step="0.01" class="width_80" id='invoice_amount' onkeyup="number_formater(this)"
                    name='invoice_amount' />

                <script>
                    function number_formater(input) {
                        // Remove everything except digits and decimal
                        let value = input.value.replace(/[^0-9.]/g, '');

                        // Split into whole and decimal
                        let parts = value.split('.');
                        let whole = parts[0];
                        let decimal = parts.length > 1 ? '.' + parts[1].substring(0, 2) : ''; // limit 2 decimals

                        // Add thousand separators to whole number
                        whole = whole.replace(/\B(?=(\d{3})+(?!\d))/g, ",");

                        // Ensure R in front
                        input.value = "R " + whole + decimal;
                    }
                </script>
            </div>

        </div>
        <h1>CLIENT DETAILS</h1>
        <div class="column width_80 border_2 padding">
            <div class="row width_100 padding   " style="border-bottom: 1px solid #f78c42;">
                <div class="column width_100">
                    <label>Company name</label>
                    <input type="text" class="width_80" id='company_name' name='company_name' />
                </div>
                <div class="column width_100">
                    <label>Account Number</label>
                    <input type="text" class="width_80" id='account_no' name='account_no' />
                </div>
                <div class="column width_100">
                    <label>Vat Number</label>
                    <input type="text" class="width_80" id='vat_no' name='vat_no' />
                </div>
                <div class="column width_100">
                    <label>Order Number</label>
                    <input type="text" class="width_80" id='customer_order_no' name='customer_order_no' />
                </div>
            </div>
            <div class="column width_90">
                <div class="row padding" style="    column-gap: 2em;">
                    <h1>CONTACT DETAILS</h2>
                        <script>
                            index_ing = 9999;
                            function add_contact_details() {
                                event.preventDefault();
                                var contact_details = document.getElementById('contact_details');
                                var new_contact_details = document.createElement('div');
                                new_contact_details.className = 'row width_100';
                                new_contact_details.id = 'record_id_' + index_ing;
                                new_contact_details.innerHTML = `
                                    <div class="column width_100">
                                        <label>Person</label>
                                        <input type="text" class="width_80" id='contact_person[]' name='contact_person[]' />
                                    </div>
                                    <div class="column width_100">
                                        <label>Cell No</label>
                                        <input type="text" class="width_80" id='phone[]' name='cell_no[]' />
                                    </div>
                                    <div class="column width_100">
                                        <label>Email</label>
                                        <input type="email" class="width_80" id='email[]' name='email[]' />
                                    </div>
                                        <div class="column width_100">
                                        <label>Job Description</label>
                                        <input type="text" class="width_80" id='description[]' name='description[]' />
                                    </div>
                                    <div class=\"column width_100\">
                                        <button onclick=\"delete_contact_details(`+ index_ing + `)\">DELETE</button>
                                    </div>
                                `;
                                contact_details.appendChild(new_contact_details);
                                index_ing++;
                            }

                            function delete_contact_details(record_id) {
                                event.preventDefault();
                                document.getElementById('record_id_' + record_id).remove();
                            }
                        </script>
                </div>
                <div class="width_100" id="contact_details">

                </div>
                <br>
                <button onclick="add_contact_details()" class="width_90">ADD</button>
            </div>
        </div>
        <h1>OPERATION DETAILS</h1>
        <div class="row width_80">
            <div class="column width_50">
                <label>Installation</label>

                <select class="width_80" id='installation' name='installation'>
                    <option value="1">Yes</option>
                    <option value="0">No</option>
                </select>
                <label>COJ / JOB CARD NO</label>

                <input type="text" class="width_80" id='coj_jobcard_no' name='coj_jobcard_no' />
                <label>Project Manager</label>

                <select id="project_manager" name="project_manager" class="width_80">
                    <option value="">SELECT A USER</option>
                    <?php $app_functions->get_users_list(); ?>
                </select>
            </div>
        </div>
        <br>
        <div class="column width_90 padding border_2">
            <div class="row padding" style=" column-gap: 2em;">
                <div class="column width_100">
                    <h1>JOB CARD SECTIONS</h1>
                    <label>Project Name</label>
                    <textarea type="text" class="width_100" style="width: 50vw;font-size: 1.5em;" rows="3" id='project_name'
                        name='project_name'></textarea>
                    <label>Sub Job Card Qty's</label>
                    <input id="number_of_sections" type="number" step="1" min="1" name="number_of_sections"
                        onchange="add_numbers()">
                </div>
                <script>

                    function get_next_letter() {
                        var inputs = document.getElementsByName('section[]');
                        var letters = 'abcdefghijklmnopqrstuvwxyz';

                        function strToNum(str) {
                            let num = 0;
                            for (let i = 0; i < str.length; i++) {
                                num = num * 26 + (letters.indexOf(str[i]) + 1);
                            }
                            return num;
                        }

                        function numToStr(num) {
                            let str = '';
                            while (num > 0) {
                                num--;
                                str = letters[num % 26] + str;
                                num = Math.floor(num / 26);
                            }
                            return str.toUpperCase();
                        }

                        let maxNum = 0;
                        for (let i = 0; i < inputs.length; i++) {
                            let val = inputs[i].value.toLowerCase().trim();
                            if (val) {
                                let num = strToNum(val);
                                if (num > maxNum) {
                                    maxNum = num;
                                }
                            }
                        }
                        if (maxNum === 0) {
                            return 'A';
                        }
                        return numToStr(maxNum + 1);
                    }

                    section_index = 10000;
                    function add_section_details() {
                        event.preventDefault();
                        var section_details = document.getElementById('section_details');
                        var new_section_details = document.createElement('div');
                        new_section_details.className = 'row width_100';
                        new_section_details.id = 'section_id_' + section_index;
                        new_section_details.innerHTML = `
                                    <div class="column width_100">
                                        <label>SUB SECTION</label>

                                        <input type="text" class="width_80" id='section[]' name='section[]'
                                            value='` + get_next_letter() + `' />
                                    </div>
                                    <div class="column width_100">
                                        <label>DESCRIPTION</label>
                                        <input type="text" class="width_80" id='section_description[]' name='section_description[]' />
                                    </div>
                                           <div class=\"column width_100\">
                                        <button onclick=\"delete_section(`+ section_index + `)\">DELETE</button>
                                    </div>
                                `;
                        section_index++;
                        section_details.appendChild(new_section_details);
                    }
                    function delete_section(record_id) {
                        event.preventDefault();
                        document.getElementById('section_id_' + record_id).remove();
                    }
                    function add_numbers() {
                        var num = parseInt(document.getElementById('number_of_sections').value) || 0;
                        var section_details = document.getElementById('section_details');

                        // 1. Remove sections without description
                        var sections = section_details.querySelectorAll('.row.width_100');
                        sections.forEach(sec => {
                            let desc = sec.querySelector("input[name='section_description[]']").value.trim();
                            if (desc === "") {
                                section_details.removeChild(sec);
                            }
                        });

                        // 2. Count remaining sections
                        sections = section_details.querySelectorAll('.row.width_100');
                        var count = sections.length;

                        // 3. Add sections if fewer than desired
                        while (count < num) {
                            add_section_details();
                            count++;
                        }

                        // 4. Remove extra sections if more than desired
                        while (count > num) {
                            section_details.removeChild(section_details.lastElementChild);
                            count--;
                        }
                    }


                </script>
            </div>
            <div class="width_100" id="section_details">

            </div>
            <br>
            <button onclick="add_section_details()" class="width_90">ADD</button>

        </div>

        <div class="column width_90 padding border_2">
            <div class="row padding" style=" column-gap: 2em;">
                <h1>JOB CARD ATTACHMENTS</h1>
                <script>
                    function add_attachments_details() {
                        event.preventDefault();
                        index = 99999;
                        var attachment_details = document.getElementById('attachment_details');
                        var new_attachment_details = document.createElement('div');
                        new_attachment_details.className = 'row width_100';
                        new_attachment_details.innerHTML = `
                  
                    <div class="column width_100">
                        <label>DESCRIPTION</label>
                        <input type="text" class="width_80" id='attachment_description[]' name='attachment_description[]' />
                    </div>
                        <div class="column width_100">
                        <label>CATEGORY</label>
                        <select class="width_80" onchange="get_subcategories(this,`+ index + `)" name='file_category[]' />
                        <?php
                        echo $function->get_file_categories();
                        ?>
                        </select>
                    </div>
                    </div>
                        <div class="column width_100">
                        <label>SUBCATEGORY</label>
                        <select  class="width_80" id='file_subcategory_`+ index + `' name='file_subcategory[]' />
                        </select>

                    </div>
                    </div>
                        <div class="column width_100">
                        <label>FILE</label>
                        <input type="file" class="width_80" id='attachment_file[]' name='attachment_file[]' />
                    </div>
                    `;
                        attachment_details.appendChild(new_attachment_details);
                        index++;
                    }
                    function delete_attachment_details(record_id, attachment) {
                        event.preventDefault();
                        document.getElementById('attachment_details').removeChild(document.getElementById('attachment_' + record_id));
                        var xhttp = new XMLHttpRequest();
                        xhttp.onreadystatechange = function () {
                            if (this.readyState == 4 && this.status == 200) {
                                // console.log(this.responseText);
                            }
                        };
                        xhttp.open("POST", "delete_attachment.php", true);
                        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                        xhttp.send("record_id=" + record_id + "&attachment_file=" + attachment);

                    }

                </script>
            </div>
            <div class="width_100" id="attachment_details">

            </div>
            <br>
            <button onclick="add_attachments_details()" class="width_90">ADD</button>

        </div>
        <br><br>
        <div class="column width_80 padding border_2">
            <h1>NOTES</h1>
            <textarea name="notes" id="notes" class="width_100" rows="10"></textarea>
        </div>

        <br>
        <h1 hidden>ADDITIONAL DETAILS</h1>
        <div class="row width_100" style="display: none;">
            <div class="column width_100 row_gap_2">
                <!-- start of ADDITIONAL DETAILS DIV -->

                <div class="row width_100">
                    <label class="width_30">TYPE ENCLOSURE</label>
                    <select class="width_20" id='type_enclosure' name='type_enclosure'
                        onchange="check_other_enclosuer()">
                        <option value="">N/A</option>
                        <option value="KIOSK">KIOSK</option>
                        <option value="WALL">WALL</option>
                        <option value="FLOOR">FLOOR</option>
                        <option value="POLE">POLE</option>
                        <option value="OTHER">OTHER</option>
                    </select>
                    <input type="text" id="other_enclosure" class="width_40"
                        style="display: none;margin-left: 1em; margin-right: 1em;" name="other_enclosure"
                        placeholder="Please Specify">
                    <script>
                        function check_other_enclosuer() {
                            if (document.getElementById('type_enclosure').value == 'OTHER') {
                                document.getElementById('other_enclosure').style.display = 'block';
                            } else {
                                document.getElementById('other_enclosure').style.display = 'none';
                            }
                        }
                    </script>
                </div>

                <div class="row width_100">
                    <label class="width_30">STEEL TYPE</label>
                    <select class="width_20" id='steel_type' name='steel_type'>
                        <option value="">N/A</option>
                        <option value="MILD">MILD</option>
                        <option value="3CR12">3CR12</option>
                        <option value="304">304</option>
                    </select>
                </div>

                <div class="row width_100">
                    <label class="width_30">STEEL THICKNESS</label>
                    <input type="text" class="width_50" id='steel_thickness' name='steel_thickness' />
                </div>


                <div class="row width_100">
                    <label class="width_30">IP RATING</label>
                    <input type="text" class="width_50" id='ip_rating' name='ip_rating' />
                </div>


                <div class="row width_100">
                    <label class="width_30">TYPE OF ENCLOSURE</label>
                    <select class="width_20" id='type_of_enclosure' name='type_of_enclosure'>
                        <option value="">N/A</option>
                        <option value="S.A.B.S">S.A.B.S</option>
                        <option value="NON S.A.B.S">NON S.A.B.S</option>
                    </select>
                </div>

                <div class="row width_100">
                    <label class="width_30">MAKE OF ENCOLURE</label>
                    <select class="width_20" id='make_of_enclosure' name='make_of_enclosure'>
                        <option value="">N/A</option>
                        <option value="CUSTOM">CUSTOM</option>
                        <option value="INNERDOORS">INNERDOORS</option>
                        <option value="STANDARD">STANDARD</option>
                        <option value="FACIAS">FACIAS</option>
                    </select>
                </div>


                <div class="row width_100">
                    <label class="width_30">CABLE ENTRY</label>
                    <select class="width_20" id='cable_entry' name='cable_entry'>
                        <option value="">N/A</option>
                        <option value="TOP">TOP</option>
                        <option value="BOTTOM">BOTTOM</option>
                        <option value="BOTH">BOTH</option>
                    </select>
                </div>



                <div class="row width_100">
                    <label class="width_30">PANEL BASE SIZE</label>
                    <select class="width_20" id='panel_base_size' name='panel_base_size'
                        onchange="check_panel_base_size_other()">
                        <option value="">N/A</option>
                        <option value="76MM">76MM</option>
                        <option value="100MM">100MM</option>
                        <option value="OTHER">OTHER</option>
                    </select>
                    <input type="text" id="other_panel_base_size" class="width_40"
                        style="display: none;margin-left: 1em; margin-right: 1em;" name="other_panel_base_size"
                        placeholder="Please Specify">
                    <script>
                        function check_panel_base_size_other() {
                            if (document.getElementById('panel_base_size').value == 'OTHER') {
                                document.getElementById('other_panel_base_size').style.display = 'block';
                            } else {
                                document.getElementById('other_panel_base_size').style.display = 'none';
                            }
                        }
                    </script>
                </div>


                <div class="row width_100">
                    <label class="width_30">LOOSE GLAND PLATES</label>
                    <select class="width_20" id='loose_gland_plates' name='loose_gland_plates'>
                        <option value="">N/A</option>
                        <option value="TOP">TOP</option>
                        <option value="BOTTOM">BOTTOM</option>
                        <option value="BOTH">BOTH</option>
                    </select>
                </div>


                <div class="row width_100">
                    <label class="width_30">LOCK TYPES</label>
                    <select class="width_20" id='lock_types' name='lock_types' onchange="check_lock_types_other()">
                        <option value="">N/A</option>
                        <option value="SQUARE">SQUARE</option>
                        <option value="KIOSK">KIOSK</option>
                        <option value="OTHER">OTHER</option>
                    </select>
                    <input type="text" id="other_lock_types" class="width_40"
                        style="display: none;margin-left: 1em; margin-right: 1em;" name="other_lock_types"
                        placeholder="Please Specify">
                    <script>
                        function check_lock_types_other() {
                            if (document.getElementById('lock_types').value == 'OTHER') {
                                document.getElementById('other_lock_types').style.display = 'block';
                            } else {
                                document.getElementById('other_lock_types').style.display = 'none';
                            }
                        }
                    </script>
                </div>



                <div class="row width_100">
                    <label class="width_30">COLOUR</label>
                    <select class="width_20" id='colour' name='colour' onchange="check_colour_other()">
                        <option value="">N/A</option>
                        <option value="ORANGE">ORANGE</option>
                        <option value="CH/GREY">CH/GREY</option>
                        <option value="RAL732">RAL732</option>
                        <option value="AVOGREEN">AVOGREEN</option>
                        <option value="BS/GREY">BS/GREY</option>
                        <option value="OTHER">OTHER</option>
                    </select>
                    <input type="text" id="other_colour" class="width_40"
                        style="display: none;margin-left: 1em; margin-right: 1em;" name="other_colour"
                        placeholder="Please Specify">
                    <script>
                        function check_colour_other() {
                            if (document.getElementById('colour').value == 'OTHER') {
                                document.getElementById('other_colour').style.display = 'block';
                            } else {
                                document.getElementById('other_colour').style.display = 'none';
                            }
                        }
                    </script>
                </div>


                <div class="row width_100">
                    <label class="width_30">MAIN VOLTAGE</label>
                    <select class="width_20" id='main_voltage' name='main_voltage'>
                        <option value="">N/A</option>
                        <option value="220V">220V</option>
                        <option value="380V">380V</option>
                        <option value="525V">525V</option>
                    </select>
                </div>

                <div class="row width_100">
                    <label class="width_30">CONTROLS FORM</label>
                    <select class="width_20" id='controls_form' name='controls_form'>
                        <option value="">N/A</option>
                        <option value="COMMON">COMMON</option>
                        <option value="MAINS">MAINS</option>
                    </select>
                </div>


                <div class="row width_100">
                    <label class="width_30">CONTROL VOLTAGE</label>
                    <select class="width_20" id='control_voltage' name='control_voltage'
                        onchange="check_control_voltage_other()">
                        <option value="">N/A</option>
                        <option value="24VAC/DC">24VAC/DC</option>
                        <option value="110V">110V</option>
                        <option value="220V">220V</option>
                        <option value="380V">380V</option>
                        <option value="525V">525V</option>
                        <option value="OTHER">OTHER</option>
                    </select>
                    <input type="text" id="other_control_voltage" class="width_40"
                        style="display: none;margin-left: 1em; margin-right: 1em;" name="other_control_voltage"
                        placeholder="Please Specify">
                    <script>
                        function check_control_voltage_other() {
                            if (document.getElementById('control_voltage').value == 'OTHER') {
                                document.getElementById('other_control_voltage').style.display = 'block';
                            } else {
                                document.getElementById('other_control_voltage').style.display = 'none';
                            }
                        }
                    </script>
                </div>

                <div class="row width_100">
                    <label class="width_30">INCOMER</label>
                    <select class="width_20" id='incomer' name='incomer'>
                        <option value="">N/A</option>
                        <option value="ISOLATOR">ISOLATOR</option>
                        <option value="BREAKER">BREAKER</option>
                    </select>
                </div>

                <div class="row width_100">
                    <label class="width_30">STARTER TYPE</label>
                    <select class="width_20" id='starter_type' name='starter_type'
                        onchange="check_starter_type_other()">
                        <option value="">N/A</option>
                        <option value="DOL">DOL</option>
                        <option value="S/DELTA">S/DELTA</option>
                        <option value="SOFTSTART">SOFTSTART</option>
                        <option value="VSD">VSD</option>
                        <option value="OTHER">OTHER</option>
                    </select>
                    <input type="text" id="other_starter_type" class="width_40"
                        style="display: none;margin-left: 1em; margin-right: 1em;" name="other_starter_type"
                        placeholder="Please Specify">
                    <script>
                        function check_starter_type_other() {
                            if (document.getElementById('starter_type').value == 'OTHER') {
                                document.getElementById('other_starter_type').style.display = 'block';
                            } else {
                                document.getElementById('other_starter_type').style.display = 'none';
                            }
                        }
                    </script>
                </div>

                <div class="row width_100">
                    <label class="width_30">AMMETERS</label>
                    <input type="text" class="width_50" id='ammeters' name='ammeters' />
                </div>


                <div class="row width_100">
                    <label class="width_30">VOLTMETER</label>
                    <input type="text" class="width_50" id='voltmeter' name='voltmeter' />
                </div>

                <div class="row width_100">
                    <label class="width_30">MOTOR KW RATING</label>
                    <input type="text" class="width_50" id='motor_kw_rating' name='motor_kw_rating' />
                </div>

                <div class="row width_100">
                    <label class="width_30">MOTOR TYPE</label>
                    <select class="width_20" id='motor_type' name='motor_type'>
                        <option value="">N/A</option>
                        <option value="CONV">CONV</option>
                        <option value="PUMP">PUMP</option>
                        <option value="SUBMERS">SUBMERS</option>
                        <option value="CRUSH">CRUSH</option>
                    </select>
                </div>

                <div class="row width_100">
                    <label class="width_30">GEARBOX</label>
                    <select class="width_20" id='GEARBOX' name='GEARBOX'>
                        <option value="">N/A</option>
                        <option value="YES">YES</option>
                        <option value="NO">NO</option>
                    </select>
                </div>

                <div class="row width_100">
                    <label class="width_30">EARTH LEAK</label>
                    <select class="width_20" id='earth_leak' name='earth_leak'>
                        <option value="">N/A</option>
                        <option value="YES">YES</option>
                        <option value="NO">NO</option>
                    </select>
                </div>

                <div class="row width_100">
                    <label class="width_30">Ma RATING</label>
                    <input type="text" class="width_50" id='ma_rating' name='ma_rating' />
                </div>


                <!-- END OF ADDITIONAL DETAILS DIV -->

            </div>
        </div>

        <br>
        <button class="width_90" style="    position: absolute;
    top: 3vh;
    left: 92vw;
    height: 10vh;
    width: 5vw;" onclick="save()">SAVE</button>
    </div>


</form>
<script>
    function save() {

        var inputs = document.getElementsByTagName('input');
        var selects = document.getElementsByTagName('select');
        var unfilled = false;
        for (var i = 0; i < inputs.length; i++) {
            if (inputs[i].type != 'file' && inputs[i].value == '') {
                unfilled = true;
                break;
            }
        }
        for (var i = 0; i < selects.length; i++) {
            if (selects[i].value == '') {
                unfilled = true;
                break;
            }
        }
        if (unfilled) {
            return;
        }

        var overlay = document.createElement('div');
        overlay.className = 'overlay';
        overlay.innerHTML = `
         <div class="lds-roller">
             <div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div>
         </div>
         <style>
             .lds-roller {
                 display: inline-block;
             position: relative;
             width: 80px;
             height: 80px;
                                }
             .lds-roller div {
                 animation: lds-roller 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;
             transform-origin: 40px 40px;
                                }
             .lds-roller div:after {
                 content: " ";
             display: block;
             position: absolute;
             width: 7px;
             height: 7px;
             border-radius: 50%;
             background: #fff;
             margin: -4px 0 0 -4px;
                                }
             .lds-roller div:nth-child(1) {
                 animation - delay: -0.036s;
                                }
             .lds-roller div:nth-child(1):after {
                 top: 63px;
             left: 63px;
                                }
             .lds-roller div:nth-child(2) {
                 animation - delay: -0.072s;
                                }
             .lds-roller div:nth-child(2):after {
                 top: 68px;
             left: 56px;
                                }
             .lds-roller div:nth-child(3) {
                 animation - delay: -0.108s;
                                }
             .lds-roller div:nth-child(3):after {
                 top: 71px;
             left: 48px;
                                }
             .lds-roller div:nth-child(4) {
                 animation - delay: -0.144s;
                                }
             .lds-roller div:nth-child(4):after {
                 top: 72px;
             left: 40px;
                                }
             .lds-roller div:nth-child(5) {
                 animation - delay: -0.18s;
                                }
             .lds-roller div:nth-child(5):after {
                 top: 71px;
             left: 32px;
                                }
             .lds-roller div:nth-child(6) {
                 animation - delay: -0.216s;
                                }
             .lds-roller div:nth-child(6):after {
                 top: 68px;
             left: 24px;
                                }
             .lds-roller div:nth-child(7) {
                 animation - delay: -0.252s;
                                }
             .lds-roller div:nth-child(7):after {
                 top: 63px;
             left: 17px;
                                }
             .lds-roller div:nth-child(8) {
                 animation - delay: -0.288s;
                                }
             .lds-roller div:nth-child(8):after {
                 top: 56px;
             left: 12px;
                                }
             @keyframes lds-roller {
                 0 % {
                     transform: rotate(0deg);
                 }
                                    100% {
                 transform: rotate(360deg);
                                    }
                                }
         </style>
                        `;
        document.body.appendChild(overlay);
        overlay.style.display = 'flex';
        overlay.style.alignItems = 'center';
        overlay.style.justifyContent = 'center';

    }
</script>