<?php
session_start();
include "../../classes/html_items.php";
$dash = new dash_items();

include "../../classes/db.class.php";
include "../../functions.class.php";
include "../../classes/dashboard.class.php";
$functions = new functions();

function get_day_of_the_week($date)
{
    $date = date('w', strtotime($date));
    switch ($date) {
        case 0:
            return 'Sunday';
        case 1:
            return 'Monday';
        case 2:
            return 'Tuesday';
        case 3:
            return 'Wednesday';
        case 4:
            return 'Thursday';
        case 5:
            return 'Friday';
        case 6:
            return 'Saturday';
    }
}


echo DashboardWidget::includeAssets();



$tank_res = $db->query("tanks", "SELECT * FROM tanks WHERE record_id = {$_GET['record_id']} AND company_id = {$_SESSION['company_id']}");
$tank = $tank_res->fetch_assoc();

?>
<style>
    body {
        margin-top: 1em;
        display: flex;
        flex-direction: column;
        flex-wrap: wrap;
        align-content: center;
        justify-content: flex-start;
        align-items: center;
        /* min-height: 100vh; */
        overflow-y: auto;
    }
</style>
<h1><?php echo $tank['name']; ?></h1>
<br>
<?php

$dash->tank($tank['record_id'], "#");
$dash->liters_bar("TODAY",$functions->total_liters_for_tank($_GET['record_id']));

$fuel_movement_res_table = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' )  AND tank_id = {$tank['record_id']} AND company_id = {$_SESSION['company_id']} AND amount > 100 ORDER BY record_id DESC LIMIT 10");
$table_data = [];

while ($fuel_movement = $fuel_movement_res_table->fetch_assoc()) {
    $table_data[] = [
        $functions->get_client_name($fuel_movement['client_id']),
        number_format(($fuel_movement['amount'] / 1000), 3),
        $fuel_movement['date_time_closed'],
        //$functions->get_username($fuel_movement['user_id']),
        'diesel/slip.pdf.php?record_id=' . $fuel_movement['record_id']
    ];
}
echo "<h2>RECENT MOVEMENTS</h2>";
echo DashboardWidget::tableBlock('', ['TAG', 'AMOUNT', "DATE"], $table_data, '90vw');



$data_array = [];
$date = date('Y-m-d') . ' 00:00';
$date2 = date('Y-m-d') . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}' AND tank_id = {$tank['record_id']}");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}' AND tank_id = {$tank['record_id']}");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}' AND tank_id = {$tank['record_id']}");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}' AND tank_id = {$tank['record_id']}");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}' AND tank_id = {$tank['record_id']}");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}' AND tank_id = {$tank['record_id']}");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}' AND tank_id = {$tank['record_id']}");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(amount) AS amount FROM fuel_movement WHERE ( `status` = 'DONE' OR status = 'MANUAL OVERRIDE' OR status = 'RFID' ) AND company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$date}' AND '{$date2}' AND tank_id = {$tank['record_id']}");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

echo "<h2>LAST 7 DAYS</h2>";
echo DashboardWidget::columnGraph('', $data_array, '90vw');


$lastSixMonths = [];
for ($i = 0; $i <= 5; $i++) {
    $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

}
$amounts_arr = [];
foreach ($lastSixMonths as $key => $month) {
    $total_amount_res = $db->query("fuel_movement", "SELECT SUM(amount) AS total_amount FROM fuel_movement WHERE company_id = {$_SESSION['company_id']} AND date_time_closed BETWEEN '{$month}-01' AND '{$month}-31' AND tank_id = {$tank['record_id']}");
    $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month . '-01'))];
}
echo "<h2>MONTHLY</h2>";

echo DashboardWidget::columnGraph("", $amounts_arr, '90vw');

echo "<h2>TANK LEVEL</h2>";
$fuel_movement_res_table = $db->query("tank_level_log", "SELECT * FROM tank_level_log WHERE ( tank_id = {$tank['record_id']} ) ORDER BY record_id DESC LIMIT 10");
$table_data = [];

while ($fuel_movement = $fuel_movement_res_table->fetch_assoc()) {

    $tank_res = $db->query("tanks", "SELECT * FROM tanks WHERE record_id = {$tank['record_id']} AND company_id = {$_SESSION['company_id']} ORDER BY record_id DESC");
    $tank = $tank_res->fetch_assoc();

    if ($tank["tank_type"] == "H_C") {
        $data = $functions->calculate_horizontal_cylinder_volume($tank['radius_mm'], ($tank['radius_mm'] * 2) - $fuel_movement['distance'], $tank['length_mm']);
    } else {
        $data = $functions->calculate_vertical_cylinder_volume($tank['radius_mm'], ($tank['length_mm']) - $fuel_movement['distance'], $tank['length_mm']);
    }

    $table_data[] = [
        $fuel_movement['date_time_measured'],
        number_format(($data['fluid_volume_liters'] * $tank['tank_amount']) / $tank['devide_for_liters'], 2),
        //$functions->get_username($fuel_movement['user_id']),
        '#'
    ];
}
echo DashboardWidget::tableBlock('', ['DATE', 'LITERS'], $table_data, '90vw');


echo "<h2>CONNECTION LOGS</h2>";
$fuel_movement_res_table = $db->query("tank_level_log", "SELECT * FROM tank_level_log WHERE ( tank_id = {$tank['record_id']} ) ORDER BY record_id DESC LIMIT 10");
$table_data = [];

while ($fuel_movement = $fuel_movement_res_table->fetch_assoc()) {
    $table_data[] = [
        $fuel_movement['date_time_measured'],
        $fuel_movement['distance'],
        //$functions->get_username($fuel_movement['user_id']),
        '#'
    ];
}
echo DashboardWidget::tableBlock('', ['DATE', 'DISTANCE'], $table_data, '90vw');


echo "<div class='spacer'></div>";

?>

<br>
<br>
<br>
<br>