<?php
session_start();
include "../../classes/html_items.php";
include "../../classes/db.class.php";
include "../../functions.class.php";
include "../../classes/dashboard.class.php";
$functions = new functions();
$dash = new dash_items();
$functions = new functions();
function get_day_of_the_week($date)
{
    $date = date('w', strtotime($date));
    switch ($date) {
        case 0:
            return 'Sunday';
        case 1:
            return 'Monday';
        case 2:
            return 'Tuesday';
        case 3:
            return 'Wednesday';
        case 4:
            return 'Thursday';
        case 5:
            return 'Friday';
        case 6:
            return 'Saturday';
    }
}

echo DashboardWidget::includeAssets();
?>

<style>
    body {
        margin-top: 1em;
        display: flex;
        flex-direction: column;
        flex-wrap: wrap;
        align-content: center;
        justify-content: flex-start;
        align-items: center;
    }
</style>
<!-- <img src="/assets/logo_<?php echo $_SESSION['company_id']; ?>.jpg" alt="logo" style="width: 30em;"> -->
<div class="small_line"></div>
<h1>GROUP TANK LEVELS</h1>
<?php
$tanks_res = $db->query("tanks", "SELECT * FROM tanks WHERE record_id IN ({$_SESSION['tanks']}) AND company_id = {$_SESSION['company_id']} AND site_id = {$_GET['record_id']}");
while ($tank = $tanks_res->fetch_assoc()) {
    $dash->tank($tank['record_id'], "#");
}
?>
<div class="small_line"></div>
<h1>TOTAL</h1>
<?php
$site_res = $db->query("sites", "SELECT DISTINCT sites.record_id AS site_id, sites.name AS site_name FROM sites LEFT JOIN tanks ON sites.record_id = tanks.site_id WHERE  sites.record_id = {$_GET['record_id']} AND tanks.record_id IN ({$_SESSION['tanks']}) AND sites.company_id = {$_SESSION['company_id']}");
while ($site = $site_res->fetch_assoc()) {
    $tanks_res = $db->query("tanks", "SELECT * FROM tanks WHERE company_id = {$_SESSION['company_id']} AND site_id = {$site['site_id']}");
    $tank_total = 0;
    while ($tank = $tanks_res->fetch_assoc()) {
        $tank_total += $functions->total_liters_for_tank($tank['record_id']);
    }
    $site_name = $site['site_name'];
    $dash->liters_bar($site['site_name'], $tank_total);
}

?>

<div class="small_line"></div>
<h1>TOTAL PER PUMP</h1>
<?php
$tank_res = $db->query("tanks", "SELECT * FROM tanks WHERE record_id IN ({$_SESSION['tanks']}) AND company_id = {$_SESSION['company_id']} AND site_id = {$_GET['record_id']}");
while ($tank = $tank_res->fetch_assoc()) {
    $tanks_list[] = $tank['record_id'];

    $tank_total = $functions->total_liters_for_tank($tank['record_id']);

    $dash->liters_bar($tank['name'], $tank_total, "pump_view.php?tank_id={$tank['record_id']}");
}


$tanks = implode(' OR tank_id = ', $tanks_list);

$fuel_movement_res_table = $db->query("fuel_movement", "SELECT * FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.status = 'RFID' AND fm.tank_id = $tanks AND fm.company_id = {$_SESSION['company_id']} AND fm.amount > 100 AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.status = 'MANUAL OVERRIDE' AND fm.tank_id = $tanks AND fm.company_id = {$_SESSION['company_id']} AND fm.amount > 100 AND fm.client_id = 0) ORDER BY fm.date_time_closed DESC LIMIT 50");

$table_data = [];

while ($fuel_movement = $fuel_movement_res_table->fetch_assoc()) {
    $table_data[] = [
        $functions->get_tank_name($fuel_movement['tank_id']),
        $functions->get_client_name($fuel_movement['client_id']),
        number_format(($fuel_movement['amount'] / 1000), 3),
        $fuel_movement['date_time_closed'],
        //$functions->get_username($fuel_movement['user_id']),
        'diesel/slip.pdf.php?record_id=' . $fuel_movement['record_id']
    ];
}
echo "<h2>RECENT MOVEMENTS</h2>";
echo DashboardWidget::tableBlock('', ['PUMP', 'TAG', 'AMOUNT', "DATE"], $table_data, '90vw');
?>
<div class="small_line"></div>
<h1>7 DAYS (<?php echo $site_name; ?>)</h1>
<?php
$tanks_list = implode(',', $tanks_list);
$data_array = [];
$date = date('Y-m-d') . ' 00:00';
$date2 = date('Y-m-d') . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_list) AND  ( fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_list) AND  ( fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_list) AND  ( fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_list) AND  ( fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_list) AND  ( fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_list) AND  ( fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_list) AND  ( fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

$date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
$date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
$fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_list) AND  ( fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
$fuel_movement = $fuel_movement_array_res->fetch_assoc();
$data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

echo DashboardWidget::columnGraph('', $data_array, '90vw');

?>
<div class="small_line"></div>
<h1>MONTHLY (<?php echo $site_name; ?>)</h1>
<?php
$lastSixMonths = [];
for ($i = 0; $i <= 5; $i++) {
    $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

}

$amounts_arr = [];
foreach ($lastSixMonths as $key => $month) {

    $total_amount_res = $db->query("fuel_movement", "SELECT SUM(amount) AS total_amount FROM fuel_movement as fm LEFT JOIN clients AS c ON fm.client_id = c.record_id WHERE  (fm.tank_id IN ($tanks_list) AND  fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$month}-01 00:00' AND '{$month}-31 23:59' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_list) AND  fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$month}-01 00:00' AND '{$month}-31 23:59' AND fm.client_id = 0)");
    $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month . '-01'))];
}
echo DashboardWidget::columnGraph("", $amounts_arr, '90vw');



?>
<div class="small_line"></div>
<h1>PER PUMP</h1>
<?php
$tanks_res = $db->query("tanks", "SELECT * FROM tanks WHERE company_id = {$_SESSION['company_id']} AND site_id = {$_GET['record_id']}");
while ($tank = $tanks_res->fetch_assoc()) {


    $tanks_ids = $tank['record_id'];

    $data_array = [];
    $date = date('Y-m-d') . ' 00:00';
    $date2 = date('Y-m-d') . ' 23:59';
    

    $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_ids) AND (fm.status = 'RFID') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '$date 00:00' AND '$date2 23:59' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND fm.status = 'MANUAL OVERRIDE' AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '$date 00:00' AND '$date2 23:59' AND fm.client_id = 0)");

    $fuel_movement = $fuel_movement_array_res->fetch_assoc();
    $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

    $date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
    $date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
    $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_ids) AND (fm.status = 'RFID') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
    $fuel_movement = $fuel_movement_array_res->fetch_assoc();
    $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

    $date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
    $date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
    $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_ids) AND (fm.status = 'RFID') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
    $fuel_movement = $fuel_movement_array_res->fetch_assoc();
    $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

    $date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
    $date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
    $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_ids) AND (fm.status = 'RFID') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
    $fuel_movement = $fuel_movement_array_res->fetch_assoc();
    $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

    $date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
    $date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
    $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_ids) AND (fm.status = 'RFID') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
    $fuel_movement = $fuel_movement_array_res->fetch_assoc();
    $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

    $date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
    $date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
    $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_ids) AND (fm.status = 'RFID') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
    $fuel_movement = $fuel_movement_array_res->fetch_assoc();
    $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

    $date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
    $date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
    $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_ids) AND (fm.status = 'RFID') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
    $fuel_movement = $fuel_movement_array_res->fetch_assoc();
    $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

    $date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
    $date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
    $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement as fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE (fm.tank_id IN ($tanks_ids) AND (fm.status = 'RFID') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']}  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
    $fuel_movement = $fuel_movement_array_res->fetch_assoc();
    $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];
    ?>
    <div class="small_line"></div>
    <h1>7 DAYS (<?php echo $tank['name']; ?>) </h1>

    <?php
    echo DashboardWidget::columnGraph('', $data_array, '90vw');


    $lastSixMonths = [];
    for ($i = 0; $i <= 5; $i++) {
        $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

    }
    $amounts_arr = [];
    foreach ($lastSixMonths as $key => $month) {
        $total_amount_res = $db->query("fuel_movement", "SELECT SUM(fm.amount) AS total_amount FROM fuel_movement AS fm LEFT JOIN clients as c ON fm.client_id = c.record_id WHERE  (fm.tank_id IN ($tanks_ids) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$month}-01' AND '{$month}-31' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$month}-01' AND '{$month}-31' AND fm.client_id = 0)");
        $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month . '-01'))];
    }
    ?>
    <div class="small_line"></div>
    <h1>MONTHLY (<?php echo $tank['name']; ?>)</h1>

    <?php
    echo DashboardWidget::columnGraph("", $amounts_arr, '90vw');

}

?>



<div class="spacer"></div>
<div class="spacer"></div>