<?php
require('../../fpdf.php');
include "../../root.class.php";

$db = new db_safeguard();

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('L');

$pdf->Cell(10, 10, '', 0, 1, 'L');
$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(280, 15, "QUALITY CONTROL REPORT", 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);

$pdf->Cell(35, 8, "Date & Time", 1, 0, 'L');
$pdf->Cell(20, 8, "Shift (D/N)", 1, 0, 'L');
$pdf->Cell(30, 8, "Sample Size(kg)", 1, 0, 'L');
$pdf->Cell(40, 8, "Product sample point", 1, 0, 'L');
$pdf->Cell(20, 8, "Wholes", 1, 0, 'L');
$pdf->Cell(20, 8, "Halves", 1, 0, 'L');
$pdf->Cell(20, 8, "Dust", 1, 0, 'L');
$pdf->Cell(20, 8, "Shells", 1, 1, 'L');


$res_dat = $db->query("cracking_quality_process_control", "SELECT * FROM cracking_quality_process_control WHERE record_id = {$_GET['record_id']}");
while ($checks = $res_dat->fetch_assoc()) {

    $pdf->Cell(35, 8, $checks['date_time'], 1, 0, 'L');
    $pdf->Cell(20, 8, $checks['shift'], 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['sample_size'] . " kg", 1, 0, 'L');
    $pdf->Cell(40, 8, $checks['product_sample_point'], 1, 0, 'L');
    $pdf->Cell(20, 8, $checks['wholes'] . " kg", 1, 0, 'L');
    $pdf->Cell(20, 8, $checks['halves'] . " kg", 1, 0, 'L');
    $pdf->Cell(20, 8, $checks['dust'] . " kg", 1, 0, 'L');
    $pdf->Cell(20, 8, $checks['shells'] . " kg", 1, 0, 'L');

}

$pdf->Cell(10, 20, '', 0, 1, 'L');

$pdf->Cell(30, 8, "Broken/Chipped", 1, 0, 'L');
$pdf->Cell(30, 8, "Shell in Kernal", 1, 0, 'L');
$pdf->Cell(30, 8, "Un-cracked Nuts", 1, 0, 'L');
$pdf->Cell(40, 8, "Crushed/ Missing Kernal", 1, 0, 'L');
$pdf->Cell(20, 8, "Moisure %", 1, 0, 'L');
$pdf->Cell(30, 8, "Env. Temperature", 1, 0, 'L');
$pdf->Cell(30, 8, "Env. Humidity", 1, 0, 'L');
$pdf->Cell(30, 8, "Magnet inspection", 1, 1, 'L');


$res_dat = $db->query("cracking_quality_process_control", "SELECT * FROM cracking_quality_process_control WHERE record_id = {$_GET['record_id']}");
while ($checks = $res_dat->fetch_assoc()) {

    $user_res = $db->query("users", "SELECT * FROM users WHERE record_id = {$checks['person_inspection']}");
    $user = $user_res->fetch_assoc();

    $pdf->Cell(30, 8, $checks['broken_chipped'] . " kg", 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['shell_in_kernal'] . " kg", 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['uncracked_missing_kernal'] . " kg", 1, 0, 'L');
    $pdf->Cell(40, 8, $checks['shell_in_kernal'] . " kg", 1, 0, 'L');
    $pdf->Cell(20, 8, $checks['moisture'] . " %", 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['env_temperature'] . " kg", 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['env_humidity'] . " kg", 1, 0, 'L');
    $pdf->Cell(30, 8, $checks['magnet_inspection'], 1, 0, 'L');

    $pdf->Cell(10, 20, '', 0, 1, 'L');

    $pdf->Cell(50, 10, "Person Inspecting : ", 0, 0, 'L');
    $pdf->Cell(40, 10, $user['username'], 0, 1, 'L');

    $pdf->Image("../cracking/" . $checks['cracking_signature'], 50, 110, 30);
    $pdf->Cell(30, 15, "Signature : ", 0, 1, 'L');

}

$pdf->Output("I");
