<?php
include "../root.class.php";
$firstOfMonth = date('Y-m-d');
$lastOfMonth = date('Y-m-d');


$dash = new Dashboard();
$db = new db_safeguard();
$call = new call_functions();
$open_order_res = $db->query("orders", "SELECT * FROM orders WHERE `status` = 0");
$open_orders = $open_order_res->num_rows;
$closed_order_res = $db->query("orders", "SELECT * FROM orders WHERE `status` = 1");
$closed_orders = $closed_order_res->num_rows;

$received_stock = $db->query("order_trans", "SELECT SUM(amount) as total FROM order_trans WHERE date_time BETWEEN '$firstOfMonth 00:00' AND '$$lastOfMonth 23:59' AND amount > 0");
$received_today = $received_stock->fetch_assoc()['total'];

$dispatched_stock = $db->query("order_trans", "SELECT SUM(amount) as total FROM order_trans WHERE date_time BETWEEN '$firstOfMonth 00:00' AND '$$lastOfMonth 23:59' AND amount < 0");
$dispatched_today = $dispatched_stock->fetch_assoc()['total'];

?>
<style>
    body {
        font-size: 6em;
        background-color: #ffffffa3;
        text-align: center;
        padding: 5vw;
        color: black;
        margin-top: 15vw;
        display: flex;
        font-weight: 900;
        flex-direction: column;
        align-content: center;
        align-items: center;
    }
</style>
<!-- WELCOME -->
<div style="display: flex
;
    margin-bottom: 5vh;
    margin-top:-5vh;
    flex-wrap: wrap;
    flex-direction: row;
    align-items: center;
    justify-content: center;">
    <?php

    echo DashboardWidget::includeAssets();
    if ($_SESSION['user_type'] == "MANAGEMENT") {

        $job_card_tech_res = $db->query("job_cards_tech", "SELECT * FROM job_cards_tech WHERE 1 ORDER BY record_id DESC LIMIT 30");
        $table_data = [];

        while ($job_card_tech = $job_card_tech_res->fetch_assoc()) {


            $table_data[] = [
                $job_card_tech['jc_number'],
                $job_card_tech['date_time_created'],
                $job_card_tech['company_name'],
                $call->get_job_card_status($job_card_tech['status']),
                $call->get_username($job_card_tech['user_to_do']),
                'jobcards/edit_tech_jobcard.php?record_id=' . $job_card_tech['record_id']


            ];
        }

        echo DashboardWidget::tableBlock('LATEST TECH JOB CARDS', ['Number', 'Date', 'Company', "Status", ' Tech'], $table_data, '90vw');
    }
    if ($_SESSION['user_type'] == "PROCUREMENT") {


        $order_trans_table = $db->query("order_trans", "SELECT * FROM order_trans WHERE 1 ORDER BY record_id DESC LIMIT 10");
        $table_data = [];

        while ($order_trans = $order_trans_table->fetch_assoc()) {
            $username = $call->get_username($order_trans['user_id']);

            // get PO_NUMBER
            if ($order_trans['order_id'] == 0) {
                $po_number = '';
            } else {
                $po_res = $db->query("orders", "SELECT * FROM orders WHERE record_id = $order_trans[order_id]");
                $po = $po_res->fetch_assoc();
                $po_number = $po['po_number'];
            }
            $table_data[] = [
                $call->get_stock_name($order_trans['stock_id']),
                $order_trans['amount'],
                $username ? $username : 'SYSTEM',
                $order_trans['job_card_no'],
                $po_number,
                ''

            ];
        }

        echo DashboardWidget::tableBlock('LATEST WAREHOUSE TRANSACTIONS', ['ITEM', 'AMOUNT', 'USER', "JOB CARD", "ORDER NUMBER"], $table_data, '90vw');



        $order_table = $db->query("orders", "SELECT * FROM orders WHERE 1 ORDER BY record_id DESC LIMIT 10");
        $table_data = [];

        $status = "";
        if ($orders['status'] == 0) {
            $status = "OPEN";
        } else if ($orders['status'] == 1) {
            $status = "CLOSED";
        }
        while ($orders = $order_table->fetch_assoc()) {
            $table_data[] = [
                $orders['po_number'],
                $orders['jc_number'],
                $orders['date_time_created'],
                $status,
                $call->get_username($orders['user_created']),
                'orders/edit_order.php?record_id=' . $orders['record_id']

            ];
        }
        echo DashboardWidget::tableBlock('LATEST PURCHASE ORDERS', ['PO', 'JOB CARD NO', 'DATE', 'STATUS', 'USER'], $table_data, '90vw');



    }
    if ($_SESSION['user_type'] == "TECHNICIANS") {


        $job_card_tech_res = $db->query("job_cards_tech", "SELECT * FROM job_cards_tech WHERE user_to_do = " . $_SESSION['user_id'] . " ORDER BY record_id DESC LIMIT 10");
        $table_data = [];

        while ($job_card_tech = $job_card_tech_res->fetch_assoc()) {


            $table_data[] = [
                $job_card_tech['jc_number'],
                $job_card_tech['date_time_created'],
                $job_card_tech['company_name'],
                $call->get_job_card_status($job_card_tech['status']),
                'jobcards/edit_tech_jc.php?record_id=' . $job_card_tech['record_id']


            ];
        }

        echo DashboardWidget::tableBlock('LATEST JOB CARDS', ['Number', 'Date', 'Company', "Status"], $table_data, '90vw');

    }
    if ($_SESSION['user_type'] == "WAREHOUSE") {


        $order_trans_table = $db->query("order_trans", "SELECT * FROM order_trans WHERE 1 ORDER BY record_id DESC LIMIT 200");
        $table_data = [];

        while ($order_trans = $order_trans_table->fetch_assoc()) {
            $username = $call->get_username($order_trans['user_id']);

            // get PO_NUMBER
            if ($order_trans['order_id'] == 0) {
                $po_number = '';
            } else {
                $po_res = $db->query("orders", "SELECT * FROM orders WHERE record_id = $order_trans[order_id]");
                $po = $po_res->fetch_assoc();
                $po_number = $po['po_number'];
            }
            $table_data[] = [
                $call->get_stock_name($order_trans['stock_id']),
                $order_trans['amount'],
                $username ? $username : 'SYSTEM',
                $order_trans['job_card_no'],
                $po_number,
                ''

            ];
        }

        echo DashboardWidget::tableBlock('LATEST WAREHOUSE TRANSACTIONS', ['ITEM', 'AMOUNT', 'USER', "JOB CARD", "ORDER NUMBER"], $table_data, '90vw');


    }
    if ($_SESSION['user_type'] == "MANAGEMENT") {
    }


    // echo DashboardWidget::columnGraph('TOTAL FOR 7 DAYS FOR ALL TANKS', $data_array, '90vw');
    

    // echo DashboardWidget::lineGraph(
    //     'PRODUCTION OVER TIME',
    //     $lastSixMonths_names,
    //     $amounts_arr,
    //     'Liters'
    // );
    
    ?>
</div>