<?php
session_start();
$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['html'])) {
    http_response_code(400);
    echo 'No HTML provided.';
    exit;
}

$html = $data['html'];

// Create a timestamped filename
$timestamp = date('Y-m-d_H-i-s');
$filename = __DIR__ . "/logs/Save-Dispatch-$timestamp" . "_{$_SESSION['user_id']}.html";

// Ensure logs folder exists
if (!file_exists(__DIR__ . '/logs')) {
    mkdir(__DIR__ . '/logs', 0777, true);
}

// Save HTML to file
file_put_contents($filename, $html);

echo 'Saved successfully.';