<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Signature Capture</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <style>
        table {
            border-collapse: collapse;
            width: 50%;
        }

        th,
        td {
            padding: 10px;
            text-align: left;
        }

        button {
            background-color: #4CAF50;
            /* Green */
            border: none;
            color: white;
            padding: 12px 20px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 16px;
            margin: 4px 2px;
            cursor: pointer;
        }

        #signatureContainer {
            display: none;
        }
    </style>
</head>

<body>
    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
    <div id="signatureContainer"></div>
    <script>
        $(document).ready(function () {
            console.log("ready");
            // Example Array - Replace this with your real data
            var names = [
                "John Doe",
                "Jane Smith",
                "Peter Jones",
                //...more names here
            ];
            populateTable(names);

            function populateTable(data) {
                console.log("populate table");
                console.log(data);
                const tbody = document.querySelector("#signatureTable tbody");
                data.forEach((name) => {

                    let newRow = $('<tr>').append($('<td>').text(name)).appendTo(tbody);
                    console.log(name);

                    let btnElement = $('<button></button>');
                    btnElement.attr('id', 'signButton' + name);
                    btnElement.click(function () {
                        loadSignature(this);
                    });
                    newRow.prepend(btnElement);
                });
            }

        });
    </script>
</body>

</html>