<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();
// $html->check_user_type("ADMIN");

//get the time from a date time formate
function get_time($date_time)
{
    return date("h:i A", strtotime($date_time));
}

$total_rieming_meters = 0;
$total_drilling_meters = 0;
$total_casting_meters = 0;


//get all the meters where type contains rieming stop
$riem_res = $db->query("jobcard_timeline", "SELECT * FROM jobcard_timeline WHERE type LIKE '%RIEM_STOP%'");

if ($riem_res->num_rows > 0) {
    while ($riem = $riem_res->fetch_assoc()) {
        $total_rieming_meters += $riem['meters'];

        // $riem_start[] = $get_time[$riem['time']];
        // return $riem_start;
    }
}

$drilling_res = $db->query("jobcard_timeline", "SELECT * FROM jobcard_timeline WHERE type LIKE '%DRILLING_STOP%'");

if ($drilling_res->num_rows > 0) {
    while ($drilling = $drilling_res->fetch_assoc()) {
        $total_drilling_meters += $drilling['meters'];
    }
}

$casting_res = $db->query("jobcard_timeline", "SELECT * FROM jobcard_timeline WHERE type LIKE '%CASTING_STOP%'");

if ($casting_res->num_rows > 0) {
    while ($casting = $casting_res->fetch_assoc()) {
        $total_casting_meters += $casting['meters'];
    }
}

// get all the rieming time
$riem_time_res = $db->query("jobcard_timeline", "SELECT * FROM jobcard_timeline WHERE type LIKE '%RIEM_STOP%'");

if ($riem_time_res->num_rows > 0) {
    while ($riem = $riem_time_res->fetch_assoc()) {
        $riem_time += get_time($riem['time']);
    }
}

$drilling_time_res = $db->query("jobcard_timeline", "SELECT * FROM jobcard_timeline WHERE type LIKE '%DRILLING_STOP%'");

if ($drilling_time_res->num_rows > 0) {
    while ($drilling = $drilling_time_res->fetch_assoc()) {
        $drill_time += get_time($drilling['time']);
    }
}

$casing_time_res = $db->query("jobcard_timeline", "SELECT * FROM jobcard_timeline WHERE type LIKE '%CASTING_STOP%'");

if ($casing_time_res->num_rows > 0) {
    while ($casing = $casing_time_res->fetch_assoc()) {
        $cas_time += get_time($casing['time']);
    }
}

$rieming_time = 0;
$drilling_time = 0;
$casing_time = 0;

$rieming_time = $riem_time;
$drilling_time = $drill_time;
$casing_time = $cas_time;

//get the number of assets
$asset_res = $db->query("assets", "SELECT * FROM assets");

if ($asset_res->num_rows > 0) {
    $total_assets = $asset_res->num_rows;
}

//get the number of clients
$client_res = $db->query("clients", "SELECT * FROM clients");

if ($client_res->num_rows > 0) {
    $total_clients = $client_res->num_rows;
}

//get the number of teams
$team_res = $db->query("teams", "SELECT * FROM teams");

if ($team_res->num_rows > 0) {
    $total_teams = $team_res->num_rows;
}

//get the number of jobcards
$jobcard_res = $db->query("jobcards", "SELECT * FROM jobcards");

if ($jobcard_res->num_rows > 0) {
    $total_jobcards = $jobcard_res->num_rows;
}

// active jocards
$active_jobcard_res = $db->query("jobcards", "SELECT * FROM jobcards WHERE status = '0'");

if ($active_jobcard_res->num_rows > 0) {
    $active_jobcards = $active_jobcard_res->num_rows;
}

// completed jobcards
$completed_jobcard_res = $db->query("jobcards", "SELECT * FROM jobcards WHERE status = '1'");

if ($completed_jobcard_res->num_rows > 0) {
    $completed_jobcards = $completed_jobcard_res->num_rows;
}


//total compressor hours
$compressor_res = $db->query("jobcards", "SELECT compressor_hours FROM jobcards");

if ($compressor_res->num_rows > 0) {
    while ($compressor = $compressor_res->fetch_assoc()) {
        $total_compressor_hours += $compressor['compressor_hours'];
    }
}


$riem_meters_label = new label();
$riem_meters_label->for("riem_meters");
$riem_meters_label->value("Total Rieming Meters");

$riem_meters = new input();
$riem_meters->class("inputs");
$riem_meters->type("number");
$riem_meters->name("riem_meters");
$riem_meters->placeholder("Rieming Meters");
$riem_meters->value($total_rieming_meters);

$drilling_meters_label = new label();
$drilling_meters_label->for("drilling_meters");
$drilling_meters_label->value("Total Drilling Meters");

$drilling_meters = new input();
$drilling_meters->class("inputs");
$drilling_meters->type("number");
$drilling_meters->name("drilling_meters");
$drilling_meters->placeholder("Drilling Meters");
$drilling_meters->value($total_drilling_meters);

$casting_meters_label = new label();
$casting_meters_label->for("casting_meters");
$casting_meters_label->value("Total Casting Meters");

$casting_meters = new input();
$casting_meters->class("inputs");
$casting_meters->type("number");
$casting_meters->name("casting_meters");
$casting_meters->placeholder("Casting Meters");
$casting_meters->value($total_casting_meters);

$total_rieming_time_label = new label();
$total_rieming_time_label->for("total_rieming_time");
$total_rieming_time_label->value("Total Rieming Time");

$total_rieming_time = new input();
$total_rieming_time->class("inputs");
$total_rieming_time->type("text");
$total_rieming_time->name("total_rieming_time");
$total_rieming_time->placeholder("Total Rieming Time");
$total_rieming_time->value($rieming_time);

$total_drilling_time_label = new label();
$total_drilling_time_label->for("total_drilling_time");
$total_drilling_time_label->value("Total Drilling Time");

$total_drilling_time = new input();
$total_drilling_time->class("inputs");
$total_drilling_time->type("text");
$total_drilling_time->name("total_drilling_time");
$total_drilling_time->placeholder("Total Drilling Time");
$total_drilling_time->value($drilling_time);

$total_casing_time_label = new label();
$total_casing_time_label->for("total_casing_time");
$total_casing_time_label->value("Total Casing Time");

$total_casing_time = new input();
$total_casing_time->class("inputs");
$total_casing_time->type("text");
$total_casing_time->name("total_casing_time");
$total_casing_time->placeholder("Total Casing Time");
$total_casing_time->value($casing_time);

$total_assets_label = new label();
$total_assets_label->for("total_assets");
$total_assets_label->value("Total Assets");

$total_num_assets = new input();
$total_num_assets->class("inputs");
$total_num_assets->type("number");
$total_num_assets->name("total_assets");
$total_num_assets->placeholder("Total Assets");
$total_num_assets->value($total_assets);

$total_clients_label = new label();
$total_clients_label->for("total_clients");
$total_clients_label->value("Total Clients");

$total_num_clients = new input();
$total_num_clients->class("inputs");
$total_num_clients->type("number");
$total_num_clients->name("total_clients");
$total_num_clients->placeholder("Total Clients");
$total_num_clients->value($total_clients);

$total_teams_label = new label();
$total_teams_label->for("total_teams");
$total_teams_label->value("Total Teams");

$total_num_teams = new input();
$total_num_teams->class("inputs");
$total_num_teams->type("number");
$total_num_teams->name("total_teams");
$total_num_teams->placeholder("Total Teams");
$total_num_teams->value($total_teams);

$total_num_jobcards = new input();
$total_num_jobcards->class("inputs");
$total_num_jobcards->type("number");
$total_num_jobcards->name("total_jobcards");
$total_num_jobcards->placeholder("Total Jobcards");
$total_num_jobcards->value($total_jobcards);

$total_jobcard_label = new label();
$total_jobcard_label->for("total_jobcards");
$total_jobcard_label->value("Total Jobcards");

$total_compressor_label = new label();
$total_compressor_label->for("total_compressors_hours");
$total_compressor_label->value("Total Compressors Hours");

$total_num_compressors = new input();
$total_num_compressors->class("inputs");
$total_num_compressors->type("number");
$total_num_compressors->name("total_compressors");
$total_num_compressors->placeholder("Total Compressors");
$total_num_compressors->value($total_compressor_hours);

$active_jobcards_label = new label();
$active_jobcards_label->for("active_jobcards");
$active_jobcards_label->value("Active Jobcards");

$active_num_jobcards = new input();
$active_num_jobcards->class("inputs");
$active_num_jobcards->type("number");
$active_num_jobcards->name("active_jobcards");
$active_num_jobcards->placeholder("Active Jobcards");
$active_num_jobcards->value($active_jobcards);

$completed_jobcards_label = new label();
$completed_jobcards_label->for("completed_jobcards");
$completed_jobcards_label->value("Completed Jobcards");

$completed_num_jobcards = new input();
$completed_num_jobcards->class("inputs");
$completed_num_jobcards->type("number");
$completed_num_jobcards->name("completed_jobcards");
$completed_num_jobcards->placeholder("Completed Jobcards");
$completed_num_jobcards->value($completed_jobcards);

$total_report_btn = new button();
$total_report_btn->value("TOTAL METERS REPORT");
$total_report_btn->onclick("generate_meters_report()");

$total_time_report_btn = new button();
$total_time_report_btn->value("TOTAL TIME REPORT");
$total_time_report_btn->onclick("generate_time_report()");

$assets_report_btn = new button();
$assets_report_btn->value("ASSETS REPORT");
$assets_report_btn->onclick("generate_assets_report()");

$client_report_btn = new button();
$client_report_btn->value("CLIENT REPORT");
$client_report_btn->onclick("generate_client_report()");

$teams_report_btn = new button();
$teams_report_btn->value("TEAMS REPORT");
$teams_report_btn->onclick("generate_teams_report()");

$total_jocard_report_btn = new button();
$total_jocard_report_btn->value("TOTAL JOBCARD REPORT");
$total_jocard_report_btn->onclick("generate_jobcard_report()");

?>

<div class="column">
    <h1 style="color: white;">REPORTS</h1>

    <div
        style="display: flex; background: #e5e5e5;margin: 1vw;border-radius: 2vw; padding: 2vw; border: 2px solid black; width: 90%; justify-content: space-around;">
        <div class="group_div">
            <?php
            $total_jobcard_label->add();
            $total_num_jobcards->add();
            ?>
        </div>
        <!-- <div class="group_div">
            <php
            $total_compressor_label->add();
            $total_num_compressors->add();
            ?>
        </div> -->
        <div class="group_div">
            <?php
            $active_jobcards_label->add();
            $active_num_jobcards->add();
            ?>
        </div>
        <div class="group_div">
            <?php
            $completed_jobcards_label->add();
            $completed_num_jobcards->add();
            ?>
        </div>
        <div class="group_div" style="justify-content: center;">
            <?php
            $total_jocard_report_btn->add();
            ?>
        </div>
    </div>

    <div
        style="display: flex; background: #e5e5e5;margin: 1vw;border-radius: 2vw; padding: 2vw; border: 2px solid black; width: 90%; justify-content: space-around;">
        <div class="group_div">
            <?php
            $riem_meters_label->add();
            $riem_meters->add();
            ?>
        </div>
        <div class="group_div">
            <?php
            $drilling_meters_label->add();
            $drilling_meters->add();
            ?>
        </div>
        <div class="group_div">
            <?php
            $casting_meters_label->add();
            $casting_meters->add();
            ?>
        </div>
        <div class="group_div" style="justify-content: center;">
            <?php
            $total_report_btn->add();
            ?>
        </div>
    </div>

    <!-- <div
        style="display: flex; background: #e5e5e5;margin: 1vw;border-radius: 2vw; padding: 2vw; border: 2px solid black; width: 90%; justify-content: space-around;">
        <div class="group_div">
            <?php
            $total_rieming_time_label->add();
            $total_rieming_time->add();
            ?>
        </div>
        <div class="group_div">
            <?php
            $total_drilling_time_label->add();
            $total_drilling_time->add();
            ?>
        </div>
        <div class="group_div">
            <?php
            $total_casing_time_label->add();
            $total_casing_time->add();
            ?>
        </div>
        <div class="group_div" style="justify-content: center;">
            <?php
            $total_time_report_btn->add();
            ?>
        </div>
    </div> -->

    <!-- <div
        style="display: flex; background: #e5e5e5;margin: 1vw;border-radius: 2vw; padding: 2vw; border: 2px solid black; width: 90%; justify-content: space-around;">
        <div class="group_div">
            <?php
            $total_assets_label->add();
            $total_num_assets->add();
            ?>
        </div>
        <div class="group_div">
            <?php

            ?>
        </div>
        <div class="group_div">
            <?php

            ?>
        </div>
        <div class="group_div" style="justify-content: center;">
            <?php
            $assets_report_btn->add();
            ?>
        </div>
    </div>

    <div
        style="display: flex; background: #e5e5e5;margin: 1vw;border-radius: 2vw; padding: 2vw; border: 2px solid black; width: 90%; justify-content: space-around;">
        <div class="group_div">
            <?php
            $total_clients_label->add();
            $total_num_clients->add();
            ?>
        </div>
        <div class="group_div">
            <?php

            ?>
        </div>
        <div class="group_div">
            <?php

            ?>
        </div>
        <div class="group_div" style="justify-content: center;">
            <?php
            $client_report_btn->add();
            ?>
        </div>
    </div>

    <div
        style="display: flex; background: #e5e5e5;margin: 1vw;border-radius: 2vw; padding: 2vw; border: 2px solid black; width: 90%; justify-content: space-around;">
        <div class="group_div">
            <?php
            $total_teams_label->add();
            $total_num_teams->add();
            ?>
        </div>
        <div class="group_div">
            <?php

            ?>
        </div>
        <div class="group_div">
            <?php

            ?>
        </div>
        <div class="group_div" style="justify-content: center;">
            <?php
            $teams_report_btn->add();
            ?>
        </div>
    </div> -->

</div>

<?php

$jocard_report_ajax = new js_ajax();
$jocard_report_ajax->function_name("generate_jobcard_report");
$jocard_report_ajax->redirect("total_jobcards.pdf.php");

$ajax = new js_ajax();
$ajax->function_name("generate_meters_report");
$ajax->redirect("meters_report.pdf.php");

$time_ajax = new js_ajax();
$time_ajax->function_name("generate_time_report");
$time_ajax->redirect("time_report.pdf.php");

$assets_report_ajax = new js_ajax();
$assets_report_ajax->function_name("generate_assets_report");
$assets_report_ajax->redirect("assets_report.pdf.php");

$client_report_ajax = new js_ajax();
$client_report_ajax->function_name("generate_client_report");
$client_report_ajax->redirect("client_report.pdf.php");

$teams_report_ajax = new js_ajax();
$teams_report_ajax->function_name("generate_teams_report");
$teams_report_ajax->redirect("teams_report.pdf.php");