<?php
require('../../fpdf.php');
include "../../root.class.php";
// $html = new html();


$db = new db_safeguard();
$assets_res = $db->query("assets", "SELECT * FROM assets");
$assets = $assets_res->fetch_assoc();

function get_asset_type($asset_type_id)
{
    $db = new db_safeguard();
    $res = $db->query("asset_type", "SELECT `name` FROM asset_type WHERE record_id = $asset_type_id");
    return $res->fetch_assoc()['name'];
}

function get_team($team_id)
{
    $db = new db_safeguard();
    $res = $db->query("teams", "SELECT `name` FROM teams WHERE record_id = $team_id");
    return $res->fetch_assoc()['name'];
}

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('L');

$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(200, 15, "All ASSETS ", 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);

$pdf->Cell(10, 8, "", 1, 0, 'L');
$pdf->Cell(30, 8, "Name", 1, 0, 'L');
$pdf->Cell(50, 8, "Asset Type", 1, 0, 'L');
// $pdf->Cell(50, 8, "Asset Image", 1, 0, 'L');
$pdf->Cell(15, 8, "Team", 1, 0, 'L');
$pdf->Cell(30, 8, "Diesel Level", 1, 0, 'L');
$pdf->Cell(30, 8, "Odo Type", 1, 0, 'L');
$pdf->Cell(30, 8, "Odo", 1, 0, 'L');
$pdf->Cell(20, 8, "Status", 1, 1, 'L');


if ($assets_res->num_rows == 0) {
    echo "NO ASSETS FOUND";
} else {
    while ($assets = $assets_res->fetch_assoc()) {

        $pdf->Cell(10, 8, $assets['record_id'], "LBR", 0, 'L');
        $pdf->Cell(30, 8, $assets['name'], "LBR", 0, 'L');
        $pdf->Cell(50, 8, get_asset_type($assets['asset_type_id']), "LBR", 0, 'L');
        // $pdf->Cell(50, 8, $assets['asset_image'], "", 0, 'L');
        $pdf->Cell(15, 8, get_team($assets['team_id']), "LBR", 0, 'L');
        $pdf->Cell(30, 8, $assets['diesel_level'], "LBR", 0, 'L');
        $pdf->Cell(30, 8, $assets['odo_type'], "LBR", 0, 'L');
        $pdf->Cell(30, 8, $assets['odo'], "LBR", 0, 'L');
        $pdf->Cell(20, 8, $assets['status'], "LBR", 1, 'L');
    }
}


$pdf->Cell(10, 5, '', 0, 1, 'L');

// $pdf->AddPage('p');

// $pdf->SetFont('Arial', 'B', 20);
// $pdf->Cell(200, 15, "NOTES", 0, 1, 'C');
// $pdf->Cell(10, 5, '', 0, 1, 'L');
// $pdf->SetFont('Arial', '', 10);

// $pdf->Cell(45, 8, "DESCRIPTION", 1, 0, 'L');
// $pdf->Cell(55, 8, "NOTES", 1, 0, 'L');
// $pdf->Cell(35, 8, "DATE TIME", 1, 0, 'L');
// $pdf->Cell(60, 8, "IMAGE", 1, 1, 'L');

// $notes_res = $db->query("notes", "SELECT * FROM notes WHERE jobcard_id = {$_GET['record_id']} ORDER BY record_id ASC");
// if ($notes_res->num_rows == 0) {
//     $error = 1;
// } else {
//     while ($notes = $notes_res->fetch_assoc()) {
//         $pdf->Cell(45, 8, $notes['reason'], "LB", 0, 'L');
//         $pdf->Cell(55, 8, $notes['note'], "LBR", 0, 'L');
//         $pdf->Cell(35, 8, $notes['date_time'], "LBR", 0, 'L');
//         $pdf->Cell(60, 8, $notes['image'], "LBR", 1, 'L');
//     }
// }

$pdf->Output("I");