<?php

include "../../classes/autoload.php";

$html = new html("");

$app = new inner_app();
$app->quick_bar('/app/payments');
$app->app_start();

echo "<datalist id='invoice_list'>";
echo $function->get_unpaid_invoices_list();
echo "</datalist>";
?>

<div class="column width_80 background_1 border_radius">
    <h1>NEW PAYMENT</h1>
    <div class="row width_80">
        <div class="column width_50">
            <label>Payment Type</label>
            <select name="pyament_type">
                <option></option>
                <option>CASH</option>
                <option>EFT</option>
                <option>CARD</option>
            </select>
            <label>Invoice</label>
            <input name='invoice_number' id="invoice_number" onchange="get_invoice_id(this.value)" list="invoice_list">
            <input name='invoice_id' id="invoice_id" hidden>
            <label>Date</label>
            <input type="date" class="width_80" id='date' name='date' />
            <label id="amount_label">Amount</label>
            <input type="text" class="width_80" id='amount' name='amount' />
        </div>
        <div id="invoice_payments">

        </div>
    </div>
    <br>
    <button class="width_90" id='submit' onclick="save('save_payments.php')">SAVE</button>
    <br>

</div>


<script>

    function get_invoice_id(invoice_no) {
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                if (this.responseText == '0' || this.responseText == 0) {
                    alert("invoice selected incorrect");
                    document.getElementById("invoice_id").value = '';
                    document.getElementById("invoice_number").value = '';

                } else {
                    document.getElementById("invoice_id").value = this.responseText;
                    ajax_history(this.responseText);
                }
            }
        }
        xhttp.open("GET", "invoice_no.ajax.php?invoice_number=" + invoice_no, true);
        xhttp.send();
    }

    function ajax_history(invoice_id) {
        document.getElementById('submit').hidden = false;
        document.getElementById('amount').hidden = false;
        document.getElementById('amount_label').hidden = false;
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                document.getElementById("invoice_payments").innerHTML = this.responseText;
                if (document.getElementById('nett').innerHTML == 'R 0.00') {
                    alert("Invoice payed in full");
                    document.getElementById('submit').hidden = true;
                    document.getElementById('amount').hidden = true;
                    document.getElementById('amount_label').hidden = true;
                }
            }
        }
        xhttp.open("GET", "invoice_ajax.php?invoice_id=" + invoice_id, true);
        xhttp.send();
    }

    function save(url) {
        var elements = document.getElementsByTagName('input');
        var payload = {};
        for (var i = 0; i < elements.length; i++) {
            var element = elements[i];
            if (element.type === 'text' || element.type === 'date' || element.type === 'email') {
                payload[element.name] = element.value;
            }
        }

        var elements = document.getElementsByTagName('select');
        for (var i = 0; i < elements.length; i++) {
            var element = elements[i];

            payload[element.name] = element.value;

        }

        var form = document.createElement('form');
        form.method = 'POST';
        form.action = url;

        for (var key in payload) {
            if (payload.hasOwnProperty(key)) {
                var input = document.createElement('input');
                input.type = 'hidden';
                input.name = key;
                input.value = payload[key];

                form.appendChild(input);
            }
        }

        document.body.appendChild(form);
        form.submit();
    }
</script>