<?php
include "../../classes/autoload.php";

$html = new html("JOB CARDS");

$app = new inner_app();
$app->quick_bar();
$app->app_start();

function get_all_column_names($table_name)
{
    $db = new db();
    $result = $db->query($table_name, "SHOW COLUMNS FROM " . $table_name);
    $options = "";
    $options .= "<option value=''>NONE</option>";
    while ($columns = $result->fetch_assoc()) {
        $options .= "<option value='" . $columns['Field'] . "'>" . $columns['Field'] . "</option>";
    }
    return $options;
}

function get_tables()
{
    $db = new db();
    $result = $db->query("", "SHOW TABLES");
    $options = "";
    $options .= "<option value=''>NONE</option>";
    while ($columns = $result->fetch_array()) {
        $table_name = $columns[0];
        if ($table_name == 'logs' || $table_name == $_GET['table_name'] || $table_name == 'user_table_views' || $table_name == 'default_links')
            continue;
        $options .= "<option value='" . $table_name . "'>" . strtoupper(str_replace("_", " ", $table_name)) . "</option>";
    }
    return $options;
}
?>

<script>
    function get_all_column_names_from_ajax(table_name, input_to_add_id, $value_to_be = '') {
        var xmlhttp = new XMLHttpRequest();
        xmlhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                document.getElementById(input_to_add_id).innerHTML = this.responseText;

                if ($value_to_be != '') {
                    document.getElementById(input_to_add_id).value = $value_to_be;
                }
            }
        };
        xmlhttp.open("GET", "../../classes/get_column_names.php?table_name=" + table_name, true);
        xmlhttp.send();
    }
</script>
<form action="update_default_links.php" method="post">
    <div class="column width_80 padding background_1 border_radius">
        <div class="column width_100">
            <h1>EDIT A DEFAULT LINK</h1>
            <div class="column width_100">
                <label>PARENT TABLE</label>
                <select name="parent_table_name" id="parent_table_name"
                    onchange="get_all_column_names_from_ajax(this.value,'parent_table_column');get_all_column_names_from_ajax(this.value,'send_column');"><?php echo get_tables(); ?></select>
                <label>COLUMN NAME</label>
                <select name="parent_table_column" id="parent_table_column"></select>
                <label>LINK TABLE</label>
                <select name="child_table_name" id="child_table_name"
                    onchange="get_all_column_names_from_ajax(this.value,'pull_column_name')"><?php echo get_tables(); ?></select>
                <label>FUNCTION</label>
                <select name="function" id="function" class='width_20'>
                    <option value=''>NONE</option>
                    <option value='SUM'>SUM</option>
                    <option value='COUNT'>COUNT</option>
                    <option value='AVG'>AVG</option>
                    <option value='MAX'>MAX</option>
                    <option value='MIN'>MIN</option>
                </select>
                <label>RETURN COLUMN</label>
                <select name="pull_column_name" id="pull_column_name"></select>
                <label>DISPLAY METHOD</label>
                <select name="display_method" id="display_method" class='width_20'>
                    <option>TEXT</option>
                    <option>ICON</option>
                    <option>BUTTON</option>
                    <option>PROGRESS BAR</option>
                </select>
                <label>ICON</label>
                <select name="icon" id="icon" class='width_20'>
                    <option value="">NONE</option>
                    <option value="fa fa-home">Home</option>
                    <option value="fa fa-user">User</option>
                    <option value="fa fa-envelope">Envelope</option>
                    <option value="fa fa-cog">Settings</option>
                    <option value="fa fa-star">Star</option>
                    <option value="fa fa-heart">Heart</option>
                    <option value="fa fa-search">Search</option>
                    <option value="fa fa-shopping-cart">Cart</option>
                    <option value="fa fa-bell">Notifications</option>
                    <option value="fa fa-lock">Lock</option>
                    <option value="fa fa-paperclip">Paperclip</option>
                    <option value="fa fa-file">File</option>
                    <option value="fa fa-file-lines">Document</option>
                    <option value="fa fa-file-word">Word File</option>
                    <option value="fa fa-file-excel">Excel File</option>
                    <option value="fa fa-file-pdf">PDF File</option>
                    <option value="fa fa-folder">Folder</option>
                    <option value="fa fa-folder-open">Open Folder</option>
                    <option value="fa fa-envelope">Envelope</option>
                    <option value="fa fa-envelope-open">Open Envelope</option>
                    <option value="fa fa-pen">Pen</option>
                    <option value="fa fa-pencil">Pencil</option>
                    <option value="fa fa-pen-to-square">Edit</option>
                    <option value="fa fa-print">Printer</option>
                    <option value="fa fa-sticky-note">Sticky Note</option>
                    <option value="fa fa-briefcase">Briefcase</option>
                    <option value="fa fa-calendar">Calendar</option>
                    <option value="fa fa-calendar-check">Checked Calendar</option>
                    <option value="fa fa-clipboard">Clipboard</option>
                    <option value="fa fa-clipboard-list">Clipboard List</option>
                    <option value="fa fa-folder-plus">Add Folder</option>
                    <option value="fa fa-folder-minus">Remove Folder</option>
                    <option value="fa fa-paper-plane">Send</option>
                </select>
                <label>ONCLICK</label>
                <select name="onclick" id="onclick" class='width_20'>
                    <option>NONE</option>
                    <option>POPUP</option>
                    <option>REDIRECT</option>
                </select>
                <label>OPEN</label>
                <?php
                $rootPath = $_SERVER["DOCUMENT_ROOT"];

                // Define folders to exclude here
                $excludedFolders = [
                    'styles',
                    '.ico',
                    'classes',
                    '.class',
                    'assets',
                    'user_types',
                    'admin_home',
                    'favicon',
                    'excluded_files',
                    'signatures',
                    'attachments',
                    'cgi-bin',
                    'default_links' // Add any other folder you want to exclude
                ];

                ?>

                <select name="onclick_file" id="onclick_file" class="width_20">
                    <option value="">NONE</option>
                    <?php
                    $directoryIterator = new RecursiveIteratorIterator(
                        new RecursiveDirectoryIterator($rootPath, RecursiveDirectoryIterator::SKIP_DOTS),
                        RecursiveIteratorIterator::SELF_FIRST
                    );

                    foreach ($directoryIterator as $file) {
                        // Check if the current file or folder is in the excluded list
                        $pathSegments = explode(DIRECTORY_SEPARATOR, $file->getPathname());
                        $isExcluded = false;
                        foreach ($pathSegments as $segment) {
                            if (in_array($segment, $excludedFolders) || strpos($segment, '.') === 0) {
                                $isExcluded = true;
                                break;
                            }
                        }
                        if ($isExcluded) {
                            continue;
                        }

                        $relativePath = str_replace($rootPath, '', $file->getPathname());
                        $label = strtoupper(str_replace(['_', '-'], ' ', basename($file->getFilename(), '.php')));

                        if ($file->isDir()) {
                            echo "<optgroup label='" . htmlspecialchars(trim($relativePath, DIRECTORY_SEPARATOR)) . "'>";
                        } elseif ($file->isFile()) {
                            echo "<option value='" . htmlspecialchars($relativePath) . "'>" . htmlspecialchars($label) . "</option>";
                        }
                    }
                    ?>
                </select>
                <label>SEND COLUMN</label>
                <select class='width_20' name='send_column' id='send_column'>
                </select>
                <label>CUSTOM HEADER</label>
                <input type="text" name="custom_header" id="custom_header" class='width_20'
                    placeholder="Custom Header">
                <label>CUSTOM TEXT</label>
                <input type="text" name="custom_text" id="custom_text" class='width_20' placeholder="Custom Text">
                <br>
                <?php
                // get all selected columns and display them
                $check_columns_saved = $db->query("default_links", "SELECT * FROM default_links WHERE record_id = {$_GET['record_id']}");
                if ($check_columns_saved->num_rows > 0) {
                    $columns = $check_columns_saved->fetch_assoc();
                    ?>
                    <script>document.getElementById('parent_table_name').value = '<?php echo $columns['parent_table_name']; ?>';</script>
                    <script>get_all_column_names_from_ajax(document.getElementById('parent_table_name').value, 'parent_table_column', '<?php echo $columns['parent_table_column']; ?>');</script>

                    <script>get_all_column_names_from_ajax(document.getElementById('parent_table_name').value, 'send_column', '<?php echo $columns['send_column']; ?>');</script>

                    <script>document.getElementById('child_table_name').value = '<?php echo $columns['child_table_name']; ?>';</script>
                    <script>get_all_column_names_from_ajax(document.getElementById('child_table_name').value, 'pull_column_name', '<?php echo $columns['pull_column_name']; ?>');</script>

                    <script>document.getElementById('display_method').value = '<?php echo $columns['display_method']; ?>';</script>
                    <script>document.getElementById('icon').value = '<?php echo $columns['icon']; ?>';</script>
                    <script>document.getElementById('function').value = '<?php echo $columns['function']; ?>';</script>
                    <script>document.getElementById('onclick').value = '<?php echo $columns['onclick']; ?>';</script>
                    <script>document.getElementById('onclick_file').value = '<?php echo $columns['onclick_file']; ?>';</script>
                    <script>document.getElementById('send_column').value = '<?php echo $columns['send_column']; ?>';</script>
                    <script>document.getElementById('custom_header').value = '<?php echo $columns['custom_header']; ?>';</script>
                    <script>document.getElementById('custom_text').value = '<?php echo $columns['custom_text']; ?>';</script>
                    <?php
                }
                ?>
                <input type="text" hidden value="<?php echo $column_count; ?>" name="column_index_count">
                <input type="text" hidden value="<?php echo $_GET['record_id']; ?>" name="record_id">

                <button class="button" type="submit">UPDATE</button>
            </div>
        </div>

        <br><br>
    </div>
</form>