<?php

include "../../classes/autoload.php";

$html = new html("");

$app = new inner_app();
$app->quick_bar("/app/invoices/");
$app->app_start();

$invoice_res = $db->query('invoices', "SELECT * FROM invoices WHERE 1 ORDER BY record_id DESC");
$invoice = $invoice_res->fetch_assoc();
$invoice_number = $invoice['invoice_number'] + 1;

$function->get_stock_datalist("stock_list");
?>

<script>
    function get_unit_of_measure(input, i) {
        let xhr = new XMLHttpRequest();
        xhr.open("POST", "get_unit_of_measure.ajax.php", true);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                console.log(xhr.responseText);
                document.getElementById("unit_of_measure_" + i).value = xhr.responseText.split(',')[0];
                document.getElementById("retail_price_" + i).value = xhr.responseText.split(',')[1];
                calculateRow(document.getElementById("retail_price_" + i), i);
            }
        };
        xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhr.send("record_id=" + input.value);
    }

    function calculateRow(input, i) {
        let qty = parseFloat(document.querySelector(`#table #unit_of_measure_${i}`).parentNode.parentNode.querySelector("[name='qty[]']").value) || 0;
        let price = parseFloat(document.getElementById("retail_price_" + i).value) || 0;
        let total = qty * price;
        document.getElementById("total_" + i).value = total.toFixed(2);
        calculateTotals();
    }

    function calculateTotals() {
        let totals = document.querySelectorAll("[id^='total_']");
        let subtotal = 0;
        totals.forEach(t => {
            subtotal += parseFloat(t.value) || 0;
        });
        let vat = subtotal * 0.15;
        let net_total = subtotal + vat;

        document.getElementById("subtotal").value = subtotal.toFixed(2);
        document.getElementById("vat").value = vat.toFixed(2);
        document.getElementById("net_total").value = net_total.toFixed(2);
    }
</script>

<div class="column width_90 background_1 border_radius">

    <h1>INVOICE NO. <?php echo $invoice_number; ?></h1>
    <div class="row column_gap_2 width_80">
        <div class="column  width_50">
            <input type="text" name="invoice_number" value="<?php echo $invoice_number; ?>" hidden>
            <?php
            $function->get_clients_datalist('clients_list');
            ?>
            <label>CLIENT</label>
            <input class="width_80" id='client_id' hidden name='client_id' />
            <input class="width_80" id='client_name' required name='client_name' autocomplete="off"
                onchange="get_client_name(this)" list="clients_list" />
            <script>
                function get_client_name(el) {
                    let selected = el.value;
                    let options = document.getElementById("clients_list").options;
                    let found = false;
                    for (let i = 0; i < options.length; i++) {
                        if (options[i].value == selected) {
                            found = true;
                            break;
                        }
                    }
                    if (found) {
                        let data = selected.split(":");
                        document.getElementById("client_id").value = data[1];
                        document.getElementById("client_name").value = data[0];
                    } else {
                        alert("Please select a client from the list");
                        document.getElementById("client_id").value = '';
                        el.value = "";
                    }
                }
            </script>
        </div>
        <div class="column  width_50">
            <label>ORDER TYPE</label>
            <select name="order_type" onchange="change_terms(this.value)" id="order_type">
                <option></option>
                <option>SUPPLY</option>
                <option>SUPPLY & INSTALL</option>
                <option>SUPPLY & DELIVERY</option>
            </select>
            <script>
                function change_terms(val) {
                    if (val == "SUPPLY" || val == "SUPPLY & DELIVERY") {

                        document.getElementById("additional_delivery_details").style.display = "block";
                    } else {

                        document.getElementById("additional_delivery_details").style.display = "none";

                    }
                }
            </script>
        </div>
    </div>
    <div class="row column_gap_2 width_80" id="additional_delivery_details">
        <div class="column  width_100">
            <label>ADDITIONAL DELIVERY DETAILS</label>
            <textarea name="additional_delivery_details" class="width_100"
                rows="2"></textarea>
        </div>
    </div>
    <div class="row column_gap_2 width_80">
        <div class="column  width_100">
            <label>AREA</label>
            <textarea name="area" class="width_100" rows="2"></textarea>
        </div>
    </div>
    <div class="row column_gap_2 width_80">
        <div class="column  width_100">
            <label>SUBJECT</label>
            <textarea name="subject" class="width_100" rows="4">PLEASE ALLOW ONE WEEK FOR DELIVERY OF STOCK AFTER DEPOSIT IS DONE
 QUOTATION, SIZES AND AMOUNTS CHECKED AND ACCEPTED BY CLIENT - INVOICED AS PER CLIENT INSTRUCTION
 ORDERS ARE PLACED AS SOON AS DEPOSIT AMOUNT DUE ON THIS INVOICE IS RECEIVED BY E DESIGNS.
 NO CHANGES AND REFUNDS DONE ON CUSTOM CUT PANELLING AFTER ORDER HAS</textarea>
        </div>
    </div>
    <br>
    <button class="width_90" onclick="add_row()">ADD NEW ROW</button>
    <br>
    <table class="width_80" id="table">
        <thead>
            <tr>
                <th>Colour & Code</th>
                <th>Description</th>
                <th>U.O.M</th>
                <th>Qty</th>
                <th>Size m</th>
                <th>Panels</th>
                <th>Amount</th>
                <th>Total</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <input class="background_1  padding_minmal border_1"
                        style="color:white; width: 8vw;font-size: 0.9em;" id="stock_code_1"
                        onchange="get_unit_of_measure(this,1)" list="stock_list">
                </td>
                <td>
                    <input class=" background_1 padding_minmal border_1"
                        style="color:white;font-size: 0.9em;width:20vw;" name="stock_id[]" id="stock_1"
                        list="stock_list" onchange="get_unit_of_measure(this,1)">
                </td>
                <td>
                    <input class="background_1  padding_minmal border_1" readonly
                        style="color:white; width: 6vw;font-size: 0.9em;" type="text" id="unit_of_measure_1"
                        name="unit_of_measure[]">
                </td>
                <td>
                    <input class="background_1 width_90 padding_minmal border_1"
                        style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0" name="qty[]"
                        oninput="calculateRow(this,1)">
                </td>
                <td>
                    <input class="background_1 width_90 padding_minmal border_1"
                        style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0"
                        name="size_m[]">
                </td>
                <td>
                    <input class="background_1 width_90 padding_minmal border_1"
                        style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0"
                        name="pannels[]">
                </td>
                <td>
                    <input class="background_1 padding_minmal border_1" style="color:white;width:7vw;font-size: 0.9em;"
                        type="text" min="0" value="0" id="retail_price_1" step="0.01" name="price[]"
                        oninput="calculateRow(this,1)">
                </td>
                <td>
                    <input class="background_1 padding_minmal border_1" style="color:white;width:9vw;font-size: 0.9em;"
                        type="text" id="total_1" readonly>
                </td>
                <td><button class="width_100" onclick="delete_row(this)">DELETE</button></td>
            </tr>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="7" style="text-align:right;color:black;">Subtotal:</td>
                <td><input class="background_1 padding border_1" style="color:white;width:9vw;font-size: 0.9em;"
                        type="text" id="subtotal" readonly></td>
                <td></td>
            </tr>
            <tr>
                <td colspan="7" style="text-align:right;color:black;">VAT (15%):</td>
                <td><input class="background_1 padding border_1" style="color:white;width:9vw;font-size: 0.9em;"
                        type="text" id="vat" readonly>
                </td>
                <td></td>
            </tr>
            <tr>
                <td colspan="7" style="text-align:right;color:black;">Net Total:</td>
                <td><input class="background_1 padding border_1" style="color:white;width:9vw;font-size: 0.9em;"
                        type="text" id="net_total" readonly></td>
                <td></td>
            </tr>
        </tfoot>
    </table>
    <div class="row column_gap_2 width_80">
        <div class="column  width_100">
            <label>IMPORTANT NOTES</label>
            <textarea name="note" class="width_100" rows="4"><?php echo $invoice['notes']; ?></textarea>
        </div>
    </div>
    <div class="row column_gap_2 width_80">
        <div class="column  width_100">
            <label>TERMS</label>
            <textarea name="terms" class="width_100" rows="12"><?php echo $invoice['terms']; ?>
            </textarea>
        </div>
    </div>
    <script>
        let index = 1;

        function delete_row(el) {
            var row = el.parentNode.parentNode;
            row.parentNode.removeChild(row);
            calculateTotals();
        }



        function add_row() {
            index++;
            var table = document.getElementById("table").getElementsByTagName('tbody')[0];
            var row = table.insertRow(-1);

            row.innerHTML = `
            <tr>
            <td>
                <input class="background_1  padding_minmal border_1"
                    style="color:white; width: 8vw;font-size: 0.9em;" id="stock_code_${index}"
                    onchange="get_unit_of_measure(this,${index})" list="stock_list">
            </td>
            <td>
                <input class=" background_1 padding_minmal border_1"
                    style="color:white;font-size: 0.9em;width:20vw;" name="stock_id[]" id="stock_${index}"
                    list="stock_list" onchange="get_unit_of_measure(this,${index})">
            </td>
            <td> 
                <input class="background_1 width_90 padding_minmal border_1" style="color:white; width:6vw;font-size: 0.9em;" type="text" id="unit_of_measure_${index}" name="unit_of_measure[]" oninput="get_unit_of_measure(this,${index})">
            </td>
            <td>
                <input class="background_1 width_90 padding_minmal border_1"
                    style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0" name="qty[]"
                    oninput="calculateRow(this,${index})">
            </td>
            <td>
                <input class="background_1 width_90 padding_minmal border_1"
                    style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0"
                    name="size_m[]">
            </td>
            <td>
                <input class="background_1 width_90 padding_minmal border_1"
                    style="color:white; width:5vw;font-size: 0.9em;" type="number" min="0" value="0"    
                    name="pannels[]">
            </td>
            <td>
                <input class="background_1 padding_minmal border_1" style="color:white;width:7vw;font-size: 0.9em;"
                    type="text" min="0" value="0" id="retail_price_${index}" step="0.01" name="price[]"
                    oninput="calculateRow(this,${index})">
            </td>
            <td>
                <input class="background_1 padding_minmal border_1" style="color:white;width:9vw;font-size: 0.9em;"
                    type="text" id="total_${index}" readonly>
            </td>
            <td>
                <button class="width_100" onclick="delete_row(this)">DELETE</button>
            </td>
            
            </tr>
            `;
        }

        function delete_row(el) {
            var row = el.parentNode.parentNode;
            row.parentNode.removeChild(row);
            calculateTotals();
        }

        function get_unit_of_measure(input, i) {
            data = input.value.split("~");
            document.getElementById("unit_of_measure_" + i).value = data[2];
            document.getElementById("stock_code_" + i).value = data[0];
            let price = parseFloat(data[3].replace(/ /g, "").replace(/[^\d.]/g, '.')) || 0;
            console.log(data[3]);
            console.log(price);
            document.getElementById("retail_price_" + i).value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(price);
            document.getElementById("stock_" + i).value = data[1];

        }
        function calculateRow(input, i) {
            let qty = parseFloat(document.querySelector(`#table #unit_of_measure_${i}`).parentNode.parentNode.querySelector("[name='qty[]']").value) || 0;
            let price = parseFloat(document.getElementById("retail_price_" + i).value.replace("R", "").replace(",", '')) || 0;
            let total = qty * price;
            document.getElementById("total_" + i).value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(total);
            calculateTotals();
        }

        function calculateTotals() {
            let totals = document.querySelectorAll("[id^='total_']");
            let subtotal = 0;
            totals.forEach(t => {
                subtotal += parseFloat(t.value.replace(/[^\d.]/g, '')) || 0;
            });
            let vat = subtotal * 0.15;
            let net_total = subtotal + vat;

            document.getElementById("subtotal").value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(subtotal);
            document.getElementById("vat").value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(vat);
            document.getElementById("net_total").value = new Intl.NumberFormat('en-ZA', { style: 'currency', currency: 'ZAR' }).format(net_total);
        }

    </script>
    <br>
    <button class="width_90" onclick="save('save_invoices.php')">SAVE</button>
    <br>
</div>

<script>
    function open_pdf(url) {
        window.open(url);
    }
    function save(url) {
        let payload = {};

        // handle all inputs
        let inputs = document.querySelectorAll("input, select, textarea");
        inputs.forEach(el => {
            let name = el.name;
            if (!name) return;

            if (name.endsWith("[]")) {
                // ensure array
                if (!payload[name]) payload[name] = [];
                payload[name].push(el.value);
            } else {
                payload[name] = el.value;
            }
        });

        // create form
        let form = document.createElement("form");
        form.method = "POST";
        form.action = url;

        // add hidden inputs
        for (let key in payload) {
            if (Array.isArray(payload[key])) {
                payload[key].forEach(v => {
                    let input = document.createElement("input");
                    input.type = "hidden";
                    input.name = key;   // already has [] in name
                    input.value = v;
                    form.appendChild(input);
                });
            } else {
                let input = document.createElement("input");
                input.type = "hidden";
                input.name = key;
                input.value = payload[key];
                form.appendChild(input);
            }
        }

        document.body.appendChild(form);
        form.submit();
    }
</script>