<?php


class DashboardWidget
{
    private static $chartCounter = 0;

    public static function includeAssets()
    {
        return '
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        ';
    }

    private static function wrapBlock($content, $width, $height)
    {
        return "<div class='dashboard-block' style='width:$width; height:$height;'>$content</div>";
    }
    public static function circleGraph($title, $min, $max, $current, $icon = '🛢️', $width = '30vw', $height = '35vh')
    {
        $id = 'circleChart_' . self::$chartCounter++;
        $percentage = round(($current - $min) / ($max - $min) * 100);
        $percentage = max(0, min($percentage, 100));
        $displayText = "$percentage%";

        $used = $percentage;
        $remaining = 100 - $percentage;

        $content = "
    <style>
        #container_$id {
            position: relative;
            width: 100%;
            max-width: 250px;
            max-height: 250px;
            margin: 0 auto;
            aspect-ratio: 1 / 1;
        }
        #container_$id canvas {
            width: 100% !important;
            height: 100% !important;
        }
        #percentageText_$id {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-family: 'Inter', sans-serif;
            font-weight: bold;
            font-size: 2.5em;
            color: #333;
            pointer-events: none;
        }
    </style>

    <div class='dashboard-title'>$icon $title</div>
    <div style='text-align: center; font-size: 0.9em; color: #666;'>$current / $max</div>
    <div id='container_$id'>
        <div id='percentageText_$id'>$displayText</div>
        <canvas id='$id'></canvas>
    </div>

    <script src='https://cdn.jsdelivr.net/npm/chart.js'></script>
    <script>
        new Chart(document.getElementById('$id'), {
            type: 'doughnut',
            data: {
                labels: ['Used', 'Remaining'],
                datasets: [{
                    data: [$used, $remaining],
                    backgroundColor: ['#17469e', '#e0e0e0'],
                    borderWidth: 0
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                cutout: '70%',
                plugins: {
                    legend: { display: false },
                    tooltip: { enabled: false },
                    title: { display: false }
                }
            }
        });
    </script>";

        return self::wrapBlock($content, $width, $height);
    }





    public static function columnGraph($title, $dataArray, $width = '45vw', $height = '40vh')
    {
        $id = 'barChart_' . self::$chartCounter++;
        $labels = [];
        $values = [];
        foreach ($dataArray as $entry) {
            $labels[] = $entry[1];  // DateTime
            $values[] = (int) filter_var($entry[0], FILTER_SANITIZE_NUMBER_INT);
        }
        $labelsJS = json_encode($labels);
        $valuesJS = json_encode($values);
        $content = "
            <div class='dashboard-title'>$title</div>
            <canvas id='$id'></canvas>
            <script>
                new Chart(document.getElementById('$id'), {
                    type: 'bar',
                    data: {
                        labels: $labelsJS,
                        datasets: [{
                            label: '%',
                            data: $valuesJS,
                            backgroundColor: '#17469e',
                            borderRadius: 5
                        }]
                    },
                    options: {
                        scales: {
                            y: { beginAtZero: true }
                        }
                    }
                });
            </script>";
        return self::wrapBlock($content, $width, $height);
    }

    public static function tableBlock($title, $headers, $rows, $width = '60vw', $height = 'auto')
    {
        $tableHeadings = '';
        foreach ($headers as $heading) {
            $tableHeadings .= "<th>$heading</th>";
        }
        $tableBody = '';
        foreach ($rows as $row) {
            $link = array_pop($row);
            $tableBody .= '<tr>';
            foreach ($row as $col) {
                $tableBody .= "<td>$col</td>";
            }
            $tableBody .= "<td><a href='$link' class='dashboard-button'>View</a></td></tr>";
        }

        $content = "
            <div class='dashboard-title'>$title</div>
            <table class='dashboard-table'>
                <thead><tr>$tableHeadings<th>Action</th></tr></thead>
                <tbody>$tableBody</tbody>
            </table>";
        return self::wrapBlock($content, $width, $height);
    }

    public static function textBlock($title, $text, $fontSize = '1rem', $width = '30vw', $height = '20vh')
    {
        $content = "
            <div class='dashboard-title'>$title</div>
            <p style='font-size: $fontSize; text-align:center; color: #555;'>$text</p>";
        return self::wrapBlock($content, $width, $height);
    }

    public static function lineGraph($title, $labels, $dataPoints, $labelName = 'Value', $width = '45vw', $height = '40vh')
    {
        $id = 'lineChart_' . self::$chartCounter++;
        $labelsJS = json_encode($labels);
        $dataJS = json_encode($dataPoints);
        $content = "
            <div class='dashboard-title'>$title</div>
            <canvas id='$id'></canvas>
            <script>
                new Chart(document.getElementById('$id'), {
                    type: 'line',
                    data: {
                        labels: $labelsJS,
                        datasets: [{
                            label: '$labelName',
                            data: $dataJS,
                            borderColor: '#f36e21',
                            backgroundColor: 'rgba(0,150,136,0.1)',
                            fill: true,
                            tension: 0.3
                        }]
                    },
                    options: {
                        scales: {
                            y: { beginAtZero: true }
                        }
                    }
                });
            </script>";
        return self::wrapBlock($content, $width, $height);
    }
}