<?php

include "../../classes/db.class.php";
require '../../../vendor/autoload.php';
use Dompdf\Dompdf;

$db = new DBMain();
$quote_id = $_GET['record_id']; // Assuming quote_id is passed as a query param
$quote = $db->get_quote_by_id($quote_id); // Assuming this function retrieves quote details by id
$client_info = $db->get_client_info($quote['client_id']);

$items = explode("|", $quote['items']);
$prices = explode("|", $quote['prices']);
$amounts = explode("|", $quote['amount']);
$totalPrice = 0;
$itemRows = '';

for ($i = 0; $i < count($items); $i++) {
    $quantity = $amounts[$i];
    $price = $prices[$i];
    $total = $quantity * $price;
    $totalPrice += $total;
    $itemRows .= "<tr>
                    <td>{$items[$i]}</td>
                    <td>{$quantity}</td>
                    <td>{$price}</td>
                    <td>{$total}</td>
                  </tr>";
}

$vat = $totalPrice * 0.15;
$totalWithVat = $totalPrice + $vat;

$html = "
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid black; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <h1>Quote</h1>
    <p>Quote Number: {$quote['quote_number']}</p>
    <p>Client: {$client_info['name']}</p>
    <p>{$quote['description']}</p>
    <img src='../../uploads/images/ems_logo.png' alt='Logo' style='width: 150px; float: right;'>
    <h2>Items</h2>
    <table>
        <thead>
            <tr>
                <th>Item</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            {$itemRows}
        </tbody>
    </table>
    <p>Total Price: " . number_format($totalPrice, 2) . "</p>
    <p>VAT (15%): " . number_format($vat, 2) . "</p>
    <p>Total with VAT: " . number_format($totalWithVat, 2) . "</p>
</body>
</html>
";

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$output = $dompdf->output();
file_put_contents('quote.pdf', $output);


