<?php

include "../../classes/fpdf/fpdf.php";
include "../../classes/db.class.php";


$db = new DBMain();
$quote_id = $_GET['record_id']; // Assuming quote_id is passed as a query param
$quote = $db->get_quote_by_id($quote_id); // Assuming this function retrieves quote details by id
$client_info = $db->get_client_info($quote['client_id']);
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','',16);
$pdf->Ln(10);
$pdf->SetFont('Arial','',14);

$pdf->Cell(0,10,'Quote Number: ' . $quote['quote_number'],0,1);
$pdf->Cell(0,10,'Client: ' . $client_info['name'],0,1);
$pdf->multicell(0,10, $quote['description'],0,1);
$pdf->Image('../../uploads/images/ems_logo.png',140,15,60);
$pdf->Ln(10);
$pdf->SetFont('Arial','B',14);
// $pdf->Cell(0,10,'Items',1,1,'C');
$pdf->SetFont('Arial','',14);
$pdf->Cell(130,10,'Item',1,0);
$pdf->Cell(20,10,'Quantity',1,0);
$pdf->Cell(20,10,'Price',1,0);
$pdf->Cell(20,10,'Total',1,0);
$pdf->Ln();
$pdf->SetFont('Arial','',12);

$items = explode("|", $quote['items']);
$prices = explode("|", $quote['prices']);
$amounts = explode("|", $quote['amount']);
$count = count($items);
$totalPrice = 0;
$i = 0;

foreach ($items as $item): 
    $quantity = $amounts[$i];
    $price = $prices[$i];
    $total = $quantity * $price;
    $pdf->cell(130,10,$item,0);
    $pdf->Cell(20,10,$quantity,1,0);
    $pdf->Cell(20,10,$price,1,0);
    $pdf->Cell(20,10,$total,1,1);
    $totalPrice += $total;
    $i++;
endforeach;
$pdf->SetFont('Arial','',14);
$pdf->Cell(55,10,'',0,0); // Empty cell to align the total table to the right
$pdf->Cell(55,10,'',0,0); // Another empty cell to align properly
$pdf->Cell(40,10,'Total Price:',1,0);
$pdf->Cell(40,10,number_format($totalPrice, 2),1,1);

$pdf->Cell(55,10,'',0,0); // Empty cell to align the total table to the right
$pdf->Cell(55,10,'',0,0); // Another empty cell to align properly
$pdf->Cell(40,10,'VAT (15%):',1,0);
$pdf->Cell(40,10,number_format($totalPrice * 0.15, 2),1,1);

$pdf->Cell(55,10,'',0,0); // Empty cell to align the total table to the right
$pdf->Cell(55,10,'',0,0); // Another empty cell to align properly
$pdf->Cell(40,10,'Total with VAT:',1,0);
$pdf->Cell(40,10,number_format($totalPrice * 1.15, 2),1,1);

$pdf->Output("{$_GET['type']}","quote.pdf");

