<?php

include "../../classes/app.class.php";
$app = new app();
$db = new DBMain();
?>
<div class='container flex_container'>
    <h1>NEW QUOTE</h1>
    <hr>
    <div class="container flex_container_content" style="border: 1px solid black;padding: 2%; border-radius: 5px;">
        <div class='flex_container'>
            <label>Quote Description:</label>
            <textarea style='width:100%;' id='quote_description'></textarea>
        </div>
        <div class='flex_container'>
            <label>Items:</label>
            <table id='quote_items' style='width:100%'>
                <thead>
                    <tr>
                        <th>Item</th>
                        <th>Price</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><input type='text' class='item'></td>
                        <td><input type='number' class='price'></td>
                        <td><button onclick="remove_line(this)">Remove</button></td>
                    </tr>
                </tbody>
            </table>
            <button onclick="add_line()">Add Line</button>
        </div>
    </div>
    <br>
    <button onclick="add_quote()" id='add_quote_btn'>ADD QUOTE</button>
</div>

<script>
    function add_line(){
        table = document.getElementById('quote_items');
        row = table.insertRow(-1);
        cell1 = row.insertCell(0);
        cell2 = row.insertCell(1);
        cell3 = row.insertCell(2);
        cell1.innerHTML = "<input type='text' class='item'>";
        cell2.innerHTML = "<input type='number' class='price'>";
        cell3.innerHTML = "<button onclick=\"remove_line(this)\">Remove</button>";
    }

    function remove_line(obj){
        row = obj.parentNode.parentNode;
        table = document.getElementById('quote_items');
        table.deleteRow(row.rowIndex);
    }

    function add_quote(){
        description = document.getElementById('quote_description').value;
        items = document.getElementsByClassName('item');
        prices = document.getElementsByClassName('price');
        data = {
            description: description,
            items: [],
            prices: []
        };
        for (var i = 0; i < items.length; i++) {
            data.items.push(items[i].value);
            data.prices.push(prices[i].value);
        }
        var xhttp = new XMLHttpRequest();
        xhttp.onload = function() {
            alert(this.responseText);
            if (this.responseText == 1) {
                alert('Quote added successfully');
            }
        }
        xhttp.open("POST", '../../ajax/quote/add_quote.php', true);
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhttp.send("data=" + JSON.stringify(data));
    }
</script>
