<?php

include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$functions = new functions();
$db = new db_safeguard();
$where_data[] = "company_id = {$_SESSION['company_id']}";


if (strlen($_POST['date_from']) > 5 && strlen($_POST['date_to']) > 5) {
    $where_data[] = " date_time_opened BETWEEN '{$_POST['date_from']} 00:00' AND '{$_POST['date_to']} 23:59'";
}

if (isset($_POST['asset_id']) && $_POST['asset_id'] != "") {
    $where_data[] = " asset_id = {$_POST['asset_id']}";
}

if (isset($_POST['user_id']) && $_POST['user_id'] != "") {
    $where_data[] = " user_id = {$_POST['user_id']}";
}

if (isset($_POST['tank_id']) && $_POST['tank_id'] != "") {
    $where_data[] = " tank_id = {$_POST['tank_id']}";
}


$data = implode(" AND ", $where_data);

// echo $data;

$latest_orders_res = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE $data ORDER BY record_id DESC");
?>
<style>
    /* Wrap your table in a container */
    .table-responsive {
        width: 100%;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        /* smooth scrolling on iOS */
    }

    /* Basic styling for the table (same as before) */
    table {
        width: 100%;
        border-collapse: collapse;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        font-size: 14px;
        color: #333;
        background: #fff;
        box-shadow: 0 2px 8px rgb(0 0 0 / 0.1);
        border-radius: 8px;
        overflow: hidden;
        min-width: 700px;
        /* Ensure min width so horizontal scroll triggers */
    }

    table th {
        background: #1e90ff;
        color: white;
        text-align: left;
        padding: 12px 15px;
        font-weight: 600;
        letter-spacing: 0.03em;
        user-select: none;
    }

    table td {
        padding: 12px 15px;
        border-bottom: 1px solid #eaeaea;
    }

    table tr:nth-child(even) {
        background: #f9f9f9;
    }

    table tbody tr:hover {
        background-color: #d0e7ff;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }
</style>
<div class="header">
    <input type="submit" class="submit_btn" value="OPEN PDF"
        onclick="window.open('diesel_orders.pdf.php?where_data=<?php echo urlencode($data); ?>','_blank')" />
    <input type="submit" class="submit_btn" value="OPEN CSV"
        onclick="window.open('vsv.report.php?where_data=<?php echo urlencode($data); ?>','_blank')" />
    <input type="submit" class="submit_btn" value="OPEN EXCEL"
        onclick="window.open('excel.report.php?where_data=<?php echo urlencode($data); ?>','_blank')" />
</div>
<div class="table-responsive">
    <table>
        <tr>
            <th>
                STATUS
            </th>
            <th>
                ORDER ID
            </th>
            <th>
                ASSET
            </th>
            <th>
                ODO
            </th>
            <th>
                USER
            </th>
            <th>
                OPENED
            </th>
            <th>
                CLOSED
            </th>
            <th>
                AMOUNT (mL)
            </th>
            <th>
                TANK
            </th>
        </tr>

        <?php

        while ($latest_orders = $latest_orders_res->fetch_assoc()) {
            ?>

            <tr>
                <td>
                    <input type='text' value='<?php echo $latest_orders['status']; ?>'
                        onchange="change(this,'status','<?php echo $latest_orders['record_id']; ?>')" class="inputs">
                </td>
                <td>
                    <input type='text' value=' <?php echo $latest_orders['order_id']; ?>' readonly class="inputs">
                </td>
                <td>
                    <select class="inputs" onchange="change(this,'asset_id','<?php echo $latest_orders['record_id']; ?>')">
                        <?php $asset_res = $db->query("assets", "SELECT * FROM assets WHERE company_id = {$_SESSION['company_id']}"); ?>
                        <option value="<?php echo $latest_orders['asset_id']; ?>">
                            <?php echo $functions->get_asset_name($latest_orders['asset_id']); ?>
                        </option>
                        <?php while ($assets = $asset_res->fetch_assoc()) { ?>
                            <option value="<?php echo $assets['record_id']; ?>"><?php echo $assets['name']; ?></option>
                        <?php } ?>
                    </select>
                </td>
                 <td>
                    <input type='text' value='<?php echo $latest_orders['odo']; ?>'
                        onchange="change(this,'odo','<?php echo $latest_orders['record_id']; ?>')" class="inputs">
                </td>
                <td>
                    <select class="inputs" onchange="change(this,'user_id','<?php echo $latest_orders['record_id']; ?>')">
                        <?php $users_res = $db->query("users", "SELECT * FROM users WHERE company_id = {$_SESSION['company_id']} AND `status` = 1"); ?>
                        <option value="<?php echo $latest_orders['user_id']; ?>">
                            <?php echo $functions->get_username($latest_orders['user_id']); ?>
                        </option>
                        <?php while ($user = $users_res->fetch_assoc()) { ?>
                            <option value="<?php echo $user['record_id']; ?>"><?php echo $user['username']; ?></option>
                        <?php } ?>
                    </select>
                </td>
                <td>
                    <input type='text' value=' <?php echo $latest_orders['date_time_opened']; ?>' class="inputs"
                        onchange="change(this,'date_time_opened','<?php echo $latest_orders['record_id']; ?>')">
                </td>
                <td>
                    <input type='text' value='<?php echo $latest_orders['date_time_closed']; ?>' class="inputs"
                        onchange="change(this,'date_time_closed','<?php echo $latest_orders['record_id']; ?>')">
                </td>
                <td>
                    <input type='text' value=' <?php echo number_format($latest_orders['amount'], 2); ?>' class="inputs"
                        onchange="change(this,'amount','<?php echo $latest_orders['record_id']; ?>')">
                </td>
                <td>
                    <?php echo $functions->get_tank_name($latest_orders['tank_id']); ?>
                </td>
            </tr>
            <?php
        }
        ?>

    </table>
</div>

<script>
    function change(input, column_name, record_id) {
        if (confirm("Are you sure you want to change this detail?")) {
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    var orig_color = input.style.backgroundColor;
                    if (this.responseText == "1") {
                        input.style.transition = "background-color 1.5s ease";
                        input.style.backgroundColor = "green";
                        setTimeout(function () {
                            input.style.backgroundColor = orig_color;
                        }, 1500);

                    } else {
                        input.style.transition = "background-color 1.5s ease";
                        input.style.backgroundColor = "red";
                        setTimeout(function () {
                            input.style.backgroundColor = orig_color;
                        }, 1500);
                        alert(this.responseText);
                    }
                }
            };
            xmlhttp.open("POST", "change_details.ajax.php", true);
            xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            xmlhttp.send("value=" + input.value + "&column_name=" + column_name + "&record_id=" + record_id);
        }
    }
</script>