<?php
session_start();
include "../classes/html_items.php";
include "../classes/db.class.php";
include "../functions.class.php";
include "../classes/dashboard.class.php";
$functions = new functions();
$dash = new dash_items();
$functions = new functions();
function get_day_of_the_week($date)
{
    $date = date('w', strtotime($date));
    switch ($date) {
        case 0:
            return 'Sunday';
        case 1:
            return 'Monday';
        case 2:
            return 'Tuesday';
        case 3:
            return 'Wednesday';
        case 4:
            return 'Thursday';
        case 5:
            return 'Friday';
        case 6:
            return 'Saturday';
    }
}

echo DashboardWidget::includeAssets();
?>

<style>
    body {
        margin-top: 1em;
        display: flex;
        flex-direction: column;
        flex-wrap: wrap;
        align-content: center;
        justify-content: flex-start;
        align-items: center;
    }
</style>
<?php
$logo_file_check = $db->query("companies", "SELECT * FROM companies WHERE record_id = {$_SESSION['company_id']} AND logo_file != ''");
if ($logo_file_check->num_rows > 0) {
    $logo_file = "company/logos/" . $logo_file_check->fetch_assoc()['logo_file'];
} else {
    $logo_file = "../assets/logo.png";
}
?>
<div class="container_home">
    <div class="data_containers hidden_desktop">
        <img src="<?php echo $logo_file; ?>" alt="logo" class="company_home_logo">
    </div>
    <div class="data_containers">
        <div class="small_line"></div>
        <h1>TANK LEVELS</h1>
        <?php
        $tanks_res = $db->query("tanks", "SELECT * FROM tanks WHERE record_id IN ({$_SESSION['tanks']}) AND company_id = {$_SESSION['company_id']}");
        while ($tank = $tanks_res->fetch_assoc()) {
            $dash->tank($tank['record_id'], "tanks/tanks_view.php?record_id={$tank['record_id']}");
        }
        ?>
    </div>
    <div class="data_containers">
        <div class="small_line"></div>
        <?php
        $dash->liters_bar("TOTAL TODAY (ALL)", $functions->total_liters_for_today());
        ?>

        <div class="small_line"></div>
        <h1>TOTAL PER GROUP</h1>
        <?php
        $site_res = $db->query("sites", "SELECT DISTINCT sites.record_id AS site_id, sites.name AS site_name FROM sites LEFT JOIN tanks ON sites.record_id = tanks.site_id WHERE  tanks.record_id IN ({$_SESSION['tanks']}) AND sites.company_id = {$_SESSION['company_id']}");
        while ($site = $site_res->fetch_assoc()) {
            $tanks_res = $db->query("tanks", "SELECT * FROM tanks WHERE company_id = {$_SESSION['company_id']} AND site_id = {$site['site_id']}");
            $tank_total = 0;
            while ($tank = $tanks_res->fetch_assoc()) {
                $tank_total += $functions->total_liters_for_tank($tank['record_id']);
            }

            $dash->liters_bar($site['site_name'], $tank_total, "diesel/groups.php?record_id={$site['site_id']}");
        }

        ?>
        <div class="small_line"></div>
        <h1>EXCLUDED TAGS</h1>
        <?php $dash->liters_bar($site['site_name'], $functions->total_liters_for_today_excluded_tags(), "diesel/excluded_tags_view.php"); ?>
    </div>
    <div class="graph_containers">
        <div class="small_line"></div>
        <h1>7 DAYS (ALL)</h1>
        <?php

        $data_array = [];
        $date = date('Y-m-d') . ' 00:00';
        $date2 = date('Y-m-d') . ' 23:59';
        $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR  (( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0))");
        $fuel_movement = $fuel_movement_array_res->fetch_assoc();
        $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

        $date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
        $date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
        $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR  (( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0))");
        $fuel_movement = $fuel_movement_array_res->fetch_assoc();
        $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

        $date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
        $date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
        $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR  (( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0))");
        $fuel_movement = $fuel_movement_array_res->fetch_assoc();
        $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

        $date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
        $date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
        $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR  (( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0))");
        $fuel_movement = $fuel_movement_array_res->fetch_assoc();
        $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

        $date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
        $date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
        $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR  (( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0))");
        $fuel_movement = $fuel_movement_array_res->fetch_assoc();
        $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

        $date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
        $date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
        $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR  (( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0))");
        $fuel_movement = $fuel_movement_array_res->fetch_assoc();
        $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

        $date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
        $date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
        $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR  (( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0))");
        $fuel_movement = $fuel_movement_array_res->fetch_assoc();
        $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

        $date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
        $date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
        $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR  (( fm.tank_id IN ({$_SESSION['tanks']}) AND  (fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0))");
        $fuel_movement = $fuel_movement_array_res->fetch_assoc();
        $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

        echo DashboardWidget::columnGraph('', $data_array, '90vw');



        ?>
    </div>
    <div class="graph_containers">
        <div class="small_line"></div>
        <h1>MONTHLY (ALL)</h1>
        <?php
        $lastSixMonths = [];
        for ($i = 0; $i <= 5; $i++) {
            $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

        }

        $amounts_arr = [];
        foreach ($lastSixMonths as $key => $month) {
            $total_amount_res = $db->query("fuel_movement", "SELECT SUM(fm.amount) AS total_amount FROM fuel_movement as fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE (fm.tank_id IN ({$_SESSION['tanks']}) AND  fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$month}-01' AND '{$month}-31' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ({$_SESSION['tanks']}) AND  fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$month}-01' AND '{$month}-31' AND fm.client_id = 0)");
            $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month . '-01'))];
        }
        echo DashboardWidget::columnGraph("", $amounts_arr, '90vw');



        ?>
    </div>
    <div class="graph_containers">
        <div class="small_line"></div>
        <h1>PER GROUP</h1>

        <?php
        $site_res = $db->query("sites", "SELECT DISTINCT sites.record_id AS site_id, sites.name AS site_name FROM sites LEFT JOIN tanks ON sites.record_id = tanks.site_id WHERE  tanks.record_id IN ({$_SESSION['tanks']}) AND sites.company_id = {$_SESSION['company_id']}");
        while ($site = $site_res->fetch_assoc()) {
            $tanks = [];
            $tanks_res = $db->query("tanks", "SELECT * FROM tanks WHERE company_id = {$_SESSION['company_id']} AND site_id = {$site['site_id']} AND record_id IN ({$_SESSION['tanks']})");
            while ($tank = $tanks_res->fetch_assoc()) {
                $tanks[] = $tank['record_id'];
            }

            $tanks_ids = implode(',', $tanks);

            $data_array = [];
            $date = date('Y-m-d') . ' 00:00';
            $date2 = date('Y-m-d') . ' 23:59';
            $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ((fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR ((fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");

            $fuel_movement = $fuel_movement_array_res->fetch_assoc();
            $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

            $date = date('Y-m-d', strtotime("-1 day")) . ' 00:00';
            $date2 = date('Y-m-d', strtotime("-1 day")) . ' 23:59';
            $fuel_movement_array_res = $db->query("fuel_movement","SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ((fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR ((fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
            $fuel_movement = $fuel_movement_array_res->fetch_assoc();
            $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

            $date = date('Y-m-d', strtotime("-2 day")) . ' 00:00';
            $date2 = date('Y-m-d', strtotime("-2 day")) . ' 23:59';
            $fuel_movement_array_res = $db->query("fuel_movement","SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ((fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR ((fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
            $fuel_movement = $fuel_movement_array_res->fetch_assoc();
            $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

            $date = date('Y-m-d', strtotime("-3 day")) . ' 00:00';
            $date2 = date('Y-m-d', strtotime("-3 day")) . ' 23:59';
            $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ((fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR ((fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
            $fuel_movement = $fuel_movement_array_res->fetch_assoc();
            $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

            $date = date('Y-m-d', strtotime("-4 day")) . ' 00:00';
            $date2 = date('Y-m-d', strtotime("-4 day")) . ' 23:59';
            $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ((fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR ((fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
            $fuel_movement = $fuel_movement_array_res->fetch_assoc();
            $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

            $date = date('Y-m-d', strtotime("-5 day")) . ' 00:00';
            $date2 = date('Y-m-d', strtotime("-5 day")) . ' 23:59';
            $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ((fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR ((fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
            $fuel_movement = $fuel_movement_array_res->fetch_assoc();
            $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

            $date = date('Y-m-d', strtotime("-6 day")) . ' 00:00';
            $date2 = date('Y-m-d', strtotime("-6 day")) . ' 23:59';
            $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ((fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR ((fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
            $fuel_movement = $fuel_movement_array_res->fetch_assoc();
            $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];

            $date = date('Y-m-d', strtotime("-7 day")) . ' 00:00';
            $date2 = date('Y-m-d', strtotime("-7 day")) . ' 23:59';
            $fuel_movement_array_res = $db->query("fuel_movement", "SELECT sum(fm.amount) AS amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE ((fm.status = 'RFID' ) AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR ((fm.status = 'MANUAL OVERRIDE') AND fm.company_id = {$_SESSION['company_id']} AND fm.tank_id IN ($tanks_ids)  AND fm.date_time_closed BETWEEN '{$date}' AND '{$date2}' AND fm.client_id = 0)");
            $fuel_movement = $fuel_movement_array_res->fetch_assoc();
            $data_array[] = [$fuel_movement['amount'], get_day_of_the_week($date)];
            ?>
            <div class="small_line"></div>
            <h1><?php echo $site['site_name']; ?> 7 DAYS</h1>

            <?php
            echo DashboardWidget::columnGraph('', $data_array, '90vw');


            $lastSixMonths = [];
            for ($i = 0; $i <= 5; $i++) {
                $lastSixMonths[] = date('Y-m', strtotime("-$i months"));

            }
            $amounts_arr = [];
            foreach ($lastSixMonths as $key => $month) {
                $total_amount_res = $db->query("fuel_movement", "SELECT SUM(fm.amount) AS total_amount FROM fuel_movement AS fm LEFT JOIN clients as c ON c.record_id = fm.client_id WHERE  (fm.tank_id IN ($tanks_ids) AND  fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$month}-01' AND '{$month}-31' AND c.company_id = {$_SESSION['company_id']} AND c.exclude_from_reports != 1) OR (fm.tank_id IN ($tanks_ids) AND  fm.company_id = {$_SESSION['company_id']} AND fm.date_time_closed BETWEEN '{$month}-01' AND '{$month}-31' AND  fm.client_id = 0)");
                $amounts_arr[] = [$total_amount_res->fetch_assoc()['total_amount'], date('F', strtotime($month . '-01'))];
            }
            ?>
            <div class="small_line"></div>
            <h1><?php echo $site['site_name']; ?> MONTHLY</h1>

            <?php
            echo DashboardWidget::columnGraph("", $amounts_arr, '90vw');

        }

        ?>

    </div>
</div>

<div class="spacer"></div>
<div class="spacer"></div>