<?php


include '../../fpdf.php';
include "../../classes/db.class.php";
$functions = new functions();
$total_stock_value = 0.00;

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('P');

$pdf->SetFont('Arial', 'B', 25);
$pdf->Cell(95, 10, "DIESEL SLIP", "", 1, 'L');

$pdf->Cell(50, 15, "", "", 1, 'L');
$fuel_res = $db->query('fuel_movement', "SELECT * FROM fuel_movement WHERE record_id = '{$_GET['record_id']}'");
$row = $fuel_res->fetch_assoc();

$logo_file_check = $db->query("companies","SELECT * FROM companies WHERE record_id = {$_SESSION['company_id']}");
if($logo_file_check->num_rows > 0){
    $logo_file = "../company/logos/".$logo_file_check->fetch_assoc()['logo_file'];
}else{
    $logo_file = "../../icons/logo.png";
}
$pdf->Image($logo_file, 165, 5, 40, 25);

$pdf->SetFont('Arial', '', 15);
$pdf->Cell(45, 15, "USER", "R", 0, 'L');
$pdf->SetFont('Arial', 'B', 15);

$pdf->Cell(45, 15, " ".$functions->get_username($row['user_id']), "", 1, 'L');
$pdf->SetFont('Arial', '', 15);

$pdf->Cell(45, 15, "TANK", "R", 0, 'L');
$pdf->SetFont('Arial', 'B', 15);

$pdf->Cell(45, 15,  " ".$functions->get_tank_name($row['tank_id']), "", 1, 'L');
$pdf->SetFont('Arial', '', 15);

$pdf->Cell(45, 15, "AMOUNT", "R", 0, 'L');
$pdf->SetFont('Arial', 'B', 15);

$pdf->Cell(45, 15,  " ".number_format(($row['amount'] / 1000), 2) . " L", "", 1, 'L');
$pdf->SetFont('Arial', '', 15);

$pdf->Cell(45, 15, "STARTED", "R", 0, 'L');
$pdf->SetFont('Arial', 'B', 15);

$pdf->Cell(45, 15,  " ".$row['date_time_opened'], "", 1, 'L');
$pdf->SetFont('Arial', '', 15);

$pdf->Cell(45, 15, "ENDED", "R", 0, 'L');
$pdf->SetFont('Arial', 'B', 15);

$pdf->Cell(45, 15,  " ".$row['date_time_closed'], "", 1, 'L');
$pdf->SetFont('Arial', '', 15);

$pdf->Cell(45, 15, "CLIENT", "R", 0, 'L');
$pdf->SetFont('Arial', 'B', 15);

$pdf->Cell(45, 15,  " ".$functions->get_client_name($row['client_id']), "", 1, 'L');
$pdf->SetFont('Arial', '', 15);

$pdf->Cell(45, 15, "PRICE PER L", "R", 0, 'L');
$pdf->SetFont('Arial', 'B', 15);

$pdf->Cell(45, 15,  " ".'R ' . number_format($row['fuel_price'], 2), "", 1, 'L');
$pdf->SetFont('Arial', '', 15);

$pdf->Cell(45, 15, '', "", 1, 'L');
$pdf->SetFont('Arial', '', 15);

$pdf->Cell(45, 15, "TOTAL", 1, 0, 'L');
$pdf->SetFont('Arial', 'B', 15);

$pdf->Cell(65, 15,  " "."R " . number_format(($row['fuel_price'] * ($row['amount'] / 1000)), 2), 1, 1, 'L');





$pdf->Output("I");