<?php
session_start();

include "../../html.class.php";
include "../../root.class.php";
include "../../classes/db.class.php";
$html = new html();
$functions = new functions();


// HTML FORM ELEMENTS
$username = new input();
$username->class("inputs");
$username->type("text");
$username->placeholder("username");
$username->name("username");
$username->required();
$username->id("username");

$password = new input();
$password->class("inputs");
$password->type("text");
$password->placeholder("password");
$password->name("password");
$password->required();
$password->id("password");

$company_id = new input();
$company_id->class("inputs");
$company_id->type("hidden");
$company_id->placeholder("company id");
$company_id->name("company_id");
$company_id->required();
$company_id->id("company_id");
$company_id->value($_SESSION['company_id']);

$user_type = new select();
$user_type->class("inputs");
$user_type->name("access_type");
$user_type->id("access_type");
$user_type->add_option("", "ACCESS LEVEL");
$user_type->add_option("ALL", "MANAGMENT");
$user_type->add_option("OPERATOR", "FUEL OPERATOR");
$user_type->required();

$status = new select();
$status->class("inputs");
$status->name("status");
$status->id("status");
$status->add_option("", "STATUS");
$status->add_option("1", "ACTIVE");
$status->add_option("0", "INACTIVE");


$submit_btn = new button();
$submit_btn->value("ADD");
$submit_btn->class('app_buttons');
$submit_btn->onclick("add_user()");


?>

<div class=" tank_item_container form_down">
    <h1>ADD USER</h1>
    <?php
    $company_id->add();
    echo "<label for='username'>Username</label>";
    $username->add();
    echo "<label for='password'>Password</label>";
    $password->add();
    echo "<label for='status'>Status</label>";
    $status->add();
    echo "<label for='Access_type'>Access Level</label>";
    $user_type->add();
    echo "<label for='user_type'>TANK ACCESS</label><br>";
    echo "<input class='inputs' type='hidden' id='tanks' name='tanks' readonly /><br><br>";

    // All button
    echo "<button type='button' class='app_buttons' onclick='toggle_all()' id='allBtn'>Select All</button><br><br>";

    $tanks_res = $db->query("tanks", "SELECT * FROM tanks WHERE record_id IN ({$_SESSION['tanks']}) AND company_id = {$_SESSION['company_id']} ORDER BY site_id ASC");
    while ($tank = $tanks_res->fetch_assoc()) {
        echo "<input class='inputs tank-item' type='text' value='{$tank['name']}' readonly 
             data-id='{$tank['record_id']}'
             style='background-color:#FFFFFF;cursor:pointer;' 
             onclick='add_tank({$tank['record_id']},this)' /><br>";
    }
    ?>
    <script>
        function add_tank(record_id, input) {
            const tanksField = document.getElementById("tanks");
            let selected = tanksField.value.split(",").filter(v => v.trim() !== "");

            if (input.style.backgroundColor === "rgb(255, 255, 255)" || input.style.backgroundColor === "#FFFFFF") {
                // Selecting tank
                selected.push(record_id);
                input.style.backgroundColor = "#0099ff";
            } else {
                // Deselecting tank
                selected = selected.filter(id => id != record_id);
                input.style.backgroundColor = "#FFFFFF";
            }

            tanksField.value = selected.join(",");
        }

        function toggle_all() {
            const tanksField = document.getElementById("tanks");
            const inputs = document.querySelectorAll(".tank-item");
            const allBtn = document.getElementById("allBtn");
            let selected = [];

            if (allBtn.innerText === "Select All") {
                // Select everything
                inputs.forEach(input => {
                    input.style.backgroundColor = "#0099ff";
                    selected.push(input.getAttribute("data-id"));
                });
                allBtn.innerText = "Clear All";
            } else {
                // Clear everything
                inputs.forEach(input => {
                    input.style.backgroundColor = "#FFFFFF";
                });
                selected = [];
                allBtn.innerText = "Select All";
            }

            tanksField.value = selected.join(",");
        }
    </script>
    <br>
    <?php
    $submit_btn->add();
    ?>
    <br>

    <br>


</div>
<div class="spacer"></div>
<?php
$ajax = new js_ajax();
$ajax->function_name("add_user");
$ajax->submit_btn_id("submit");
$ajax->insert("users");
$ajax->on_success("SUCCESSFULLY ADDED THE USER");

?>