<?php
include '../../fpdf.php';
include "../../root.class.php";
$call = new call_functions();


$db = new db_safeguard();
function remove_html_tags($text)
{
    $description = strip_tags($text);
    $description = str_replace("\n", "\r\n", $description);
    $description = preg_replace('/\s\s+/', ' ', $description);
    $description = preg_replace('/\n\n+/', "\n", $description);
    return $description;
}

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('L');

if ($_GET['jc_number'] != '') {

    if ($_GET['from_date'] == '' && $_GET['to_date'] == '') {
        $dispatch_res = $db->query('order_trans', "SELECT * FROM order_trans WHERE (job_card_no = '{$_GET['jc_number']}' AND user_id != 0 AND order_id = 0) ORDER BY `record_id` DESC;");
    } else {
        $dispatch_res = $db->query('order_trans', "SELECT * FROM order_trans WHERE ((date_time BETWEEN '{$_GET['from_date']} 00:00' AND '{$_GET['to_date']} 23:59' AND amount < 0) AND (job_card_no = '{$_GET['jc_number']}' AND user_id != 0 AND order_id = 0))  OR ((date_time BETWEEN '{$_GET['from_date']} 00:00' AND '{$_GET['to_date']} 23:59' AND amount > 0) AND (job_card_no = '{$_GET['jc_number']}' AND user_id != 0 AND order_id = 0)) ORDER BY `record_id` DESC;");
    }

} else {
    $dispatch_res = $db->query('order_trans', "SELECT * FROM order_trans WHERE ((date_time BETWEEN '{$_GET['from_date']} 00:00' AND '{$_GET['to_date']} 23:59' AND amount < 0) AND (job_card_no != '' AND user_id != 0 AND order_id = 0))  OR ((date_time BETWEEN '{$_GET['from_date']} 00:00' AND '{$_GET['to_date']} 23:59' AND amount > 0) AND (job_card_no != '' AND user_id != 0 AND order_id = 0)) ORDER BY `record_id` DESC;");
}


$pdf->Image('../../logo.png', 10, 10, 30);
$pdf->SetFont('Arial', 'B', 6);
$pdf->cell(35);
$pdf->Cell(115, 5, "MIDRAND AIR SERVICES (PTY) LTD", 0, 0, 'L');
$pdf->Cell(35, 5, "REG NO: 2018/573291/07", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "PO BOX 915", 0, 0, 'L');
$pdf->Cell(35, 5, "VAT NO: 4860287269", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "IRENE, 0062", 0, 0, 'L');
$pdf->Cell(35, 5, "PHONE: 012 661 2211", 0, 1, 'R');
$pdf->cell(35);

$pdf->Cell(115, 5, "", 0, 0, 'L');
$pdf->Cell(35, 5, "FAX: 012 661 2212", 0, 1, 'R');
$pdf->Cell(115, 15, "", 0, 1, 'L');
/// header end

$pdf->SetFont('Arial', 'B', 15);
$pdf->Cell(120, 5, "", 0, 1, 'C');
$pdf->Cell(50, 10, "DISPATCHED", "B", 1, 'L');
$pdf->Cell(120, 5, "", 0, 1, 'C');
$pdf->SetFont('Arial', 'B', 8);
// get all dispatched items under this jobcard number

// headings
$pdf->Cell(20, 10, "Date", "B", 0, 'L');
$pdf->Cell(75, 10, "Item", "B", 0, 'L');
$pdf->Cell(15, 10, "Amount", "B", 0, 'L');
$pdf->Cell(25, 10, "Disp/Rec. By", "B", 0, 'L');
$pdf->Cell(25, 10, "Project Manager", "B", 0, 'L');
$pdf->Cell(15, 10, "Job Card", "B", 0, 'L');
$pdf->Cell(45, 10, "J.C Name", "B", 0, 'L');
$pdf->Cell(25, 10, "Disp/Rec. To", "B", 1, 'L');
$pdf->SetFont('Arial', '', 5);

while ($dispatch = $dispatch_res->fetch_assoc()) {
    $item_res = $db->query("stock", "SELECT * FROM stock WHERE record_id = {$dispatch['stock_id']}");
    $item = $item_res->fetch_assoc();
    // check if job card is on project job card:
    $job_card_project_res = $db->query("job_cards", "SELECT * FROM job_cards WHERE jc_number = '{$dispatch['job_card_no']}'");
    $job_card_tech_res = $db->query("job_cards_tech", "SELECT * FROM job_cards_tech WHERE jc_number ='{$dispatch['job_card_no']}'");
    $job_card_acc_res = $db->query("job_card_accounts", "SELECT * FROM job_card_accounts WHERE `name` = '{$dispatch['job_card_no']}'");
    if ($job_card_project_res->num_rows > 0) {
        $job_card = $job_card_project_res->fetch_assoc();
        $job_card_name = $job_card["project_name"];
        $account_manager = $call->get_username($job_card['account_manager_id']);
    } else if ($job_card_tech_res->num_rows > 0) {
        $job_card = $job_card_tech_res->fetch_assoc();
        $job_card_name = $job_card["company_name"];
        $account_manager = $call->get_username($job_card['user_to_do']);
    } else if ($job_card_acc_res->num_rows > 0) {
        $job_card = $job_card_acc_res->fetch_assoc();
        $job_card_name = $job_card["description"];
        $account_manager = $call->get_username($job_card['account_manager_id']);
    } else {
        $job_card_name = "N/A";
        $account_manager = "N/A";
    }
    $pdf->Cell(20, 10, $dispatch['date_time'], "B", 0, 'L');
    $pdf->Cell(75, 10, $item['description'], "B", 0, 'L');
    $pdf->Cell(15, 10, $dispatch['amount'], "B", 0, 'L');
    $pdf->Cell(25, 10, $call->get_username($dispatch['user_id']), "B", 0, 'L');
    $pdf->Cell(25, 10, $account_manager, "B", 0, 'L');
    $pdf->Cell(15, 10, $dispatch['job_card_no'], "B", 0, 'L');
    $pdf->Cell(45, 10, $job_card_name, "B", 0, 'L');
    $pdf->Cell(15, 10, $dispatch['received'], "B", 1, 'L');

}


$pdf->Output("I");
