<?php
require("../../classes/autoload.php"); // Make sure FPDF is included

$order_res = $db->query('orders', "SELECT * FROM orders WHERE record_id = '{$_GET['record_id']}'");
$orders = $order_res->fetch_assoc();

$company_res = $db->query("company_info", "SELECT * FROM company_info WHERE record_id = 1");
$company = $company_res->fetch_assoc();

$invoice_res = $db->query("invoices", "SELECT * FROM invoices WHERE record_id = {$orders['invoice_id']}");
$invoice = $invoice_res->fetch_assoc();

$client_details_res = $db->query("clients", "SELECT * FROM clients WHERE record_id = '{$invoice['client_id']}'");
$client = $client_details_res->fetch_assoc();

$orders_list_res = $db->query("order_list", "SELECT * FROM order_list WHERE order_id = '{$_GET['record_id']}'");
$index = 1;

$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 12);

// Logos
$pdf->Image('../../assets/logo.png', 10, 15, 40);
$pdf->Image('../../assets/logo_2.png', 170, 10, 30);

// Title
$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 20, 'WORK SCHEDULE', 0, 1, 'C');
$pdf->Ln(10);



// Client Details
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(110, 8, $client['name'], 0, 0);
$pdf->Cell(80, 8, $company['name'], 0, 1);
$pdf->SetFont('Arial', '', 9);

$pdf->Cell(110, 8, $client['email'], 0, 0);
// $pdf->Cell(80, 8, "Reg: " . $company['reg'] . " | Vat NR: " . $company['vat'], 0, 1);
$pdf->Cell(80, 8, "TEL: " . $company['tel'], 0, 1);

$pdf->Cell(110, 8, $client['contact_person'], 0, 0);
$pdf->Cell(80, 8, "EMAIL: " . $company['email'], 0, 1);

$pdf->Cell(110, 8, $client['contact_number'], 0, 1);
$pdf->MultiCell(100, 8, $client['address']);
$pdf->Ln(6);
$pdf->SetXY(120, 64);
$pdf->MultiCell(70, 8, $company['address_line_1'] . "\n" . $company['address_line_2'] . "\n" . $company['address_line_3'] . "\n" . $company['address_line_4']);
// $pdf->Ln(11);

// $pdf->Ln(5);


// Quote Info
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(26, 6, "DATE: ", 0, 0);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(50, 6, date("Y-m-d"), 0, 1);
$pdf->SetFont('Arial', 'B', 10);

$pdf->Ln(1);


// Table Header
$pdf->SetFont('Arial', 'B', 8);
$pdf->SetFillColor(200, 200, 200);
$pdf->Cell(20, 7, 'Code', 1, 0, 'C', true);
$pdf->Cell(120, 7, 'Description', 1, 0, 'C', true);
$pdf->Cell(15, 7, 'Size', 1, 0, 'C', true);
$pdf->Cell(15, 7, 'Quantity', 1, 0, 'C', true);
$pdf->Cell(15, 7, 'Tick', 1, 1, 'C', true);

// Table Body
$pdf->SetFont('Arial', '', 7);
$subtotal = 0;


foreach ($orders_list_res as $order_list) {
    $stock_res = $db->query("stock", "SELECT * FROM stock WHERE record_id = '{$order_list['stock_id']}'");
    $stock = $stock_res->fetch_assoc();

    if ($stock['code'] == "DLVR") {
        continue;
    }

    $pdf->Cell(20, 7, $stock['code'], 1);
    $pdf->Cell(120, 7, $stock['name'], 1);
    $pdf->Cell(15, 7, $order_list['size_m'], 1, 0, 'C');
    $pdf->Cell(15, 7, $order_list['qty'], 1, 0, 'C');
    $pdf->Cell(15, 7, "", 1, 1, 'C');
}
$pdf->ln(8);
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(180, 7, 'JOB DESCRIPTION', 0, 1, 'L');
$pdf->SetFont('Arial', 'B', 6);
$pdf->MultiCell(180, 5, $orders["description"]);

$pdf->ln(8);
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell(150, 7, 'Description', 1, 0, 'C', true);
$pdf->Cell(15, 7, 'Tick', 1, 1, 'C', true);
$pdf->SetFont('Arial', '', 5);


$order_checklist_res = $db->query("order_checklist", "SELECT * FROM order_checklist WHERE order_id = '{$_GET['record_id']}'");
foreach ($order_checklist_res as $order_checklist) {

    $pdf->Cell(150, 7, $order_checklist['text'], 1);
    $pdf->Cell(15, 7, "", 1, 1, 'C');
}
$pdf->ln(8);
$pdf->SetFont('Arial', '', 8);
$pdf->Cell(50, 7, '', "B", 0, 'L');
$pdf->Cell(50, 7, '', "", 0, 'L');
$pdf->Cell(50, 7, '', "B", 1, 'L');
$pdf->Cell(50, 7, 'SITE MANAGER', "", 0, 'L');
$pdf->Cell(50, 7, '', "", 0, 'L');
$pdf->Cell(50, 7, 'CLIENT', "", 1, 'L');
$pdf->ln(2);
$pdf->SetFont('Arial', '', 6);
$pdf->MultiCell(170, 7, $orders['clause']);

// Output PDF
$pdf->Output('I', 'quotation.pdf');
