<?php

require_once "mail.class.php";

// function serviceComplete(String $serviceID, String $truckReg)
// {
//     try {
//         $mail = new mail();
//         $mail->setMailProps("Service Report", "Service Control", "HR");
//         $mail->truckService($serviceID);
//         $mail->body = "Truck " . $truckReg . " has competed it's service";
//         $mail->AltBody = "Truck " . $truckReg . " has competed it's service";
//         $mail->sendMail();

//         return true;
//     } catch (Exception $e) {
//         return false;
//     }
// }

function warning24(String $serviceID, String $truckReg)
{
    try {
        $mail = new mail();
        $mail->setMailProps("24 Hour Warning", "Service Control", "HR");
        //$mail->truckService($serviceID);
        $mail->body = "Truck " . $truckReg . " has not completed it's service within 24h";
        $mail->AltBody = "Truck " . $truckReg . " has not completed it's service within 24h";
        $mail->sendMail();

        return true;
    } catch (Exception $e) {
        return false;
    }
}


function warnings()
{
    if (!defined("NWP_IP")) {
        define("NWP_IP", "41.76.208.147");
        define("NWP_LOGIN_U", "newtodme_NTNCode");
        define("NWP_LOGIN_P", "NTN2Code!@#");
        define("NWP_DB", "newtodme_newton_service_control");
    }
    $db = new DbClass(
        NWP_IP,
        NWP_DB,
        NWP_LOGIN_U,
        NWP_LOGIN_P
    );

    $td = new _time();
    try {
        $rs = $db->Select("SELECT a.ID, a.TRUCK_BCODE, c.REGISTRATION_NUMBER, b.SEC_IN_TIME, b.TRUCK_STATUS, a.FLAGGED_8, a.FLAGGED_24, CONCAT(d.EMPLOYEE_NAME, ' ', d.EMPLOYEE_SURNAME) AS OPERATOR
                           FROM `SCAN_FLEET_RECORDS` a
                           LEFT JOIN `SERVICE_CLOCKING` b ON b.SERVICE_ID = a.ID 
                           LEFT JOIN `VEHICLES` c ON  c.NEWTON_BARCODE = a.TRUCK_BCODE 
                           LEFT JOIN `USERS` d ON d.EMPLOYEE_ID = a.SEC_EMP_IN  
                                               OR d.EMPLOYEE_ID = a.WB_EMP_IN 
                                               OR d.EMPLOYEE_ID = a.WB_EMP_OUT 
                                               OR d.EMPLOYEE_ID = a.WS_EMP_IN 
                                               OR d.EMPLOYEE_ID = a.WS_EMP_OUT                                             
                           WHERE (a.SERVICE_STATUS = 'CLOCKED_IN' AND a.FLAGGED_8 = '0') OR (a.SERVICE_STATUS = 'CLOCKED_IN' AND a.FLAGGED_24 = '0')");
        $trucks8Arr = array();
        $trucks24Arr = array();
        $trucks8IDArr = array();
        $trucks24IDArr = array();

        for ($i = 0; $i < count($rs); $i++) {

            $secIn = new DateTime($rs[$i]["SEC_IN_TIME"]);
            $currDate = new DateTime();
            $flagged_8 = $rs[$i]["FLAGGED_8"];
            $flagged_24 = $rs[$i]["FLAGGED_24"];

            $diffstr = $td->Time_Diff($secIn, $currDate);
            $hoursDiff = $td->hours;
            $status = $rs[$i]["TRUCK_STATUS"];

            if ($hoursDiff >= 8 && $flagged_8 == 0) {
                $operator = $rs[$i]["OPERATOR"];
                switch ($status) {
                    case "SEC_IN":
                        $status = "SECURITY IN";
                        break;
                    case "IN_WB":
                        $status = "INSIDE WASHBAY";
                        break;
                    case "WS_WAIT":
                        $status = "WAITING FOR WORKSHOP";
                        break;
                    case "IN_WS":
                        $status = "INSIDE WORKSHOP";
                        break;
                    case "SEC_WAIT":
                        $status = "WAITING FOR SECURITY OUT";
                        break;
                }
                $trucks8Arr[] = "<li><b>REGISTRATION NUMBER:</b> " . $rs[$i]["REGISTRATION_NUMBER"] . ", <b>STATUS:</b> " . $status . ", <b>LAST SCANNED BY:</b> " . $operator . ", <b>TOTAL TIME SINCE LAST SCAN:</b> " . $diffstr . "</li>";
                $trucks8IDArr[] = $rs[$i]["ID"];
            }

            if ($hoursDiff >= 24 && $flagged_24 == 0) {
                $operator = $rs[$i]["OPERATOR"];
                switch ($status) {
                    case "SEC_IN":
                        $status = "SECURITY IN";
                        break;
                    case "IN_WB":
                        $status = "INSIDE WASHBAY";
                        break;
                    case "WS_WAIT":
                        $status = "WAITING FOR WORKSHOP";
                        break;
                    case "IN_WS":
                        $status = "INSIDE WORKSHOP";
                        break;
                    case "SEC_WAIT":
                        $status = "WAITING FOR SECURITY OUT";
                        break;
                }
                $trucks24Arr[] = "<li><b>REGISTRATION NUMBER:</b> " . $rs[$i]["REGISTRATION_NUMBER"] . ", <b>STATUS:</b> " . $status . ", <b>LAST SCANNED BY:</b> " . $operator . ", <b>TOTAL TIME SINCE LAST SCAN:</b> " . $diffstr . "</li>";
                $trucks24IDArr[] = $rs[$i]["ID"];
            }
        }

        $trucks8Str = implode("", $trucks8Arr);
        $trucks24Str = implode("", $trucks24Arr);

        $mail = new mail();
        if (count($trucks8Arr) > 0) {
            $mail->setMailProps("8 Hour Warning", "Service Control", "HR");
            $mail->body = "Please note, <br><br>The following Truck(s) have not completed their service within 8h.<br>
            <ul>" . $trucks8Str . "</ul>";
            $mail->sendMail();

            if ($mail) {
                for ($i = 0; $i < count($trucks8IDArr); $i++) {
                    $exec = $db->Update("UPDATE `SCAN_FLEET_RECORDS` SET `FLAGGED_8` = '1' WHERE `ID` = '" . $trucks8IDArr[$i] . "'");

                    if(!$exec){
                        echo "Update failed: " . "UPDATE `SCAN_FLEET_RECORDS` SET `FLAGGED_8` = '1' WHERE `ID` = '" . $trucks8IDArr[$i] . "'";
                    }
                }
            }
        }

        if (count($trucks24Arr) > 0) {
            $mail->setMailProps("24 Hour Warning", "Service Control", "HR");
            $mail->body = "Please note, <br><br>The following Truck(s) have not completed their service within 24h.<br>
            <ul>" . $trucks24Str . "</ul>";
            $mail->AltBody = "Truck(s)<br>" . $trucks24Str . "<br>Have not completed their service within 24h.";
            $mail->sendMail();

            if ($mail) {
                for ($i = 0; $i < count($trucks24IDArr); $i++) {
                    $exec = $db->Update("UPDATE `SCAN_FLEET_RECORDS` SET `FLAGGED_24` = '1' WHERE `ID` = '" . $trucks24IDArr[$i] . "'");
                    
                    if(!$exec){
                        echo "Update failed: " . "UPDATE `SCAN_FLEET_RECORDS` SET `FLAGGED_24` = '1' WHERE `ID` = '" . $trucks24IDArr[$i] . "'";
                    }
                }
            }
        }

        return true;
    } catch (Exception $e) {
        return false;
    }
}

// function wrongtruck(String $oldTruckBarcode, String $driverBarcode, String $newTruckBarcode)
// {
//     if (!defined("NWP_IP2")) {
//         define("NWP_IP2", "41.76.208.147");
//         define("NWP_LOGIN_U2", "newtodme_NTNCode");
//         define("NWP_LOGIN_P2", "NTN2Code!@#");
//         define("NWP_DB2", "newtodme_newton_web_portal");
//     }
//     $db = new inductedDbClass(
//         NWP_IP2,
//         NWP_DB2,
//         NWP_LOGIN_U2,
//         NWP_LOGIN_P2
//     );

//     try {
//         $rs = $db->Select("SELECT `REGISTRATION_NUMBER` FROM `ASSETS` WHERE `NEWTON_BARCODE` = '$oldTruckBarcode'");
//         if ($rs && count($rs) > 0) {
//             $oldTruck = $rs["REGISTRATION_NUMBER"];
//         } else if ($rs && count($rs) == 0) {
//             exit("No records were found");
//         } else if (!$rs) {
//             exit("exe old truck error");
//         }

//         $rs = $db->Select("SELECT `REGISTRATION_NUMBER` FROM `ASSETS` WHERE `NEWTON_BARCODE` = '$newTruckBarcode'");
//         if ($rs && count($rs) > 0) {
//             $newTruck = $rs["REGISTRATION_NUMBER"];
//         } else if ($rs && count($rs) == 0) {
//             exit("No records were found");
//         } else if (!$rs) {
//             exit("exe new truck error");
//         }
//         $rs = $db->Select("SELECT `DRIVER_NAME`, `DRIVER_ID` FROM `EMPLOYEES` WHERE `NEWTON_BARCODE` = '$driverBarcode'");
//         if ($rs && count($rs) > 0) {
//             $driver = $rs["DRIVER_NAME"];
//             $driverID = $rs["DRIVER_ID"];
//         } else if ($rs && count($rs) == 0) {
//             exit("No records were found");
//         } else if (!$rs) {
//             exit("exe new truck error");
//         }

//         $mail = new mail();
//         $mail->setMailProps("Service Report", "Service Control", "HR");
//         //$mail->truckService($serviceID);
//         $mail->body = "Fail details:<br> <b> $driver id:$driverID</b> is currently in CLOCK IN satus with <b>$oldTruck</b> and is attempting to CLOCK IN on <b>$newTruck</b>.";
//         $mail->AltBody = "Fail details:$driver id:$driverID is currently in CLOCK IN satus with  $oldTruck and is attempting to CLOCK IN on $newTruck.";
//         $mail->sendMail();

//         echo "UM";
//     } catch (Exception $e) {
//         echo $e;
//     }
// }
