<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();
session_start();

$today = new DateTime();
$today->modify('+2 hours');
$current_date = $today->format('Y-m-d' . ' ' . 'H:i');

// Make sure user is logged in and file is uploaded
if (!isset($_SESSION['user_id'])) {
    echo "User not logged in.";
    exit;
}

if (!isset($_FILES['file'])) {
    echo "No file uploaded.";
    exit;
}

try {
    $type = $_POST['type'] ?? '';
    if ($type == "trainee") {

        $trainee_no = (int) $_POST['trainee_no'];
        $user_id = $_SESSION['user_id'];

        // Loop through uploaded files
        for ($i = 0; $i < $trainee_no; $i++) {

            // Check if file exists in the array
            if (!isset($_FILES['file']['tmp_name'][$i])) {
                echo "Missing file for trainee " . ($i + 1);
                continue;
            }

            // Validate file type
            if ($_FILES['file']['type'][$i] !== "image/png") {
                echo "Invalid file type for trainee " . ($i + 1) . ". Only PNG allowed.";
                continue;
            }

            // Set target file path
            $target_file = "../capture/signatures/trainee" . ($i + 1) . "-training-{$current_date}.png";

            // Move uploaded file
            if (move_uploaded_file($_FILES["file"]["tmp_name"][$i], $target_file)) {
                echo "File saved for trainee " . ($i + 1) . "<br>";
            } else {
                echo "Failed to move file for trainee " . ($i + 1) . "<br>";
            }
        }
    } else {
        echo "Invalid type.";
    }

    if ($type == "security") {
        // Optional: Validate the file type
        if ($_FILES["file"]["type"] !== "image/png") {
            echo "Invalid file type. Only PNG allowed.";
            exit;
        }

        // Move the uploaded file
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            echo "OK";
        } else {
            echo "Failed to move uploaded file.";
        }
    }

    if ($type == "visitor") {

        $visitor_no = $_POST['visitor_no'];
        $target_file = "../capture/signatures/visitor{$visitor_no}-training-{$current_date}.png";

        if (file_exists($target_file)) {
            $visitor_no++;
            $target_file = "../capture/signatures/visitor{$visitor_no}-training.png";
        } else {
            $target_file = "../capture/signatures/visitor{$visitor_no}-training.png";
        }

        // Optional: Validate the file type
        if ($_FILES["file"]["type"] !== "image/png") {
            echo "Invalid file type. Only PNG allowed.";
            exit;
        }

        // Move the uploaded file
        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            echo "OK";
        } else {
            echo "Failed to move uploaded file.";
        }
    }



    return 1;

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}