<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

$designation = new input();
$designation->type("text");
$designation->name("designation");
$designation->id("designation");
$designation->placeholder("Designation");

$name_surname = new input();
$name_surname->type("text");
$name_surname->name("name_surname");
$name_surname->id("name_surname");
$name_surname->placeholder("Name & Surname");

$date = new input();
$date->type("datetime-local");
$date->name("date");
$date->id("date");

$submit_btn = new button();
$submit_btn->class("submit_btn");
$submit_btn->value("Submit");
$submit_btn->onclick("employee_allergen_management()");
$submit_btn->id("submit_btn");


?>
<style>
    table,
    th,
    td {
        border: 2px solid black;
        border-collapse: collapse;
        padding: 5px;
    }
</style>
<div class="form_down">
    <h1>Employee Allergen Management</h1><br>

    <div style="text-align: justify; width: 80%;">
        <p> The Management and Employees of Lowveld Nuts (Pty) Ltd are committed to providing products that meet all
            our customer’s dietary requirements.
            Lowveld Nuts understands the increasing prevalence of life-threatening allergies among the population
            and recognizing that the risk of accidental exposure to allergens can be reduced.
            <br><br>
            Allergens identified on the manufacturing site for Lowveld Nuts: Tree nuts (Macadamia Nuts)
        </p>
        <img src="../images/mac_nuts.png" alt="macadamia nuts" style="width: 10vw;">
        <p>Lowveld Nuts is committed to working in cooperation with customers, suppliers, and staff, to minimize risks
            and provide safe products for all its consumers. </p>
        <p>The focus of allergy management shall be on prevention, education, awareness and communication. </p>
        <p>The goals for allergy management include:</p>
        <ul>
            <li>To define a formal process for identifying, managing, and ensuring continuity of processing of all
                products. These procedures shall be outlined in detail and form part of the food safety management
                system.</li>
            <li>To ensure all product development will actively remove or avoid the use of allergens and other products
                that are a concern to our customer’s.</li>
            <li>To ensure the minimal risk of cross contamination, suitable controls and standards will be in place.
            </li>
        </ul>
        <p>To achieve this, we require everyone to strive constantly to improve the quality of the nuts and services we
            supply.</p>
        <p> We will maintain a close monitoring procedure made up of daily and weekly checks, overseen by an internal
            monthly audit system. </p>
        <p>It is the aim of the company to strive for continuous improvement across all areas in everything we do. This
            will be done by providing adequate resources and training a periodical review of the Allergen Management
            System to determine continued adequacy, suitability and effectiveness.</p>
        <p>All employees, contractors and visitors working and walking on the Lowveld Nuts Processing site, shall not be
            allowed to bring in or consume any food that contain the following allergens: </p>

    </div>

    <div style="display: flex; flex-direction: row; align-items: center; width: 50%; justify-content: space-around;">
        <div>
            <p><b>Peanuts</b></p>
        </div>
        <div>
            <img src="../images/peanuts.png" alt="peanuts" style="width: 10vw;">
        </div>
    </div>
    <br>

    <p style="width: 80%;text-align: justify;">Employees working inside the processing (food handlers & operational
        staff) facility shall not be allowed to bring and consume food that contain the following allergens:</p>

    <table style="width:80%">
        <tr>
            <td>
                SOY
            </td>
            <td>
                <img src="../images/soy_beans.png" alt="soy beans" style="width: 10vw;">
            </td>
        </tr>
        <tr>
            <td>
                COW'S MILK
            </td>
            <td>
                <img src="../images/cow_milk.png" alt="cow's milk" style="width: 10vw;">
            </td>
        </tr>
        <tr>
            <td>
                WHEAT
            </td>
            <td>
                <img src="../images/wheat.png" alt="wheat" style="width: 10vw;">
            </td>
        </tr>
        <tr>
            <td>
                SHELLFISH
            </td>
            <td>
                <img src="../images/shellfish.png" alt="shellfish" style="width: 10vw;">
            </td>
        </tr>
        <tr>
            <td>
                EGGS
            </td>
            <td>
                <img src="../images/eggs.png" alt="eggs" style="width: 10vw;">
            </td>
        </tr>
        <tr>
            <td>
                FISH
            </td>
            <td>
                <img src="../images/fish.png" alt="fish" style="width: 10vw;">
            </td>
        </tr>
    </table>

    <br>

    <div style="text-align: justify; width: 80%;">
        <p>
            The use of Cow’s Milk in canteens shall be provided by the company and controlled. Staff will only be
            allowed to eat and drink in their underclothes and will follow normal hygiene protocols as stipulated by the
            company before entering the facility.
        </p>
        <p>
            No PPE shall be allowed to be stored in personal lockers.
        </p>
        <p>
            Random allergen swabbing shall be done based on risk as identified on the company’s hazard & risk
            assessment.
        </p>
        <p>
            Security at the gate shall assist with the monitoring of food brought onto site as to control the risk off
            unintended cross contamination.
        </p>
        <p>
            By signing this document, you acknowledge this policy and agree to adhere to its content:
        </p>
    </div>

    <br>

    <table style="width: 80%">
        <tr>
            <th>Designation</th>
            <th>Name & Surname</th>
            <th>Signature</th>
            <th>Date</th>
        </tr>
        <tr>
            <td>
                <?php
                $designation->add();
                ?>
            </td>
            <td>
                <?php
                $name_surname->add();
                ?>
            </td>
            <td>
                <canvas id="designation_signature" name="designation_signature" class="signature-pad" width=400
                    height=100 style='background-color:lightgrey;border-radius:20px;'></canvas>
            </td>
            <td>
                <?php
                $date->add();
                ?>
            </td>
        </tr>
    </table>

    <br>

    <?php
    $submit_btn->add();
    ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js"></script>

<script>
    var designation_canvas = document.getElementById('designation_signature');
    var designation_pad = new SignaturePad(designation_canvas);

    var designation = document.getElementById('designation').value;

        document.getElementById('submit_btn').addEventListener('click', function () {
        if (designation_pad.isEmpty()) {
            alert("Please provide signature");
        } else {
            var dataURL = designation_pad.toDataURL('image/png');
            var blob = dataURLToBlob(dataURL);
            var formData = new FormData();
            formData.append('file', blob, 'signature.png');
            formData.append('type', 'designation');

            var xhr = new XMLHttpRequest();
            xhr.open("POST", "../policy/upload_signature.php", true);
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    // alert(xhr.responseText); // Handle the server response
                    if (xhr.responseText.indexOf("OK") > 1) {
                        // repload page
                        // location.reload();
                        console.log("Signature saved successfully.");

                    } else {
                        alert(xhr.responseText);
                    }
                }
            };
            xhr.send(formData);
        }
    });

</script>

<?php

$today = new DateTime();
$today->modify('+2 hours');
$current_date = $today->format('Y-m-d' . ' ' . 'H:i');

$ajax = new js_ajax();
$ajax->function_name("employee_allergen_management");
$ajax->insert("documentation");
$ajax->add_column_and_value("date_time={$current_date}");
$ajax->redirect("allergen_management.pdf.php?record_id={$_GET['record_id']}");
$ajax->on_success("Allergen Management documentation saved");