<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

$no_of_mjs = $db->query("maintenance_request","SELECT * FROM maintenance_request");
if($no_of_mjs->num_rows > 0){
    $jobcard_number = $no_of_mjs->num_rows + 1;
    //get jobcard_id and add 1
    $jc_no = "MJC" . str_pad($jobcard_number, 3, '0', STR_PAD_LEFT);
}else{
    $jc_no = "MJC001";
}

// Date & Time (+2hrs)
$datetime = new DateTime();
$datetime->modify('+2 hours');
$current_datetime = $datetime->format('Y-m-d H:i');

// Hidden input for date
$date_time_created = new input();
$date_time_created->type("hidden");
$date_time_created->name("date_time_created");
$date_time_created->id("date_time_created");
$date_time_created->value($current_datetime);

// Job Card Number
$job_card_id = new input();
$job_card_id->type("text");
$job_card_id->name("jobcard_id");
$job_card_id->id("jobcard_id");
$job_card_id->value($jc_no);
$job_card_id->readonly();

$job_card_label = new label();
$job_card_label->for("job_card_id");
$job_card_label->value("Job Card Number");

// Date Label
$date_requested_label = new label();
$date_requested_label->for("date_requested_label");
$date_requested_label->value("Date & Time of Request");

$date_requested = new input();
$date_requested->type("datetime-local");
$date_requested->name("date_requested");
$date_requested->id("date_requested");

// Requested By
$requested_by = new input();
$requested_by->type("text");
$requested_by->name("requested_by");
$requested_by->id("requested_by");

$requested_by_label = new label();
$requested_by_label->for("requested_by");
$requested_by_label->value("Requested By");

// Department Dropdown
$department = new select();
$department->name("department");
$department->id("department");
$department->add_option("Quality / Food Safety", "Quality / Food Safety");
$department->add_option("Production", "Production");
$department->add_option("Maintenance", "Maintenance");
$department->add_option("Management", "Management");
$department->add_option("Contractor", "Contractor");

$department_label = new label();
$department_label->for("department");
$department_label->value("Department");

// Equipment
$equipment_name = new input();
$equipment_name->type("text");
$equipment_name->name("equipment_name");
$equipment_name->id("equipment_name");
$equipment_name->placeholder("E.g. Conveyor Belt #3");

$equipment_label = new label();
$equipment_label->for("equipment_name_label");
$equipment_label->value("Equipment Name");

$equipment_id_label = new label();
$equipment_id_label->for("equipment_id_label");
$equipment_id_label->value("Equipment ID");

$equipment_id = new input();
$equipment_id->type("text");
$equipment_id->name("equipment_id");
$equipment_id->id("equipment_id");
$equipment_id->placeholder("E.g. EQ-0245");

// Location
$location = new input();
$location->type("text");
$location->name("location");
$location->id("location");
$location->placeholder("E.g. Packaging Line B, Clean Room 2");

$location_label = new label();
$location_label->for("location_label");
$location_label->value("Location");

// Fault Reported
$fault_reported = new input();
$fault_reported->type("text");
$fault_reported->name("faulty_reported");
$fault_reported->id("faulty_reported");
$fault_reported->placeholder("Clear and concise explanation of the problem...");
$fault_reported->style("width: 50%;");

$fault_label = new label();
$fault_label->for("fault_reported_label");
$fault_label->value("Fault Reported / Issue Description");

// Symptoms
$symptoms = new input();
$symptoms->type("text");
$symptoms->name("symptoms_observed");
$symptoms->id("symptoms_observed");
$symptoms->placeholder("Noises, smells, visual cues...");
$symptoms->style("width: 50%;");

$symptoms_label = new label();
$symptoms_label->for("symptoms_label");
$symptoms_label->value("Symptoms Observed");

// Impact
$impact = new select();
$impact->name("impact_on_production");
$impact->id("impact_on_production");
$impact->add_option("Minor delay", "Minor delay");
$impact->add_option("Line stopped", "Line stopped");
$impact->add_option("Contamination risk", "Contamination risk");

$impact_label = new label();
$impact_label->for("impact_label");
$impact_label->value("Impact on Production");

// Priority
$priority = new select();
$priority->name("priority_level");
$priority->id("priority_level");
$priority->add_option("Critical", "Critical");
$priority->add_option("High", "High");
$priority->add_option("Medium", "Medium");
$priority->add_option("Low", "Low");

$priority_label = new label();
$priority_label->for("priority_label");
$priority_label->value("Priority Level_label");

// Additional Notes
$notes = new input();
$notes->type("text");
$notes->name("additional_notes");
$notes->id("additional_notes");
$notes->style("width:80%");

$notes_label = new label();
$notes_label->for("notes_label");
$notes_label->value("Additional Notes");

$status = new input();
$status->type("hidden");
$status->name("status");
$status->id("status");
$status->value("REQUESTED");

// Submit Button
$priority_btn = new button();
$priority_btn->class("submit_btn");
$priority_btn->value("PRIORITY GUIDE");
$priority_btn->onclick("open_Popup()");

// Submit Button
$submit_btn = new button();
$submit_btn->class("submit_btn");
$submit_btn->value("SUBMIT");
$submit_btn->onclick("submit_request()");
?>

<div class="form_down">

    <style>
        .priority_popup {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
        }

        .priority_content {
            /* background-color: #004aad */
            background-color: #528edf;
            margin: 3% auto;
            padding: 20px;
            border-radius: 10px;
            width: 80%;
            height: 85%;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
            position: relative;
            overflow-y: scroll;
        }

        .close-btn {
            position: absolute;
            top: 10px;
            right: 15px;
            font-weight: bolder;
            font-size: 5vw;
            cursor: pointer;
            color: white;
        }

        .close-btn {
            position: absolute;
            top: 10px;
            right: 15px;
            font-weight: bolder;
            font-size: 5vw;
            cursor: pointer;
            color: white;
        }

        table {
            width: 95%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 10px;
            border: 3px solid black;
            text-align: left;
            background-color: white;
        }
    </style>
    <h1>Maintenance Request Document</h1>

    <?php
    $date_time_created->add();

    $job_card_label->add();
    $job_card_id->add();
    $date_requested_label->add();
    $date_requested->add();

    ?>

    <div style="display: flex; flex-direction: row; width: 40%; justify-content: space-evenly">
        <div style="display: flex; flex-direction: column;">
            <?php
            $requested_by_label->add();
            $requested_by->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $department_label->add();
            $department->add();
            ?>
        </div>
    </div>

    <div style="display: flex; flex-direction: row; width: 40%; justify-content: space-evenly">
        <div style="display: flex; flex-direction: column;">
            <?php
            $equipment_label->add();
            $equipment_name->add();
            ?>
        </div>
        <div style="display: flex; flex-direction: column;">
            <?php
            $equipment_id_label->add();
            $equipment_id->add();
            ?>
        </div>
    </div>
    <?


    $location_label->add();
    $location->add();

    $fault_label->add();
    $fault_reported->add();
    $symptoms_label->add();
    $symptoms->add();
    $impact_label->add();
    $impact->add();
    $priority_label->add();
    $priority->add();

    $priority_btn->add();

    $notes_label->add();
    $notes->add();
    $status->add();

    $submit_btn->add();
    ?>
    <div id="priority_popup" class="priority_popup">
        <div class="priority_content">
            <span class="close-btn" onclick="close_Popup()">&times;</span>
            <h2>PRIORITY GUIDE</h2>

            <table>
                <tr>
                    <th style="color: #bd0303;">CRITICAL PRIORITY</th>
                </tr>
                <tr>
                    <td>Equipment failure causing a full production line stop.</td>
                </tr>
                <tr>
                    <td>
                        Issue compromising food safety, such as a contaminant leak, failed temperature control, or
                        allergen cross-contact.
                    </td>
                </tr>
                <tr>
                    <td>Electrical or mechanical hazard risking injury or fire.</td>
                </tr>
                <tr>
                    <td>Response Time: Immediately (within 30 minutes to 1 hour)</td>
                </tr>
            </table>

            <br>

            <table>
                <tr>
                    <th style="color: red;">HIGH PRIORITY</th>
                </tr>
                <tr>
                    <td>Worn conveyor belt that’s still operating but near failure.</td>
                </tr>
                <tr>
                    <td>Temperature deviation in non-CCP refrigeration.</td>
                </tr>
                <tr>
                    <td>Faulty sensors affecting quality control but not safety.</td>
                </tr>
                <tr>
                    <td>Minor leaks near food processing areas.</td>
                </tr>
                <tr>
                    <td>Response Time: Within 2–4 hours</td>
                </tr>
            </table>

            <br>

            <table>
                <tr>
                    <th style="color: orange;">MEDIUM PRIORITY</th>
                </tr>
                <tr>
                    <td>Worn conveyor belt that’s still operating but near failure.</td>
                </tr>
                <tr>
                    <td>Temperature deviation in non-CCP refrigeration.</td>
                </tr>
                <tr>
                    <td>Faulty sensors affecting quality control but not safety.</td>
                </tr>
                <tr>
                    <td>Minor leaks near food processing areas.</td>
                </tr>
                <tr>
                    <td>Response Time: Within 2–4 hours</td>
                </tr>
            </table>

            <br>
            <table>
                <tr>
                    <th style="color: green;">LOW PRIORITY</th>
                </tr>
                <tr>
                    <td>Worn conveyor belt that’s still operating but near failure.</td>
                </tr>
                <tr>
                    <td>Temperature deviation in non-CCP refrigeration.</td>
                </tr>
                <tr>
                    <td>Faulty sensors affecting quality control but not safety.</td>
                </tr>
                <tr>
                    <td>Minor leaks near food processing areas.</td>
                </tr>
                <tr>
                    <td>Response Time: Within 2–4 hours</td>
                </tr>
            </table>

        </div>
    </div>
</div>

<style>
    .priority_popup {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
    }

    .priority_content {
        /* background-color: #004aad */
        background-color: #528edf;
        margin: 3% auto;
        padding: 20px;
        border-radius: 10px;
        width: 80%;
        height: 85%;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
        position: relative;
        /* overflow-y: scroll; */
    }

    .close-btn {
        position: absolute;
        top: 10px;
        right: 15px;
        font-weight: bolder;
        font-size: 5vw;
        cursor: pointer;
        color: white;
    }
</style>

<script>

    function open_Popup() {
        document.getElementById("priority_popup").style.display = "block";
    }

    function close_Popup() {
        document.getElementById("priority_popup").style.display = "none";
    }
    
</script>

<?php
// AJAX submission
$ajax = new js_ajax();
$ajax->function_name("submit_request");
$ajax->insert("maintenance_request");
$ajax->add_column_and_value("status=");
$ajax->on_success("REQUEST CAPTURED SUCCESSFULLY");
$ajax->redirect("../maintenance/request_maintenance.php");
?>