<?php include "../../root.class.php";
$html = new html();
$db = new db_safeguard();
$html->add_styles_page();

// Maintenance type
$maintenance_label = new label();
$maintenance_label->for("maintenance_type");
$maintenance_label->value("Please select the maintenance type");

$maintenance_type = new select();
$maintenance_type->id("maintenance_type");
$maintenance_type->name("maintenance_type");
$maintenance_type->add_option("Corrective", "Corrective (Breakdown repair)");
$maintenance_type->add_option("Preventive", "Preventive (Scheduled servicing)");
$maintenance_type->add_option("Predictive", "Predictive (Based on sensor/condition monitoring)");
$maintenance_type->add_option("Emergency", "Emergency");

// Lockout/Tagout
$loto_label = new label();
$loto_label->for("loto_required_label");
$loto_label->value("Lockout/Tagout (LOTO) Required");

$loto_select = new select();
$loto_select->id("loto_required");
$loto_select->name("loto_required");
$loto_select->add_option("Yes", "Yes");
$loto_select->add_option("No", "No");

// Sanitation
$sanitation_label = new label();
$sanitation_label->for("sanitation_required_label");
$sanitation_label->value("Sanitation Requirements (Cleaning needed before/after maintenance)");

$sanitation_select = new select();
$sanitation_select->id("sanitation_required");
$sanitation_select->name("sanitation_required");
$sanitation_select->add_option("Yes", "Yes");
$sanitation_select->add_option("No", "No");

// PPE
$ppe_label = new label();
$ppe_label->for("ppe_required");
$ppe_label->value("PPE Required");

$ppe_select = new select();
$ppe_select->id("ppe_required");
$ppe_select->name("ppe_required");
$ppe_select->add_option("Yes", "Yes");
$ppe_select->add_option("No", "No");
$ppe_select->onchange("ppe()");

// Allergen
$allergen_label = new label();
$allergen_label->for("allergen_risk");
$allergen_label->value("Allergen or Contamination Risk");

$allergen_select = new select();
$allergen_select->id("allergen_risk");
$allergen_select->name("allergen_risk");
$allergen_select->add_option("Yes", "Yes");
$allergen_select->add_option("No", "No");

// Spare parts
$spare_parts_label = new label();
$spare_parts_label->for("spare_parts");
$spare_parts_label->value("Spare Parts Required");

$spare_parts_input = new input();
$spare_parts_input->id("spare_parts");
$spare_parts_input->name("spare_parts");
$spare_parts_input->type("text");
$spare_parts_input->style("width:80%;");

// Special tools
$tools_label = new label();
$tools_label->for("special_tools");
$tools_label->value("Special Tools Required");

$tools_input = new input();
$tools_input->id("special_tools");
$tools_input->name("special_tools");
$tools_input->type("text");
$tools_input->style("width:80%;");

// Technician
$tech_label = new label();
$tech_label->for("technician");
$tech_label->value("Technician(s) Assigned");

$tech_select = new select();
$tech_select->id("technician_assigned");
$tech_select->name("technician_assigned");
$tech_select->add_option("Staff1", "Staff 1");
$tech_select->add_option("Staff2", "Staff 2");

// Time to complete
$time_label = new label();
$time_label->for("time_to_complete");
$time_label->value("Estimated Time to Complete");

$time_select = new select();
$time_select->id("time_to_complete");
$time_select->name("time_to_complete");
$time_select->add_option("24 hours", "24 hours");
$time_select->add_option("48 hours", "48 hours");
$time_select->add_option("1 week", "1 week");
$time_select->add_option("Other", "Other");
$time_select->onchange("check_time()");

$other_time = new input();
$other_time->id("other_estimated_times");
$other_time->name("other_estimated_times");
$other_time->type("text");
$other_time->placeholder("Estimated Time");
// $other_time->style("width:20%;");

$all_ppe_options = new input();
$all_ppe_options->id("all_ppe_options");
$all_ppe_options->name("all_ppe_options");
$all_ppe_options->type("text");
$all_ppe_options->style("display:none;");

$submit_btn = new input();
$submit_btn->class("submit_btn");
$submit_btn->value("Submit");
$submit_btn->onclick("mainten_allocation()");

?>

<div class="form_down">
    <h1>Allocate Maintenance</h1>
    <?php
    $maintenance_label->add();
    $maintenance_type->add();
    $loto_label->add();
    $loto_select->add();
    $sanitation_label->add();
    $sanitation_select->add();

    $ppe_label->add();
    $ppe_select->add();

    $ppe_options = array("Cut-resistant gloves", "Nitrile gloves", "Hair Nets / Caps", "Hard Hats", "Safety glasses", "Goggles", "Earplugs", "Dust masks", "Steel-toed boots", "Coveralls", "Face mask", "Other");

    $ppe_descriptions = array("for sharp objects.", "for chemical handling.", "Protect against head injuries from falling objects.", "Prevent hair from contaminating food products.", "Shield eyes from flying debris and chemicals.", "Provide a seal around eyes for protection against splashes.", "Reduce noise exposure in loud environments.", "Suitable for protection against non-toxic dust.", "Protect against heavy objects and punctures.", "Protect against chemicals and contaminants.", "Reduce the risk of airborne contaminants.");

    ?>

    <div id="ppe_allergens" style="display:none; flex-direction: column;">
        <h3>Allergen/Contamination Risk</h3>
        <table style="width: 100%;">
            <tr>
                <td style="width:50%; vertical-align: top;">
                    <?php
                    $i = 0;
                    foreach ($ppe_options as $option) {
                        if ($i < sizeof($ppe_options) / 2) {
                            if ($option == "Other") {
                                echo "<div><input type=\"checkbox\" name=\"ppe_options[]\" id=\"" . $option . "\" value=\"{$option}\" style=\"width:2vw; height:2vw;\" onclick=\"ppe_other(),get_checked_values()\"> <span style=\"margin-left: 1vw;font-weight: bold;\">{$option}</span> <span>{$ppe_descriptions[array_search($option, $ppe_options)]}</span><br></div>";
                            } else {
                                echo "<div><input type=\"checkbox\" name=\"ppe_options[]\" id=\"" . $option . "\" value=\"{$option}\" style=\"width:2vw; height:2vw;\" onclick=\"get_checked_values()\"> <span style=\"margin-left: 1vw;font-weight: bold;\">{$option}</span> <span>{$ppe_descriptions[array_search($option, $ppe_options)]}</span><br></div>";
                            }
                        }
                        $i++;
                    }
                    ?>
                </td>
                <td style="width:50%; vertical-align: top;">
                    <?php
                    $i = 0;
                    foreach ($ppe_options as $option) {
                        if ($i >= sizeof($ppe_options) / 2) {
                            if ($option == "Other") {
                                echo "<div><input type=\"checkbox\" name=\"ppe_options[]\" id=\"" . $option . "\" value=\"{$option}\" style=\"width:2vw; height:2vw;\" onclick=\"ppe_other(),get_checked_values()\"> <span style=\"margin-left: 1vw;font-weight: bold;\">{$option}</span> <span>{$ppe_descriptions[array_search($option, $ppe_options)]}</span><br></div>";
                            } else {
                                echo "<div><input type=\"checkbox\" name=\"ppe_options[]\" id=\"" . $option . "\" value=\"{$option}\" style=\"width:2vw; height:2vw;\" onclick=\"get_checked_values()\"> <span style=\"margin-left: 1vw;font-weight: bold;\">{$option}</span> <span>{$ppe_descriptions[array_search($option, $ppe_options)]}</span><br></div>";
                            }
                        }
                        $i++;
                    }
                    ?>
                </td>
            </tr>
        </table>
        <div id="other_ppe_requirements" style="display:none;">
            <input class="inputs" type="text" name="other_ppe" id="other_ppe" placeholder="Other">
        </div>
    </div>

    <?php
    $all_ppe_options->add();
    $allergen_label->add();
    $allergen_select->add();

    $spare_parts_label->add();
    $spare_parts_input->add();
    $tools_label->add();
    $tools_input->add();
    $tech_label->add();
    $tech_select->add();
    $time_label->add();
    $time_select->add();

    ?>

    <div id="other_estimated_time" style="display:none;">
        <?php
        $other_time->add();
        ?>
    </div>

    <?php

    $submit_btn->add();
    ?>
</div>

<script>
    function check_time() {
        var time_to_complete = document.getElementById('time_to_complete').value;

        if (time_to_complete == "Other") {
            document.getElementById("other_estimated_time").style.display = "flex";
        } else {
            document.getElementById("other_estimated_time").style.display = "none";
        }
    }

    function ppe() {
        var ppe_required = document.getElementById('ppe_required').value;
        if (ppe_required == "Yes") {
            document.getElementById("ppe_allergens").style.display = "flex";
        } else {
            document.getElementById("ppe_allergens").style.display = "none";
        }
    }

    function ppe_other() {
        var ppe_other = document.getElementById('Other').checked;
        if (ppe_other == true) {
            document.getElementById("other_ppe_requirements").style.display = "flex";
        } else {
            document.getElementById("other_ppe_requirements").style.display = "none";
        }
    }

    function get_checked_values() {
        i = 0;
        var ppe_options = [];
        var ppe_allergens = document.getElementsByName('ppe_options[]');
        for (var i = 0; i < ppe_allergens.length; i++) {
            if (ppe_allergens[i].checked) {
                ppe_options.push(ppe_allergens[i].value);
            }
        }
        document.getElementById('all_ppe_options').value = ppe_options.join(', ');
    }
</script>

<?php
$date = date("Y-m-d H:i", strtotime("+2 Hours"));

$ajax = new js_ajax();
$ajax->function_name("mainten_allocation");
$ajax->insert("maintenance_allocation");
$ajax->on_success("");
$ajax->redirect("");