<?php

include '../../fpdf.php';
include "../../root.class.php";
$functions = new functions();
$total_stock_value = 0.00;
$db = new db_safeguard();

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('P');

$pdf->SetFont('Arial', 'B', 15);
$pdf->Cell(95, 5, "DIESEL ORDER REPORT", "B", 1, 'L');
$logo_file_check = $db->query("companies", "SELECT * FROM companies WHERE record_id = {$_SESSION['company_id']}");
if ($logo_file_check->num_rows > 0) {
    $logo_file = "../company/logos/" . $logo_file_check->fetch_assoc()['logo_file'];
} else {
    $logo_file = "../../icons/logo.png";
}
$pdf->Image($logo_file, 165, 5, 35, 21);
$pdf->Cell(50, 15, "", "", 1, 'L');

$pdf->SetFont('Arial', '', 5);

$pdf->SetFont('Arial', 'B', 7);
$pdf->Cell(23, 5, "STATUS", "BR", 0, 'L');
$pdf->Cell(15, 5, "ORDER ID", "BR", 0, 'L');
$pdf->Cell(35, 5, "ASSET", "BR", 0, 'L');
$pdf->Cell(35, 5, "ODO", "BR", 0, 'L');
$pdf->Cell(35, 5, "USER", "BR", 0, 'L');
$pdf->Cell(25, 5, "OPENED", "BR", 0, 'L');
$pdf->Cell(25, 5, "CLOSED", "BR", 0, 'L');
$pdf->Cell(20, 5, "AMOUNT", "BR", 0, 'L');
$pdf->Cell(20, 5, "TANK", "BR", 0, 'L');

$pdf->Ln();
$pdf->SetFont('Arial', '', 5);
$data = $_GET['where_data'];

$latest_orders_res = $db->query("fuel_movement", "SELECT * FROM fuel_movement WHERE $data ORDER BY record_id DESC");
$total_amount = 0;
$transactions_total = 0;
while ($latest_orders = $latest_orders_res->fetch_assoc()) {
    $pdf->Cell(23, 5, $latest_orders['status'], 0, 0, 'L');
    $pdf->Cell(15, 5, $latest_orders['order_id'], 0, 0, 'L');
    $pdf->Cell(35, 5, $functions->get_asset_name($latest_orders['asset_id']), 0, 0, 'L');
    $pdf->Cell(35, 5,$latest_orders['odo'], 0, 0, 'L');
    $pdf->Cell(35, 5, $functions->get_username($latest_orders['user_id']), 0, 0, 'L');
    $pdf->Cell(25, 5, $latest_orders['date_time_opened'], 0, 0, 'L');
    $pdf->Cell(25, 5, $latest_orders['date_time_closed'], 0, 0, 'L');
    $pdf->Cell(20, 5, ($latest_orders['amount'] / 1000) . " L", 0, 0, 'L');
    $total_amount += $latest_orders['amount'];
    $pdf->Cell(20, 5, $functions->get_tank_name($latest_orders['tank_id']), 0, 1, 'L');
    $transactions_total++;

}
$pdf->SetFont('Arial', 'B', 7);

$pdf->Cell(20, 8, "", "", 1, 'L');
$pdf->Cell(20, 5, "TOTAL", "TR", 0, 'L');
$pdf->Cell(20, 5, ($total_amount / 1000) . " L", "TR", 0, 'L');
$pdf->Cell(20, 5, $transactions_total, "TR", 1, 'L');

$pdf->Output("I");