<?php

use App\Models\Site;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tanks', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Site::class);
            $table->string('name');
            $table->string('receive_arduino_serial');
            $table->string('dispense_arduino_serial');
            $table->unique(['site_id', 'name']);
            $table->unique(['site_id', 'receive_arduino_serial']);
            $table->unique(['site_id', 'dispense_arduino_serial']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tanks');
    }
};
