<?php
include 'db.class.php';

$db = new Database();


function postEncryptedRequest($url, $postData)
{
    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_TIMEOUT, 10);

    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($curl, CURLOPT_POSTFIELDS, $postData);

    // Enable SSL verification 
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);

    $response = curl_exec($curl);
    curl_close($curl);

    // Process the response
    $statusCode = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);
    if ($statusCode == 200) {
        $responseData = $response;
        // Perform further processing of the encrypted string
        return $responseData;
    } else {
        throw new Exception("Failed to complete request: {$statusCode}");
    }
}

$postData = 'client_code=LVNT';

try {
    $encryptionKey = postEncryptedRequest('https://encryption.elegantwork.co.za', $postData);
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage();
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <script src="https://cdn.jsdelivr.net/npm/jquery"></script>
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Slab:wght@100..900&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: "Monsterrat", sans-serif;
            margin: 0;
            display: flex;
            min-height: 100vh;
            padding: 0;
            background-color: none;
            color: #3C6E59;
            flex-direction: column;
            align-content: center;
            justify-content: flex-start;
            align-items: center;
        }

        header {
            text-align: center;
            margin-bottom: 20px;
            padding: 20px;
            border-bottom: 1px solid #ccc;
            background-color: #f5f5f5;
        }

        section {
            max-width: fit-content;
            margin: 0 auto;
            border: 5px solid #3C6E59;
            display: flex;
            padding: 20px;
            flex-direction: column;
            flex-wrap: nowrap;
            align-content: center;
            background-color: whitesmoke;
            justify-content: flex-start;
            align-items: center;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        label {
            font-weight: bold;
            margin-bottom: 5px;
        }


        input {
            width: 100%;
            font-size: 1em;
            padding: 10px;
            border: 0px;
            border-bottom: 1px solid #87553c;
            /* border-radius: 5px; */
            box-sizing: border-box;
            background-color: #fff;
        }

        button {
            background-color: #87553c;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            width: 80%;
            cursor: pointer;
        }

        /* Mobile styles */
        @media screen and (max-width: 768px) {
            section {
                padding: 10px;
            }

            form label {
                font-size: smaller;
            }

            input[type='date'],
            input[type='datetime-local'] {
                width: 100%;
                padding: 8px;
                margin-bottom: 10px;
            }
        }

        .hide {
            display: none;
        }

        .show {
            display: block;
        }

        #loadingPopup {
            position: fixed;
            z-index: 100;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
            border: 3px solid #3C6E59;
            padding: 20px;
            background-color: white;
            border-radius: 8px;
            opacity: 0;
            transition: opacity 0.3s ease-in-out;
        }

        #loadingBackground {
            top: 0;
            left: 30%;
            width: 40%;
            position: fixed;
            height: 100%;
            background-color: rgb(0 0 0 / 96%);
            z-index: 172;
            flex-direction: column;
            flex-wrap: nowrap;
            align-content: center;
            justify-content: center;
            align-items: center;
        }

        #loadingPopup.show {
            opacity: 1;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        th {
            font-size: 1em;
            background-color: #f2f2f2;
        }

        tr:nth-child(even) {
            background-color: #eee;
        }

        .responsive {
            @media only screen and (max-width: 768px) {
                td {
                    width: 100% !important;
                }
            }
        }
    </style>
</head>

<body>
    <section>
        <button type="submit" onclick="exportToExcel()">EXCEL</button>
        <br>
        <table id="table_data">
            <thead>
                <tr>
                    <td>NAME</td>
                    <td>SURNAME</td>
                    <td>PHONE</td>
                    <td>EMAIL</td>
                    <td>COMPANY</td>
                    <td>REGISTERED</td>
                    <td>ATTENDED</td>
                </tr>
            </thead>
            <tbody>
                <?php
                $res = $db->query("SELECT * FROM contact WHERE 1 ORDER BY record_id DESC");
                $rows = $res->fetchAll();
                foreach ($rows as $row) {
                    echo '<tr>';
                    echo '<td>' . openssl_decrypt($row[1], 'aes-256-cbc', $encryptionKey) . '</td>';
                    echo '<td>' . openssl_decrypt($row[2], 'aes-256-cbc', $encryptionKey) . '</td>';
                    echo '<td>' . openssl_decrypt($row[3], 'aes-256-cbc', $encryptionKey) . '</td>';
                    echo '<td>' . openssl_decrypt($row[4], 'aes-256-cbc', $encryptionKey) . '</td>';
                    echo '<td>' . openssl_decrypt($row[5], 'aes-256-cbc', $encryptionKey) . '</td>';
                    echo '<td>' . $row[6] . '</td>';
                    echo '<td>' . $row[8] . '</td>';
                    echo '</tr>';
                }
                ?>
            </tbody>
        </table>
    </section>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.3.2/jspdf.umd.min.js"></script>
    <script>
        function exportToExcel() {
            // Get table element
            let table = document.getElementById("table_data");

            // Columns to exclude
            let excludeColumns = ["ACTIONS"]; // Add more column headers if needed

            // Clone table to manipulate without affecting original
            let cloneTable = table.cloneNode(true);

            // Get all headers
            let headers = cloneTable.querySelectorAll("th");

            // Determine index of columns to remove
            let removeIndexes = [];
            headers.forEach((th, index) => {
                if (excludeColumns.includes(th.innerText.trim())) {
                    removeIndexes.push(index);
                }
            });

            // Remove cells under excluded columns
            let rows = cloneTable.querySelectorAll("tr");
            rows.forEach(row => {
                removeIndexes.slice().reverse().forEach(idx => {
                    if (row.children[idx]) row.removeChild(row.children[idx]);
                });
            });

            // Convert modified table to worksheet
            let wb = XLSX.utils.table_to_book(cloneTable, { sheet: "sheet" });

            // Export to Excel
            XLSX.writeFile(wb, "lowveld_nuts_report.xlsx");
        }



    </script>

    <script src="https://cdn.jsdelivr.net/npm/xlsx/dist/xlsx.full.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.8.1/jspdf.plugin.autotable.min.js"></script>
</body>

</html>