<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();

$received_from_label = new label();
$received_from_label->for('received_from_label');
$received_from_label->value('Received From');

$received_from = new input();
$received_from->type('text');
$received_from->class('inputs');
$received_from->name('received_from');
$received_from->id('received_from');
$received_from->placeholder('Received From');

$type_label = new label();
$type_label->for('type');
$type_label->value('Consumable Type');

$type = new select();
$type->class('inputs');
$type->name('type');
$type->id('type');
$type->add_option(' ', 'TYPE');
$type->add_option('DRILLING', 'DRILLING');
$type->add_option('CASING', 'CASING');

$quantity = new input();
$quantity->type('number');
$quantity->class('inputs');
$quantity->name('quantity');
$quantity->id('quantity');
$quantity->placeholder('Quantity');

$start_odo = new input();
$start_odo->type('number');
$start_odo->class('inputs');
$start_odo->name('start_odo');
$start_odo->id('start_odo');
$start_odo->placeholder('Start ODO');

$odo_after = new input();
$odo_after->type('number');
$odo_after->class('inputs');
$odo_after->name('odo_after');
$odo_after->id('odo_after');
$odo_after->placeholder('ODO After');

$received_by_label = new label();
$received_by_label->for('received_by_label');
$received_by_label->value('Received By');

$received_by = new input();
$received_by->type('text');
$received_by->class('inputs');
$received_by->name('received_by');
$received_by->id('received_by');
$received_by->placeholder('Received By');

$start_label = new label();
$start_label->for('start_odo');
$start_label->value('START ODO');

$start_odo_image = new file_upload();
$start_odo_image->class('inputs');
$start_odo_image->name('start_odo_image');
$start_odo_image->id('start_odo_image');
$start_odo_image->style('width:80%');

$end_label = new label();
$end_label->for('odo_after');
$end_label->value('ODO AFTER');

$end_odo_image = new file_upload();
$end_odo_image->class('inputs');
$end_odo_image->name('end_odo_image');
$end_odo_image->id('end_odo_image');
$end_odo_image->style('width:80%');

$clear_from = new Button();
$clear_from->value("CLEAR");
$clear_from->onclick("signaturePad_from.clear()");

$clear_received = new Button();
$clear_received->value("CLEAR");
$clear_received->onclick("signaturePad_received.clear()");

$received_by_siganture = new signatures();
$received_by_siganture->id("received_by_signature");
$received_by_siganture->name("received_by_signature");
$received_by_siganture->send_file_path("../consumables/upload.php");
$received_by_siganture->submit_btn_id("submit_btn");

$received_from_siganture = new signatures();
$received_from_siganture->id("received_from_signature");
$received_from_siganture->name("received_from_signature");
$received_from_siganture->send_file_path("../consumables/upload.php");
$received_from_siganture->submit_btn_id("submit_btn");

$submit_btn = new Button();
$submit_btn->value("SUBMIT");
$submit_btn->onclick("submit_form()");
$submit_btn->id("submit_btn");

?>

<div class="form_down">
    <h1>ADD CONSUMABLES</h1>
    <?php
    $received_from_label->add();
    $received_from->add();
    $received_by_label->add();
    $received_by->add();
    $type_label->add();
    // $type->add();
    ?>
    <select name="type" id="type" onchange="getType()" class="inputs">
        <option value=" ">TYPE</option>
        <option value="drilling">DRILLING</option>
        <option value="casing">CASING</option>
    </select>

    <div id="casing" style="display: none;">
        <?php
        $quantity->add();
        ?>
    </div>

    <div id="drilling" style="display: none;justify-content:space-evenly; width: 80%;background-color:white;border-radius:2vw;">
        <div style="display:flex;flex-direction:column;border-radius:2vw;">
            <?php
            $start_label->add();
            $start_odo_image->add();
            $start_odo->add();
            ?>
        </div>
        <div style="display:flex;flex-direction:column;border-radius:2vw;">
            <?php
            $end_label->add();
            $end_odo_image->add();
            $odo_after->add();
            ?>
        </div>
    </div>

    <div style="display:flex; width:100%; justify-content:space-evenly">
        <div>
            <h3> RECIEVED FROM </h3>
            <!-- <canvas id="received_from_signature_pad" class="signature-pad" width=300 height=200
                style='background-color:lightgrey;border-radius:20px;'></canvas><br> -->
            <div style="display:flex;justify-content: center;">
                <?php
                $received_from_siganture->add();
                // $clear_from->add();
                ?>
            </div>
        </div>
        <div>
            <h3> RECEIVED BY </h3>
            <!-- <canvas id="received_by_signature_pad" class="signature-pad" width=300 height=200
                style='background-color:lightgrey;border-radius:20px;'></canvas><br> -->
            <div style="display:flex;justify-content: center;">
                <?php
                // $clear_received->add();
                $received_by_siganture->add();
                ?>
            </div>
        </div>
    </div>
    <br>
    <?php
    $submit_btn->add();
    ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js"></script>

<script>
    var canvas = document.getElementById('received_from_signature_pad');
    var signaturePad_from = new SignaturePad(canvas);

    var canvas = document.getElementById('received_by_signature_pad');
    var signaturePad_received = new SignaturePad(canvas);

    function getType() {
        var type = document.getElementById('type').value.trim().toLowerCase();
        var drilling = document.getElementById('drilling');
        var casing = document.getElementById('casing');

        if (type === 'drilling') {
            drilling.style.display = 'flex';
            casing.style.display = 'none';
        } else if (type === 'casing') {
            casing.style.display = 'block';
            drilling.style.display = 'none';
        } else {
            // Hide both if "TYPE" is selected or value is empty
            drilling.style.display = 'none';
            casing.style.display = 'none';
        }
    }

</script>

<?php
