<?php
require('../../fpdf.php');
include "../../root.class.php";


$db = new db_safeguard();
$jobcard_res = $db->query("jobcards", "SELECT * FROM jobcards");
$jobcard = $jobcard_res->fetch_assoc();

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('p');

$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(200, 15, "CLIENTS", 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);

$pdf->Cell(50, 8, "NAME", 1, 0, 'L');
$pdf->Cell(50, 8, "CONTACT NUMBER", 1, 0, 'L');
$pdf->Cell(40, 8, "LOCATION", 1, 0, 'L');
$pdf->Cell(50, 8, "CO-ORDINATES", 1, 1, 'L');

$clients_res = $db->query("clients", "SELECT * FROM clients ORDER BY record_id ASC");
if ($clients_res->num_rows == 0) {
    $error = 1;
} else {
    while ($clients = $clients_res->fetch_assoc()) {
        $pdf->Cell(50, 8, $clients['name'], "LB", 0, 'L');
        $pdf->Cell(50, 8, $clients['contact_number'], "LBR", 0, 'L');
        $pdf->Cell(40, 8, $clients['location'], "LBR", 0, 'L');
        $pdf->Cell(50, 8, $clients['co_ordinates'], "LBR", 1, 'L');
    }
}

$pdf->Output("I");