<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
$db = new db_safeguard();
$html->check_user_type("ADMIN");

$record_id = new input();
$record_id->type("hidden");
$record_id->name("record_id");
$record_id->value($_GET["record_id"]);
$record_id->id("record_id");
$record_id->name("record_id");

$name_label = new label();
$name_label->for("name");
$name_label->value("TEAM NAME");

$name = new input();
$name->class("inputs");
$name->type("text");
$name->placeholder("NAME");
$name->name("name");
$name->id("name");
$name->value_from_db("teams", "name", "record_id =  {$_GET["record_id"]}");

$asset_rows = new input();
$asset_rows->type("text");
$asset_rows->class("submit_btn");
$asset_rows->readonly();
$asset_rows->onclick("add_assets()");
$asset_rows->value("ADD ASSETS");

$team_rows = new input();
$team_rows->type("text");
$team_rows->class("submit_btn");
$team_rows->readonly();
$team_rows->onclick("add_teams()");
$team_rows->value("ADD TEAMS");

$status_label = new label();
$status_label->for("status");
$status_label->value("STATUS");

$status = new select();
$status->class("inputs");
$status->name("status");
$status->id("status");
$status->add_option("", "STATUS");
$status->add_option("ACTIVE", "ACTIVE");
$status->add_option("INACTIVE", "INACTIVE");

$submit_btn = new button();
$submit_btn->value("UPDATE");
// $submit_btn->onclick("ajax_function()");

$ass_type_res = $db->query("asset_type", "SELECT * FROM asset_type");
$asset_types = [];
while ($ass_type = $ass_type_res->fetch_assoc()) {
    $asset_types[] = $ass_type['name'];

    $ass_res = $db->query("assets", "SELECT * FROM assets WHERE asset_type_id = $ass_type[record_id]");
    $ass_num = $ass_res->num_rows;
    $ass_per_col = ceil($ass_num / 3);

    $assets = [];
    while ($ass = $ass_res->fetch_assoc()) {
        $assets[] = $ass['name'];
    }


    $table_blocks = $table_blocks . "<table hidden name='blocks_tables' style='width:70%; text-align: center;' id='blocks_{$ass_type['record_id']}'>";

    for ($i = 0; $i < $ass_per_col; $i++) {
        $table_blocks = $table_blocks . "<tr style='display: flex; align-items: center; justify-content: space-around;'>";
        for ($j = 0; $j < 3; $j++) {
            $index = $i + ($j * $ass_per_col);
            if (isset($assets[$index])) {
                $table_blocks = $table_blocks . "<td style='display: flex; align-items: center; width: 25%;'><input type='checkbox' name='{$assets[$index]}' value='{$assets[$index]}' style='height: 2vw; width: 2vw;'><label for='{$assets[$index]}' value='{$index}'>{$assets[$index]}</label></td>";
            }
        }
        $table_blocks = $table_blocks . "</tr>";
    }
    $table_blocks = $table_blocks . "</table>";
}

$ass_options = "";
$ass_type_options = "";

//////

$teams_data_res = $db->query("teams", "SELECT * FROM teams WHERE record_id = {$_GET["record_id"]}");
$teams_data = $teams_data_res->fetch_assoc();

$assets_names = explode(", ", $teams_data["assigned_assets"]);

//get the number of values in the array
$num_assets = count($assets_names);

foreach ($assets_names as $asset_name) {
    $ass_options = $ass_options . "<option value='{$asset_name}'>{$asset_name}</option>";
}

$member_name = explode(", ", $teams_data["team_members"]);

$num_members = count($member_name);

$all_assets_res = $db->query("assets", "SELECT * FROM assets");

$all_assets_options = "<option></option>";
while ($all_assets = $all_assets_res->fetch_assoc()) {
    $all_assets_options = $all_assets_options . "<option value='{$all_assets['name']}'>{$all_assets['name']}</option>";
}

$all_users_res = $db->query("users", "SELECT * FROM users");

$all_users_options = "<option></option>";
while ($all_users = $all_users_res->fetch_assoc()) {
    $all_users_options = $all_users_options . "<option value='{$all_users['username']}'>{$all_users['username']}</option>";
}

?>

<form action="update_teams.ajax.php" method="POST">
    <div class="form_down">
        <h1>EDIT TEAM</h1>
        <?php
        $record_id->add();
        $name_label->add();
        $name->add();
        ?>
        <br>
        <div
            style="display: flex; flex-direction: row; align-items: center; justify-content: space-around; width: 90%;">
            <div style="display: flex; flex-direction: column; width: 40%;align-items: center;">
                <?php
                $no_assets_rows = new input();
                $no_assets_rows->type("hidden");
                $no_assets_rows->name("no_asset_row");
                $no_assets_rows->id("no_asset_row");
                $no_assets_rows->value($num_assets);
                $no_assets_rows->add(); ?>
                <table id="assets"
                    style="border-collapse: collapse; background-color: whitesmoke;border: 2px solid black; text-align: center; width: 100%;">
                    <tr>
                        <th style="padding: 0.5vw;">ASSETS</th>
                    </tr>

                    <?php
                    for ($i = 0; $i < $num_assets; $i++) {
                        ?>
                        <tr style="border: 2px solid black;">
                            <td style="display: flex; padding: 0.5vw;">
                                <button type="button" class="submit_btn"
                                    style="width: 20%;display:flex;margin: 0.5vw auto;">X</button>
                                <select name="assigned_asset_<?php echo $i; ?>" id="assigned_asset_<?php echo $i; ?>"
                                    style="width: 70%;margin: 0.5vw auto;" class="inputs">
                                    <?php
                                    // loop through all assets and mark the one that matches as selected
                                    $all_assets_res2 = $db->query("assets", "SELECT * FROM assets");
                                    while ($all_assets2 = $all_assets_res2->fetch_assoc()) {
                                        $selected = ($all_assets2['name'] === $assets_names[$i]) ? "selected" : "";
                                        echo "<option value='{$all_assets2['name']}' $selected>{$all_assets2['name']}</option>";
                                    }
                                    ?>
                                </select>
                            </td>
                        </tr>
                        <?php
                    }

                    ?>
                </table>
                <?php
                $asset_rows->add();
                ?>
            </div>

            <div style="display: flex; flex-direction: column;width: 40%;align-items: center;">
                <?php
                $no_team_rows = new input();
                $no_team_rows->type("hidden");
                $no_team_rows->name("no_team_row");
                $no_team_rows->id("no_team_row");
                $no_team_rows->value($num_members);
                $no_team_rows->add(); ?>
                <table id="teams"
                    style="border-collapse: collapse; background-color: whitesmoke;border: 2px solid black; text-align: center; width: 100%;">
                    <tr>
                        <th style="padding: 0.5vw;">TEAMS</th>
                    </tr>

                    <?php
                    for ($i = 0; $i < $num_members; $i++) {
                        ?>
                        <tr style="border: 2px solid black;">
                            <td style="display: flex; padding: 0.5vw;">
                                <button type="button" class="submit_btn"
                                    style="width: 20%;display:flex;margin: 0.5vw auto;">X</button>
                                <select name="team_members_<?php echo $i; ?>" id="team_members_<?php echo $i; ?>"
                                    style="width: 70%;margin: 0.5vw auto;" class="inputs">
                                    <?php
                                    $all_users_res2 = $db->query("users", "SELECT * FROM users");
                                    while ($all_users2 = $all_users_res2->fetch_assoc()) {
                                        $selected = ($all_users2['username'] === $member_name[$i]) ? "selected" : "";
                                        echo "<option value='{$all_users2['username']}' $selected>{$all_users2['username']}</option>";
                                    }
                                    ?>
                                </select>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </table>
                <?php
                $team_rows->add();
                ?>
            </div>
        </div>

        <?php
        $status_label->add();
        $status->add();
        $submit_btn->add();
        ?>
    </div>
</form>


<script>

    var num_assets_rows = document.getElementById("no_asset_row").value;
    var num_team_rows = document.getElementById("no_team_row").value;

    function add_assets() {

        num_assets_rows++;

        document.getElementById("no_asset_row").value = parseInt(document.getElementById("no_asset_row").value) + 1;

        const table = document.getElementById("assets");
        table.id = "assets";
        table.style.width = "100%";
        table.style.textAlign = "center";
        table.style.borderCollapse = "collapse";
        table.style.backgroundColor = "whitesmoke";
        table.style.border = "2px solid black";

        var row = document.createElement("tr");
        row.style.border = "2px solid black";

        var td = document.createElement("td");
        td.style.padding = "0.5vw";
        td.style.display = "flex";

        var select = document.createElement("select");
        select.name = "assigned_asset_" + num_assets_rows;
        select.id = "assigned_asset_" + num_assets_rows;
        select.className = "inputs";
        select.innerHTML = "<?php echo $all_assets_options; ?>";
        select.style.width = "70%";
        select.style.margin = "0.5vw auto";

        //create a remove row button
        var removeRow = document.createElement("button");
        removeRow.className = "submit_btn";
        removeRow.innerHTML = "X";
        removeRow.style.width = "20%";
        removeRow.style.margin = "0.5vw auto";
        removeRow.addEventListener("click", function () {
            table.deleteRow(row.rowIndex);
        });

        td.appendChild(removeRow);
        td.appendChild(select);
        row.appendChild(td);
        table.appendChild(row);

    }

    function add_teams() {

        num_team_rows++;

        //num_team_rows plus 1
        document.getElementById("no_team_row").value = parseInt(document.getElementById("no_team_row").value) + 1;


        const table = document.getElementById("teams");
        table.id = "teams";
        table.style.width = "100%";
        table.style.textAlign = "center";
        table.style.borderCollapse = "collapse";
        table.style.backgroundColor = "whitesmoke";
        table.style.border = "2px solid black";

        var row = document.createElement("tr");
        row.style.border = "2px solid black";

        var td = document.createElement("td");
        td.style.padding = "0.5vw";
        td.style.display = "flex";

        var select = document.createElement("select");
        select.name = "team_members_" + num_team_rows;
        select.id = "team_members_" + num_team_rows;
        select.className = "inputs";
        select.innerHTML = "<?php echo $all_users_options; ?>";
        select.style.width = "70%";
        select.style.margin = "0.5vw auto";

        //create a remove row button
        var removeRow = document.createElement("button");
        removeRow.className = "submit_btn";
        removeRow.innerHTML = "X";
        removeRow.style.width = "20%";
        removeRow.style.margin = "0.5vw auto";
        removeRow.addEventListener("click", function () {
            table.deleteRow(row.rowIndex);
        });

        td.appendChild(removeRow);
        td.appendChild(select);
        row.appendChild(td);
        table.appendChild(row);

    }

</script>