// Hard-coded product data
const products = [
    {
        id: 'P001',
        name: 'Brake Pads Set',
        year: '2015-2020',
        category: 'Braking',
        description: 'High-performance ceramic brake pads for superior stopping power.',
        price: 75.99,
        image: 'https://source.unsplash.com/400x300/?brake-pads'
    },
    {
        id: 'P002',
        name: 'Oil Filter',
        year: '2010-2023',
        category: 'Engine',
        description: 'Premium synthetic oil filter for extended engine life.',
        price: 12.50,
        image: 'https://source.unsplash.com/400x300/?oil-filter'
    },
    {
        id: 'P003',
        name: 'Spark Plugs (4-pack)',
        year: '2012-2018',
        category: 'Engine',
        description: 'Iridium spark plugs for improved ignition and fuel efficiency.',
        price: 35.00,
        image: 'https://source.unsplash.com/400x300/?spark-plugs'
    },
    {
        id: 'P004',
        name: 'Suspension Strut',
        year: '2016-2021',
        category: 'Suspension',
        description: 'Complete front suspension strut assembly for smooth ride.',
        price: 180.00,
        image: 'https://source.unsplash.com/400x300/?car-strut'
    },
    {
        id: 'P005',
        name: 'LED Headlight Bulbs',
        year: 'All Years',
        category: 'Lighting',
        description: 'Bright LED bulbs for improved night visibility.',
        price: 60.00,
        image: 'https://source.unsplash.com/400x300/?led-headlights'
    },
    {
        id: 'P006',
        name: 'Air Filter',
        year: '2018-2024',
        category: 'Engine',
        description: 'High-flow air filter for better engine performance.',
        price: 25.99,
        image: 'https://source.unsplash.com/400x300/?air-filter'
    },
    {
        id: 'P007',
        name: 'Wheel Bearing Kit',
        year: '2010-2017',
        category: 'Chassis',
        description: 'Durable front wheel bearing kit for quiet operation.',
        price: 95.00,
        image: 'https://source.unsplash.com/400x300/?wheel-bearing'
    },
    {
        id: 'P008',
        name: 'Serpentine Belt',
        year: '2005-2015',
        category: 'Engine',
        description: 'Heavy-duty serpentine belt for reliable accessory drive.',
        price: 30.50,
        image: 'https://source.unsplash.com/400x300/?car-belt'
    },
    {
        id: 'P009',
        name: 'Radiator',
        year: '2013-2019',
        category: 'Cooling',
        description: 'OEM quality radiator for optimal engine cooling.',
        price: 210.00,
        image: 'https://source.unsplash.com/400x300/?car-radiator'
    },
    {
        id: 'P010',
        name: 'Wiper Blades (Pair)',
        year: 'All Years',
        category: 'Exterior',
        description: 'All-season premium wiper blades for clear visibility.',
        price: 28.00,
        image: 'https://source.unsplash.com/400x300/?wiper-blades'
    }
];

document.addEventListener('DOMContentLoaded', () => {
    const productGrid = document.getElementById('product-grid');
    const partNameInput = document.getElementById('filter-part-name');
    const yearModelSelect = document.getElementById('filter-year-model');
    const categorySelect = document.getElementById('filter-category');
    const applyFiltersBtn = document.getElementById('apply-filters-btn');

    // Populate year model and category filters dynamically from products
    populateFilters();
    renderProducts(products); // Initial render of all products

    applyFiltersBtn.addEventListener('click', applyFilters);

    function populateFilters() {
        // Populate Year Models
        const years = [...new Set(products.map(p => p.year))].sort((a, b) => {
            const getStartYear = (str) => parseInt(str.split('-')[0]);
            return getStartYear(a) - getStartYear(b);
        });
        years.forEach(year => {
            const option = document.createElement('option');
            option.value = year;
            option.textContent = year;
            yearModelSelect.appendChild(option);
        });

        // Populate Categories
        const categories = [...new Set(products.map(p => p.category))].sort();
        categories.forEach(category => {
            const option = document.createElement('option');
            option.value = category;
            option.textContent = category;
            categorySelect.appendChild(option);
        });
    }


    function renderProducts(filteredProducts) {
        productGrid.innerHTML = ''; // Clear existing products

        if (filteredProducts.length === 0) {
            productGrid.innerHTML = '<p class="empty-cart-message">No products found matching your criteria.</p>';
            return;
        }

        filteredProducts.forEach(product => {
            const productCard = document.createElement('div');
            productCard.classList.add('product-card');

            productCard.innerHTML = `
                <img src="${product.image}" alt="${product.name}">
                <div class="product-info">
                    <h3>${product.name}</h3>
                    <p>Year Model: ${product.year}</p>
                    <p>Category: ${product.category}</p>
                    <p>${product.description}</p>
                    <div class="product-price">R${product.price.toFixed(2)}</div>
                    <button class="add-to-cart-btn" data-product-id="${product.id}">Add to Cart</button>
                </div>
            `;
            productGrid.appendChild(productCard);
        });

        // Add event listeners to "Add to Cart" buttons
        document.querySelectorAll('.add-to-cart-btn').forEach(button => {
            button.addEventListener('click', (event) => {
                const productId = event.target.dataset.productId;
                const productToAdd = products.find(p => p.id === productId);
                if (productToAdd) {
                    addToCart(productToAdd); // Use the global addToCart function
                }
            });
        });
    }

    function applyFilters() {
        const partName = partNameInput.value.toLowerCase().trim();
        const yearModel = yearModelSelect.value;
        const category = categorySelect.value;

        const filtered = products.filter(product => {
            const matchesPartName = product.name.toLowerCase().includes(partName);
            const matchesYearModel = yearModel === '' || product.year === yearModel;
            const matchesCategory = category === '' || product.category === category;

            return matchesPartName && matchesYearModel && matchesCategory;
        });
        renderProducts(filtered);
    }
});