<?php include "../../root.class.php";
$html = new html();
$db = new db_safeguard();
$html->add_styles_page();
// $html->check_user_type("ADMIN");
// HTML FORM ELEMENTS

$status = new input();
$status->id("status");
$status->name("status");
$status->class();
$status->type("hidden");
$status->value(0);
$status->readonly();
$status->required();

$user_id = new input();
$user_id->id("user_id");
$user_id->name("user_id");
$user_id->type("hidden");
$user_id->value($_SESSION['user_id']);
$user_id->readonly();
$user_id->required();

$date_created = new input();
$date_created->type("date");
$date_created->readonly();
$date_created->required();
$date_created->id("date");
$date_created->name("date");
$date_created->value(date("Y-m-d"));

$to_date = new input();
$to_date->type("date");
$to_date->required();
$to_date->id("to_date");
$to_date->name("to_date");
$to_date->onchange("date_workout()");

$from_date = new input();
$from_date->type("date");
$from_date->required();
$from_date->id("start_date");
$from_date->name("start_date");


$amount = new input();
$amount->id("amount");
$amount->name("amount");
$amount->readonly();
$amount->required();



$type = new input();
$type->id("type");
$type->name("type");
$type->value("LEAVE");
$type->type("text");
$type->readonly();
$type->required();


$remaining_amount = new input();
$remaining_amount->id("remaining_amount");
$remaining_amount->name("remaining_amount");
$remaining_amount->readonly();
$remaining_amount->required();

$leave_days_active = new input();
$leave_days_active->class();
$leave_res = $db->query("leavedays_trans", "SELECT SUM(amount) as total FROM leavedays_trans WHERE user_id = {$_SESSION['user_id']} AND `status` = 1");
$leave_days_active->value($leave_res->fetch_assoc()['total']);
$leave_days_active->id("leave_days_active");
$leave_days_active->name("leave_days_active");

$submit_btn = new button();
$submit_btn->class();
$submit_btn->value("REQUEST");
$submit_btn->onclick("edit_leave()");

// ajax
?>

<div class="form_down">
    <h1>REQUEST LEAVE</h1>
    <?php
    $status->add();
    $type->add();
    $user_id->add();
    $date_created->add();
    echo "<label class='labels'>START OF LEAVE</label>";
    $from_date->add();
    echo "<label class='labels'>DAY YOUR BACK</label>";
    $to_date->add();
    echo "<label class='labels'>YOUR LEAVE DAYS</label>";
    $leave_days_active->add();
    echo "<label class='labels'>CALCULATED AMOUNT</label>";
    $amount->add();
    echo "<div id='additional_data'></div>";
    echo "<label class='labels'>REMAINING AMOUNT</label>";
    $remaining_amount->add();

    $submit_btn->add();
    ?>

</div>

<?php
$ajax = new js_ajax();
$ajax->function_name("edit_leave");
$ajax->submit_btn_id("submit");
$ajax->insert("leavedays_trans");
$ajax->on_success("SUCCESSFULLY UPDATED");
$ajax->exclude_inputs("remaining_amount,leave_days_active");
$admins_res = $db->query("users", "SELECT * FROM `users` WHERE `user_type` = 'ADMIN'");
$emails = "";
while ($admins = $admins_res->fetch_assoc()) {
    $emails .= $admins['email'] . ",";
}
$ajax->send_email_on_success($emails, "LEAVE REQUEST EWG", "THERE IS A LEAVE REQUEST AWAITING YOUR APPROVAL");

?>

<script>
    function date_workout() {
        var public_holidays = ["2025-01-01", "2025-03-21", "2025-04-18", "2025-04-21", "2025-04-27", "2025-05-01", "2025-06-16", "2025-08-09", "2025-09-24", "2025-12-16", "2025-12-25", "2025-12-26"];
        var from_date = document.getElementById("start_date").value;
        var to_date = document.getElementById("to_date").value;
        var holidays = []; // You would populate this array with date strings (YYYY-MM-DD)
        var start_date = new Date(from_date);
        var end_date = new Date(to_date);
        var amount = 0;
        var one_day = 24 * 60 * 60 * 1000;
        var excluded_dates_info = [];


        for (var i = new Date(start_date); i <= end_date; i.setDate(i.getDate() + 1)) {
            var is_public_holiday = false;
            var is_holiday = false;
            var is_weekend = false;
            var currentDate = i.toISOString().slice(0, 10);
            var dayOfWeek = i.getDay(); // 0 for Sunday, 6 for Saturday

            if (dayOfWeek === 0 || dayOfWeek === 6) {
                is_weekend = true;
                excluded_dates_info.push({ date: currentDate, reason: "Weekend" });
                continue; // Skip to the next iteration if it's a weekend
            }

            for (var j = 0; j < public_holidays.length; j++) {
                if (currentDate == public_holidays[j]) {
                    is_public_holiday = true;
                    excluded_dates_info.push({ date: currentDate, reason: "Public Holiday" });
                    break;
                }
            }

            if (is_public_holiday) {
                continue; // Skip to the next iteration if it's a public holiday
            }

            for (var j = 0; j < holidays.length; j++) {
                if (currentDate == holidays[j]) {
                    is_holiday = true;
                    excluded_dates_info.push({ date: currentDate, reason: "Holiday" });
                    break;
                }
            }

            if (!is_holiday) {
                amount++;
            }
        }
        amount = amount - 1;
        document.getElementById("amount").value = "-" + amount;
        document.getElementById("remaining_amount").value = document.getElementById("leave_days_active").value * 1 - amount* 1;

        // Display information about excluded dates
        var additionalDataDiv = document.getElementById("additional_data");
        if (additionalDataDiv) {
            if (excluded_dates_info.length > 0) {
                var excludedText = "Dates not counted:<br>";
                excluded_dates_info.forEach(function (item) {
                    excludedText += item.date + " (" + item.reason + ")<br>";
                });
                additionalDataDiv.innerHTML = excludedText;
            } else {
                additionalDataDiv.innerHTML = "No weekends or holidays excluded within the selected date range.";
            }
        }
    }
</script>