<?php
require('../../fpdf.php');
include "../../root.class.php";

function get_client_name($client_id)
{
    $db = new db_safeguard();
    $client_results = $db->query("clients", "SELECT * FROM clients WHERE record_id = '" . $client_id . "'");
    $client_data = $client_results->fetch_assoc();
    return $client_data['name'];
}

function get_work_order_type($work_order_type_id)
{
    $db = new db_safeguard();
    $work_order_type_results = $db->query("work_order_types", "SELECT * FROM work_order_types WHERE record_id = '" . $work_order_type_id . "'");
    $work_order_type_data = $work_order_type_results->fetch_assoc();
    return $work_order_type_data['name'];
}

function get_username($user_id)
{
    $db = new db_safeguard();
    $user_results = $db->query("users", "SELECT * FROM users WHERE record_id = '" . $user_id . "'");
    $user_data = $user_results->fetch_assoc();
    return $user_data['username'];
}

function remove_html($string)
{

    $description = strip_tags($string);
    $description = str_replace("\n", "\r\n", $description);
    $description = preg_replace('/\s\s+/', ' ', $description);
    $description = preg_replace('/\n\n+/', "\n", $description);
    return $description;
}

function getHourDifference($datetime1, $datetime2)
{
    $start = new DateTime($datetime1);
    $end = new DateTime($datetime2);
    $interval = $start->diff($end);
    $hours = $interval->days * 24 + $interval->h + $interval->i / 60 + $interval->s / 3600;

    // If datetime2 is earlier than datetime1, make the result negative
    if ($start > $end) {
        $hours = -$hours;
    }

    return $hours;
}


$start_date = "2025-05-01";
$stop_date = "2025-05-31";

$db = new db_safeguard();
$where_data = ' 1 ';

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('p');

$clients_res = $db->query("clients", "SELECT * FROM clients");
while ($client = $clients_res->fetch_assoc()) {
    $pdf->SetFont('Arial', 'B', 20);
    $pdf->Cell(200, 15, $client['name'], 0, 1, 'L');
    $pdf->SetFont('Arial', '', 10);
    // total service tickets
    $service_tickets_res = $db->query("service_tickets", "SELECT * FROM service_tickets WHERE client_id = '" . $client['record_id'] . "' AND date_time_created BETWEEN '" . $start_date . " 00:00' AND '" . $stop_date . " 23:59'");
    $pdf->Cell(50, 15, "TICKETS TOTAL: " . $service_tickets_res->num_rows, "B", 1, 'L');
    // $pdf->Cell(50, 8, "TICKET NUMBERS", "B", 1, 'L');

    while ($service_ticket = $service_tickets_res->fetch_assoc()) {
        // total time used
        $timeline_res = $db->query("service_ticket_timeline", "SELECT * FROM service_ticket_timeline WHERE service_ticket_id = '" . $service_ticket['record_id'] . "' ORDER BY record_id ASC");
        $pdf->Cell(50, 8, $service_ticket['record_id'], "L", 1, 'L');
        $pdf->SetFont('Arial', '', 5);

        while ($timeline = $timeline_res->fetch_assoc()) {

            // get start_time
            $start_time = '';
            $stop_time = '';
            if ($timeline['status'] == 'start') {
                $start_time = $timeline['date_time'];
            }
            if ($timeline['status'] == "stop") {
                $stop_time = $timeline['date_time'];
                $pdf->Cell(50, 8, $start_time, "L", 1, 'L');
                $pdf->Cell(50, 8, $stop_time, "L", 1, 'L');
                $total_hours += getHourDifference($start_time, $stop_time);
                $pdf->Cell(50, 8, getHourDifference($start_time, $stop_time), "L", 1, 'L');
                $start_time = '';
                $stop_time = '';

            }

        }
    }
    $pdf->Cell(50, 8, "Work Hours Difference", "B", 0, 'L');
    $pdf->Cell(50, 8, $total_hours, "B", 1, 'L');
    $total_hours = 0;



}





$pdf->Output("I");
