<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mobile Dev Playground</title>
    <style>
        body {
            font-family: sans-serif;
            display: flex;
            flex-direction: row;
            align-items: center;
            padding: 20px;
            /* background-color: #f4f4f4; */
            align-content: center;
            justify-content: center;
        }


        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            display: flex;
            grid-template-columns: auto auto auto;
            gap: 15px;
            align-items: center;
            flex-direction: column;
        }

        label {
            font-weight: bold;
        }

        input[type="number"],
        input[type="url"] {
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            width: 200px;
            /* Increased width for URL input */
        }

        button {
            background-color: #6c757d;
            /* Gray color for reload button */
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #545b62;
        }

        button[type="submit"] {
            background-color: #007bff;
            grid-column: 1 / span 3;
            /* Make the update button span all columns */
            text-align: center;
        }

        button[type="submit"]:hover {
            background-color: #0056b3;
        }

        iframe {
            border: 1px solid #ccc;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            width: 100%;
            /* Make iframe responsive by default */
            max-width: 800px;
            /* Set a maximum width if needed */
            height: 500px;
            /* Adjust default height as needed */
        }

        h1 {
            color: #333;
            margin-bottom: 20px;
        }
    </style>
    <style>
        /* ... (Your existing CSS) ... */
        .loading-spinner {
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-top: 4px solid #3498db;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 2s linear infinite;
            margin-left: 10px;
            display: none;
            /* Hidden by default */
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
    <script>
        function updateIframe() {
            const iframe = document.getElementById('siteIframe');
            const widthInput = document.getElementById('widthInput');
            const heightInput = document.getElementById('heightInput');
            const urlInput = document.getElementById('urlInput');

            iframe.src = urlInput.value;
            iframe.style.width = widthInput.value + 'px';
            iframe.style.height = heightInput.value + 'px';
        }

        function reloadIframe() {
            const iframe = document.getElementById('siteIframe');
            const reloadButton = document.getElementById('reloadButton');
            const loadingSpinner = document.getElementById('loadingSpinner');

            loadingSpinner.style.display = 'inline-block';
            reloadButton.disabled = true; // Prevent multiple clicks

            iframe.onload = function () {
                console.log("Iframe reloaded successfully.");
                loadingSpinner.style.display = 'none';
                reloadButton.disabled = false;
                iframe.onload = null; // Remove the event listener after it's triggered once
                iframe.onerror = null; // Remove the error listener as well
            };

            iframe.onerror = function () {
                console.error("Error reloading iframe content.");
                alert("There was an error reloading the website. Please try again.");
                loadingSpinner.style.display = 'none';
                reloadButton.disabled = false;
                iframe.onload = null;
                iframe.onerror = null;
            };

            iframe.contentWindow.location.reload(); // Standard reload
        }
    </script>
</head>

<body>
    <form onsubmit="event.preventDefault(); updateIframe();">
        <label for="urlInput">Website URL:</label>
        <input type="url" id="urlInput" name="url" required value="https://systems.elegantwork.co.za">

        <label for="widthInput">Width (px):</label>
        <input type="number" id="widthInput" name="width" value="1000" required>

        <label for="heightInput">Height (px):</label>
        <input type="number" id="heightInput" name="height" value="1900" required>

        <button type="submit">Update View</button>
        <button type="button" id="reloadButton" onclick="reloadIframe()">Reload</button>
        <div id="loadingSpinner" class="loading-spinner"></div>
    </form>

    <iframe id="siteIframe" src="https://systems.elegantwork.co.za" style="border:none;"></iframe>

</body>

</html>