<?php
session_start();
$db = new mysqli($_SESSION['server'], $_SESSION['username'], $_SESSION['password'], $_SESSION['database']);

if ($db->connect_error) {
    die("Connection failed: " . $db->connect_error);
}
$record_id = $_GET['record_id'];
$query = "SHOW TABLES";
$result = $db->query($query);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>List Tables</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table th,
        table td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }

        table th {
            background-color: #4CAF50;
            color: white;
        }

        .btn {
            background-color: #f44336;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .btn:hover {
            background-color: #d32f2f;
        }

        .action-btns {
            display: flex;
            justify-content: space-between;
        }

        .btn-action {
            background-color: #008CBA;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .btn-action:hover {
            background-color: #007B9F;
        }
    </style>
</head>

<body>

    <div class="container">
        <a href="db.php?record_id=<?= $record_id ?>" class="btn-action">BACK</a>
        <h1>All Tables in Database</h1>

        <table>
            <thead>
                <tr>
                    <th>Table Name</th>
                    <th>Records Count</th>
                    <th>Table Size (MB)</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_row()):
                    $table_name = $row[0];
                    // Get the number of records
                    $record_count = $db->query("SELECT COUNT(*) FROM $table_name")->fetch_row()[0];
                    // Get table size in bytes
                    $size = $db->query("SHOW TABLE STATUS LIKE '$table_name'")->fetch_assoc();
                    $size_in_mb = round($size['Data_length'] / 1048576, 2); // Convert to MB
                    ?>
                    <tr>
                        <td><?php echo $table_name; ?></td>
                        <td><?php echo $record_count; ?></td>
                        <td><?php echo $size_in_mb . ' MB'; ?></td>
                        <td class="action-btns">
                            <a href="delete_table.php?table=<?php echo $table_name; ?>&record_id=<?= $record_id ?>"
                                class="btn-action">Drop</a>
                            <a href="empty_table.php?table=<?php echo $table_name; ?>&record_id=<?= $record_id ?>"
                                class="btn-action">Empty</a>
                            <a href="modify_table.php?table=<?php echo $table_name; ?>&record_id=<?= $record_id ?>"
                                class="btn-action">Modify</a>
                            <a href="insert.php?table=<?php echo $table_name; ?>&record_id=<?= $record_id ?>"
                                class="btn-action">Insert</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

</body>

</html>

<?php
$db->close();
?>