<?php
session_start();

// DB Connection
$conn = new mysqli($_SESSION['server'], $_SESSION['username'], $_SESSION['password'], $_SESSION['database']);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$table = $_POST['table_name'] ?? '';
$columns = $_POST['column_name'] ?? [];
$currentColumns = [];
$primaryKeyColumn = '';

// Get existing columns and PK
$res = $conn->query("SHOW COLUMNS FROM `$table`");
while ($row = $res->fetch_assoc()) {
    $currentColumns[$row['Field']] = [
        'Type' => $row['Type'],
        'Null' => $row['Null'],
        'Key' => $row['Key'],
        'Default' => $row['Default'],
        'Extra' => $row['Extra'],
    ];

    if ($row['Key'] === 'PRI') {
        $primaryKeyColumn = $row['Field'];
    }
}

$submittedNames = [];

for ($i = 0; $i < count($columns); $i++) {
    $name = $_POST['column_name'][$i];
    $type = $_POST['column_type'][$i];
    $length = $_POST['column_length'][$i];
    $null = isset($_POST['column_null'][$i]) ? "NULL" : "NOT NULL";
    $default = $_POST['column_default_value'][$i];
    $defaultSQL = $default !== '' ? "DEFAULT '" . $conn->real_escape_string($default) . "'" : '';
    $auto = isset($_POST['column_auto_increment'][$i]);
    $isUnique = isset($_POST['column_unique'][$i]);

    $fullType = "$type($length)";
    $submittedNames[] = $name;

    $columnExists = isset($currentColumns[$name]);

    if ($columnExists) {
        // === EXISTING COLUMN ===

        // Drop UNIQUE if exists
        $conn->query("ALTER TABLE `$table` DROP INDEX `$name`");

        // Remove AUTO_INCREMENT and PK if deselected
        if (!$auto && $currentColumns[$name]['Extra'] === 'auto_increment') {
            if ($primaryKeyColumn === $name) {
                // Remove the PRIMARY KEY from the column if it's the auto-increment column
                $conn->query("ALTER TABLE `$table` DROP PRIMARY KEY");
                $primaryKeyColumn = ''; // Reset the primary key column
            }

            // Remove AUTO_INCREMENT from the column
            $conn->query("ALTER TABLE `$table` MODIFY `$name` $fullType $null $defaultSQL");
        }

        // Rebuild MODIFY
        $autoSQL = $auto ? "AUTO_INCREMENT" : '';
        $alterQuery = "ALTER TABLE `$table` MODIFY `$name` $fullType $null $defaultSQL $autoSQL";
        $conn->query($alterQuery);

        // Add back UNIQUE if selected
        if ($isUnique) {
            $conn->query("ALTER TABLE `$table` ADD UNIQUE (`$name`)");
        }

        // Add PRIMARY KEY if auto-increment is added
        if ($auto && $primaryKeyColumn !== $name) {
            $conn->query("ALTER TABLE `$table` ADD PRIMARY KEY (`$name`)");
            $primaryKeyColumn = $name;
        }

    } else {
        // === NEW COLUMN ===
        $autoSQL = $auto ? "AUTO_INCREMENT" : '';
        $newColumnQuery = "ALTER TABLE `$table` ADD `$name` $fullType $null $defaultSQL $autoSQL";
        $conn->query($newColumnQuery);

        // Add PK if auto-increment
        if ($auto) {
            $conn->query("ALTER TABLE `$table` ADD PRIMARY KEY (`$name`)");
            $primaryKeyColumn = $name;
        }

        // Add UNIQUE if selected
        if ($isUnique) {
            $conn->query("ALTER TABLE `$table` ADD UNIQUE (`$name`)");
        }
    }
}

// DELETE REMOVED COLUMNS
foreach ($currentColumns as $existingName => $_) {
    if (!in_array($existingName, $submittedNames)) {
        $conn->query("ALTER TABLE `$table` DROP COLUMN `$existingName`");
    }
}

header("location: db.php?record_id=" . $_POST['record_id']);
?>
