<?php
require('../../fpdf.php');
include "../../root.class.php";

function get_client_name($client_id)
{
    $db = new db_safeguard();
    $client_results = $db->query("clients", "SELECT * FROM clients WHERE record_id = '" . $client_id . "'");
    $client_data = $client_results->fetch_assoc();
    return $client_data['name'];
}

function get_work_order_type($work_order_type_id)
{
    $db = new db_safeguard();
    $work_order_type_results = $db->query("work_order_types", "SELECT * FROM work_order_types WHERE record_id = '" . $work_order_type_id . "'");
    $work_order_type_data = $work_order_type_results->fetch_assoc();
    return $work_order_type_data['name'];
}

function get_username($user_id)
{
    $db = new db_safeguard();
    $user_results = $db->query("users", "SELECT * FROM users WHERE record_id = '" . $user_id . "'");
    $user_data = $user_results->fetch_assoc();
    return $user_data['username'];
}
$db = new db_safeguard();
$where_data = ' 1 ';

$pdf = new FPDF();
$pdf->AliasNbPages();
$pdf->AddPage('p');

$project_results = $db->query("projects", "SELECT * FROM projects WHERE record_id = {$_GET['project_record_id']}");
// $project_results = $db->query("projects", "SELECT * FROM projects WHERE record_id = 6");
$project_data = $project_results->fetch_assoc();

$total_project_hours = 0;


$pdf->SetFont('Arial', 'B', 20);
$pdf->Cell(200, 15, $project_data['name'], 0, 1, 'C');
$pdf->Cell(10, 5, '', 0, 1, 'L');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(50, 8, "Date Created", "B", 0, 'L');
$pdf->Cell(40, 8, $project_data['date_time_created'], "B", 0, 'L');
$pdf->Cell(15, 8, "Client", "B", 0, 'L');
$pdf->Cell(40, 8, get_client_name($project_data['client_id']), "B", 1, 'L');

$description = strip_tags($project_data['description']);
$description = str_replace("\n", "\r\n", $description);
$description = preg_replace('/\s\s+/', ' ', $description);
$description = preg_replace('/\n\n+/', "\n", $description);
$pdf->multicell(150, 8, "Description: \n" . $description, 0, 'L');
$pdf->Cell(15, 10, "", 0, 1, 'L');

// WORK ORDERS FOR PROJECT

$work_orders_res = $db->query('work_orders', "SELECT * FROM work_orders WHERE project_id = '" . $project_data['record_id'] . "'");
if ($work_orders_res->num_rows > 0) {
    $pdf->SetFont('Arial', 'B', 15);
    $pdf->Cell(150, 8, "Work Orders : " . $work_orders_res->num_rows, "B", 1, 'L');
    $pdf->SetFont('Arial', '', 10);

    while ($work_order_data = $work_orders_res->fetch_assoc()) {
        $pdf->Cell(100, 10, "", "", 1, 'L');
        $pdf->Cell(100, 10, "", "", 1, 'L');

        $pdf->Cell(150, 8, "W.O: " . $work_order_data['record_id'] . " - - " . $work_order_data['name'], "B", 1, 'L');
        $pdf->Cell(50, 8, "Date Created", "B", 0, 'L');
        $pdf->Cell(40, 8, $work_order_data['date_time_created'], "B", 0, 'L');
        $pdf->Cell(15, 8, "Type", "B", 0, 'L');
        $pdf->Cell(80, 8, get_work_order_type($work_order_data['work_order_type_id']), "B", 1, 'L');
        $pdf->Cell(50, 8, "User Created", "B", 0, 'L');
        $pdf->Cell(40, 8, get_username($work_order_data['user_id']), "B", 0, 'L');
        $pdf->Cell(50, 8, "User", "B", 0, 'L');
        $pdf->Cell(40, 8, get_username($work_order_data['user_id_assigned']), "B", 1, 'L');


        $description = strip_tags($work_order_data['description']);
        $description = str_replace("\n", "\r\n", $description);
        $description = preg_replace('/\s\s+/', ' ', $description);
        $description = preg_replace('/\n\n+/', "\n", $description);
        
        $pdf->multicell(150, 8, "W.O. Notes" . "\n" . $description, "B", 'L');
        $pdf->Cell(15, 8, "", 0, 1, 'L');

        $user_notes = strip_tags($work_order_data['notes']);
        $user_notes = str_replace("\n", "\r\n", $user_notes);
        $user_notes = preg_replace('/\s\s+/', ' ', $user_notes);
        $user_notes = preg_replace('/\n\n+/', "\n", $user_notes);
        $pdf->multicell(150, 8, "User Notes" . "\n" . $user_notes, "B", 'L');
        $pdf->Cell(15, 8, "", 0, 1, 'L');


        $timeline_res = $db->select_query('work_order_timeline', '*', "work_order_id = {$work_order_data['record_id']} ORDER BY record_id ASC");
        while ($timeline = $timeline_res->fetch_assoc()) {
            // $pdf->Cell(35, 8, $timeline['date_time'], "B", 0, 'L');
            // $pdf->Cell(35, 8, $timeline['status'], "B", 0, 'L');
            // $pdf->Cell(40, 8, get_username($timeline['user_id']), "B", 1, 'L');
            if ($timeline['status'] == 'start') {
                $start_date_time = $timeline['date_time'];
            }
            if ($timeline['status'] == 'stop') {
                $stop_date_time = $timeline['date_time'];
                $start = new DateTime($start_date_time);
                $stop = new DateTime($stop_date_time);
                $interval = $start->diff($stop);
                $hours_difference = $interval->format('%h') + ($interval->format('%i') / 60);
                $total_hours = isset($total_hours) ? $total_hours + $hours_difference : $hours_difference;
                // $pdf->Cell(50, 8, "Work Hours Difference", "B", 0, 'L');
                // $pdf->Cell(50, 8, $interval->format('%h:%i'), "B", 1, 'L');
            }

            // $pdf->Cell(15, 8, "", 0, 1, 'L');



            if ($timeline['status'] == 'review_start') {
                $start_date_time = $timeline['date_time'];
            }
            if ($timeline['status'] == 'review_stop') {
                $stop_date_time = $timeline['date_time'];
                $review_start = new DateTime($start_date_time);
                $review_stop = new DateTime($stop_date_time);
                $review_interval = $review_start->diff($review_stop);
                $review_hours_difference = $review_interval->format('%h') + ($review_interval->format('%i') / 60);
                $total_review_hours = isset($total_review_hours) ? $total_review_hours + $review_hours_difference : $review_hours_difference;
                // $pdf->Cell(50, 8, "Review Hours Difference", "B", 0, 'L');
                // $pdf->Cell(50, 8, $review_interval->format('%h:%i'), "B", 1, 'L');
            }

        }

        $total_project_hours = $total_project_hours + $total_review_hours + $total_hours;

        $pdf->Cell(50, 8, "Total Review Hours", "B", 0, 'L');
        $pdf->Cell(50, 8, "Hours: " . round($total_review_hours, 2), "B", 1, 'L');
        $total_review_hours = 0;

        $pdf->Cell(50, 8, "Total Work Hours", "B", 0, 'L');
        $pdf->Cell(50, 8, "Hours: " . round($total_hours, 2), "B", 1, 'L');
        $total_hours = 0;



        $pdf->Cell(100, 10, "", "", 1, 'L');


    }



}

$pdf->Cell(100, 20, "", "B", 1, 'L');
$pdf->Cell(50, 8, "Total Project Hours", 1, 0, 'L');
$pdf->Cell(50, 8, "Hours: " . round($total_project_hours, 2), 1, 1, 'L');
$pdf->Cell(100, 20, "", "B", 1, 'L');


$pdf->AliasNbPages();
$pdf->AddPage('p');







$pdf->Output("I");
