<?php include "../../root.class.php";
$html = new html();
$html->add_styles_page();
// $html->check_user_type("ADMIN");

$db = new db_safeguard();

$stock_res = $db->query("stock_items", "SELECT * FROM stock_items WHERE 1 ORDER BY name ASC");
$datalist = "<datalist id='stock_names'>";
while ($stock = $stock_res->fetch_assoc()) {
    $datalist .= "<option value='" . $stock['record_id'] . "~" . $stock['name'] . "~" . $stock['barcode'] . "'>" . $stock['name'] . "</option>";
}
$datalist .= "</datalist>";
echo $datalist;

$name = new input();
$name->class("inputs");
$name->type("text");
$name->placeholder("Stock Name");
$name->name("stock_id");
$name->datalist("stock_names");
$name->onchange("get_stock_details(this)");
$name->required();
$name->id("stock_id");

$item_name = new input();
$item_name->class("inputs");
$item_name->type("text");
$item_name->name("item_name");
$item_name->required();
$item_name->id("item_name");

$user_id = new input();
$user_id->class("inputs");
$user_id->type("hidden");
$user_id->name("user_id");
$user_id->required();
$user_id->id("user_id");

$amount = new input();
$amount->class("inputs");
$amount->type("number");
$amount->name("amount");
$amount->placeholder("Amount");
$amount->value(1);
$amount->required();
$amount->id("amount");

$type = new select();
$type->class("inputs");
$type->add_option("", "");
$type->add_option("+", "IN");
$type->add_option("-", "OUT");
$type->required();
$type->id("type");
$type->name("type");

$barcode = new input();
$barcode->class();
$barcode->type("hidden");
$barcode->name("barcode");
$barcode->id("barcode");
$barcode->onchange("");

$submit_btn = new button();
$submit_btn->value("ADD");

$barcode_reader = new barcodeReader();
$barcode_reader->add_js_function_to_call("barcode_insert()");


// ajax
?>
<form action="save_booking.php" method="POST" autocomplete="off">
    <div class="form_down">
        <h1>BOOK STOCK</h1>
        <?php
        $barcode_reader->add_button("barcode", 0);
        $barcode->add();
        $name->add();
        $user_id->add();
        $item_name->add();
        $type->add();
        $amount->add();
        $submit_btn->add();
        ?>

    </div>
</form>

<script>
    function barcode_insert() {
        input = document.getElementById("barcode");
        let select = document.getElementById("stock_names");
        for (let i = 0; i < select.options.length; i++) {
            if (select.options[i].value.includes("~" + input.value)) {
                document.getElementById("stock_id").value = select.options[i].value;
                get_stock_details(document.getElementById("stock_id"));
                break;
            }
        }

    }
    function get_stock_details(input) {

        let data = input.value.split("~");
        input.value = data[0];
        document.getElementById("item_name").value = data[1];
        document.getElementById("barcode").value = data[2];

    }
</script>